/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.flowfilter;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.FeatureIndex;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.Model;
import cn.com.duiba.nezha.alg.alg.adx.rcmd2.PredictType;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly.AdxIndexStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FilterReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.FilterRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.AdxFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFilterAlg {
    private static final Logger logger = LoggerFactory.getLogger(FlowFilterAlg.class);

    public static Map<String, String> getStaticFeatureMap(AdxFeatureDo adxFeatureDo, AdxStatsDo resoAppStats) {
        AdxIndexStatsDo resoApp1HourInfo = AdxStatData.getAdxTimeIndex(resoAppStats, "1hour");
        adxFeatureDo.setResoAppExpCntDay(resoApp1HourInfo.getExpCnt());
        adxFeatureDo.setResoAppClickCntDay(resoApp1HourInfo.getClickCnt());
        adxFeatureDo.setResoAppAdCostDay(resoApp1HourInfo.getAdvertConsume());
        if (AssertUtil.isEmpty((Object)adxFeatureDo)) {
            logger.warn("FlowFilterAlg.getStaticFeatureMap adxFeatureDo is not valid");
        }
        Map featureMap = AdxFeatureParse.generateFeatureMapStatic((AdxFeatureDo)adxFeatureDo);
        return featureMap;
    }

    public static Double predict(Map<String, String> staticFeatureMap, Model model, PredictType predictType) throws Exception {
        Double ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{staticFeatureMap, model, predictType})) {
            logger.warn("FlowFilterAlg.predict params is not valid featureMap:{},predictType:{}", (Object)JSON.toJSONString(staticFeatureMap), (Object)JSON.toJSONString((Object)((Object)predictType)));
            return ret;
        }
        HashMap<FeatureIndex, FeatureMapDo> featureMap = new HashMap<FeatureIndex, FeatureMapDo>();
        FeatureIndex featureIndex = new FeatureIndex(1L, 1L);
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(staticFeatureMap);
        featureMap.put(featureIndex, featureMapDo);
        if (PredictType.CTR.equals((Object)predictType)) {
            Map<FeatureIndex, Double> preMap = model.predictCtr(featureMap);
            if (AssertUtil.isEmpty(preMap)) {
                logger.warn("FlowFilterAlg.predict preMap is null");
                return ret;
            }
            ret = preMap.get(featureIndex);
        }
        return ret;
    }

    public static FilterRetDo getFilter(FilterReqDo filterReqDo) {
        FilterRetDo ret = new FilterRetDo();
        try {
            ret = null;
        }
        catch (Exception e) {
            logger.error("FlowFilterAlg.getFilter", (Throwable)e);
        }
        return ret;
    }
}

