/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.adx.rcmd2.AdxRcmdBase;
import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdIdeaDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.AdxRecallRetDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.ColdStartFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.IdeaUnitDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2.SlotFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorBasePrintDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.AdxIdeaDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRcmdAlg {
    private static final Logger logger = LoggerFactory.getLogger(AdxRcmdAlg.class);
    public static final int LAST_20_MIN = 1;
    public static final int LAST_1_HOUR = 2;
    public static final int LAST_1_DAY = 3;
    public static final int LAST_3_DAY = 4;
    public static final int LAST_7_DAY = 5;
    public static final int IDEA_RECALL_SIZE = 20;
    public static final double IDEA_COLD_RATE = 0.25;
    public static final int ADIDEA_RECALL_SIZE = 40;
    public static final double ADIDEA_COLD_RATE = 0.25;

    public static AdxRecallRetDo recallIdeaRun(AdxRecallReqDo recallReqDo) {
        if (!AdxRcmdAlg.recallIdeaReqValid(recallReqDo)) {
            return null;
        }
        String print = "RecallIdeaRun, resId = " + recallReqDo.getResId();
        List<IdeaUnitDo> ideaUnitDos = recallReqDo.getIdeaUnitDos();
        ideaUnitDos.stream().forEach(ideaUnitDo -> {
            ideaUnitDo.setIsNew(IdeaUnitDo.getNewStatus(ideaUnitDo));
            ideaUnitDo.setLast7DayExpCnt(IdeaUnitDo.countExpCnt(ideaUnitDo, 5));
            ideaUnitDo.setLast7DayAdCost(IdeaUnitDo.countAdCost(ideaUnitDo, 5));
            ideaUnitDo.setStatAdEcpm(IdeaUnitDo.mergeStatAdEcpm(ideaUnitDo, 100L, 1));
        });
        Map<Integer, List<IdeaUnitDo>> ideaUnitMap = AdxRcmdBase.aggregateByRatioType(ideaUnitDos);
        ArrayList<IdeaUnitDo> recallList = new ArrayList<IdeaUnitDo>();
        for (Map.Entry<Integer, List<IdeaUnitDo>> entry : ideaUnitMap.entrySet()) {
            Integer ratioType = entry.getKey();
            List<IdeaUnitDo> subIdeaUnitDos = entry.getValue();
            List<IdeaUnitDo> newList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew()).collect(Collectors.toList());
            List<IdeaUnitDo> oldList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew() == false).collect(Collectors.toList());
            long coldSize = AdxRcmdBase.getRecallSize(newList, oldList, 20, 0.25, "COLD");
            long bestSize = AdxRcmdBase.getRecallSize(newList, oldList, 20, 0.25, "BEST");
            List coldList = newList.stream().sorted(Comparator.comparing(IdeaUnitDo::getLast7DayExpCnt).thenComparing(IdeaUnitDo::getIdeaUnitId, Comparator.reverseOrder())).limit(coldSize).collect(Collectors.toList());
            recallList.addAll(coldList);
            List bestList = oldList.stream().sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());
            recallList.addAll(bestList);
            List coldIds = coldList.stream().map(IdeaUnitDo::getIdeaUnitId).collect(Collectors.toList());
            List bestIds = bestList.stream().map(IdeaUnitDo::getIdeaUnitId).collect(Collectors.toList());
            print = print + "; {ratioType = " + ratioType + ", originalSize = " + subIdeaUnitDos.size() + ", newList = " + newList.size() + ", oldList = " + oldList.size() + ", coldSize = " + coldList.size() + ", coldList = " + JSON.toJSONString(coldIds) + ", bestSize = " + bestList.size() + ", bestList = " + JSON.toJSONString(bestIds) + "}";
        }
        AdxRecallRetDo ret = new AdxRecallRetDo();
        ret.setIdeaUnitDos(recallList);
        ret.setPrintStr(print);
        return ret;
    }

    public static AdxRecallRetDo recallAdIdeaRun(AdxRecallReqDo recallReqDo) {
        if (!AdxRcmdAlg.recallAdIdeaReqValid(recallReqDo)) {
            return null;
        }
        String print = "RecallAdIdeaRun, resId = " + recallReqDo.getResId();
        List<IdeaUnitDo> ideaUnitDos = recallReqDo.getIdeaUnitDos();
        Map<Long, Boolean> isNewMap = ideaUnitDos.stream().collect(Collectors.toMap(IdeaUnitDo::getIdeaUnitId, IdeaUnitDo::getIsNew));
        List<AdIdeaDo> adIdeaDos = recallReqDo.getAdIdeaDos();
        List<IdeaUnitDo> ideaUnitList = adIdeaDos.stream().flatMap(ideaUnit -> ideaUnit.getIdeaUnitDos().stream()).collect(Collectors.toList());
        ideaUnitList.stream().forEach(ideaUnitDo -> {
            ideaUnitDo.setIsNew((Boolean)isNewMap.get(ideaUnitDo.getIdeaUnitId()));
            ideaUnitDo.setLast1DayExpCnt(IdeaUnitDo.countExpCnt(ideaUnitDo, 3));
            ideaUnitDo.setLast1DayAdCost(IdeaUnitDo.countAdCost(ideaUnitDo, 3));
            ideaUnitDo.setStatAdEcpm(IdeaUnitDo.mergeStatAdEcpm(ideaUnitDo, 100L, 2));
        });
        Map<Integer, List<IdeaUnitDo>> ideaUnitMap = AdxRcmdBase.aggregateByRatioType(ideaUnitList);
        ArrayList<IdeaUnitDo> recallList = new ArrayList<IdeaUnitDo>();
        for (Map.Entry<Integer, List<IdeaUnitDo>> entry : ideaUnitMap.entrySet()) {
            Integer ratioType = entry.getKey();
            List<IdeaUnitDo> subIdeaUnitDos = entry.getValue();
            List<IdeaUnitDo> newList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew()).collect(Collectors.toList());
            List<IdeaUnitDo> oldList = subIdeaUnitDos.stream().filter(ideaUnitDo -> ideaUnitDo.getIsNew() == false).collect(Collectors.toList());
            long coldSize = AdxRcmdBase.getRecallSize(newList, oldList, 40, 0.25, "COLD");
            long bestSize = AdxRcmdBase.getRecallSize(newList, oldList, 40, 0.25, "BEST");
            List coldList = newList.stream().sorted(Comparator.comparing(IdeaUnitDo::getLast1DayExpCnt)).limit(coldSize).collect(Collectors.toList());
            recallList.addAll(coldList);
            List bestList = oldList.stream().sorted(Comparator.comparing(IdeaUnitDo::getStatAdEcpm).reversed()).limit(bestSize).collect(Collectors.toList());
            recallList.addAll(bestList);
            ArrayList coldIds = new ArrayList();
            ArrayList bestIds = new ArrayList();
            coldList.stream().forEach(e -> {
                IdeaUnitDo tmp = new IdeaUnitDo();
                tmp.setAdIdeaId(e.getAdIdeaId());
                tmp.setIdeaUnitId(e.getIdeaUnitId());
                coldIds.add(tmp);
            });
            bestList.stream().forEach(e -> {
                IdeaUnitDo tmp = new IdeaUnitDo();
                tmp.setAdIdeaId(e.getAdIdeaId());
                tmp.setIdeaUnitId(e.getIdeaUnitId());
                bestIds.add(tmp);
            });
            print = print + "; {ratioType = " + ratioType + ", originalSize = " + subIdeaUnitDos.size() + ", newList = " + newList.size() + ", oldList = " + oldList.size() + ", coldSize = " + coldList.size() + ", coldList = " + JSON.toJSONString(coldIds) + ", bestSize = " + bestList.size() + ", bestList = " + JSON.toJSONString(bestIds) + "}";
        }
        List<AdIdeaDo> recallAdIdeaDos = AdxRcmdBase.getCovertList(recallList);
        AdxRecallRetDo ret = new AdxRecallRetDo();
        ret.setAdIdeaDos(recallAdIdeaDos);
        ret.setPrintStr(print);
        return ret;
    }

    public static AdxFactorDo adIdeaFactorRun(AdxFactorReqDo adxFactorReqDo) {
        AdxFactorDo ret = new AdxFactorDo();
        if (!AdxRcmdAlg.adxFactorReqValid(adxFactorReqDo)) {
            return ret;
        }
        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        String appId = adxFactorReqDo.getAppId();
        String appTrade = adxFactorReqDo.getExtAppTrade();
        AdxFactorDo factorDo = Optional.ofNullable(adxFactorReqDo.getAdxFactorDo()).orElse(new AdxFactorDo());
        AdxStatsDo resoStatsDo = adxFactorReqDo.getResoStatsDo();
        String print = "adIdeaFactorRun, ideaId = " + adxIdeaDo.getIdeaId() + ", bidMode = " + bidMode + ", target = " + target + ", appTrade = " + appTrade + ", appId = " + appId + ", last updateTime = " + factorDo.getUpdateTime();
        AdxFactorBaseDo adFactorDo = new AdxFactorBaseDo();
        BeanUtils.copy((Object)factorDo.getAdFactorBaseDo(), (Object)adFactorDo);
        AdxStatsDo adStatsDo = adxFactorReqDo.getAdxStatsDo();
        AdxFactorBasePrintDo ad = AdxRcmdAlg.factorRunWithPrint(print, adFactorDo, null, null, adStatsDo, resoStatsDo, bidMode, target, "ad");
        adFactorDo = ad.factorBaseDo;
        print = ad.printStr;
        AdxFactorBaseDo tradeFactorDo = new AdxFactorBaseDo();
        BeanUtils.copy((Object)factorDo.getTradeFactorBaseDo(), (Object)tradeFactorDo);
        AdxStatsDo tradeStatsDo = adxFactorReqDo.getTradeStatsDo();
        if (adxFactorReqDo.getExtAppTrade() != null) {
            AdxFactorBasePrintDo trade = AdxRcmdAlg.factorRunWithPrint(print, tradeFactorDo, adFactorDo, factorDo.getAdFactorBaseDo(), tradeStatsDo, resoStatsDo, bidMode, target, "trade");
            tradeFactorDo = trade.factorBaseDo;
            print = trade.printStr;
        }
        AdxFactorBaseDo appFactorDo = new AdxFactorBaseDo();
        BeanUtils.copy((Object)factorDo.getAppFactorBaseDo(), (Object)appFactorDo);
        AdxStatsDo appStatsDo = adxFactorReqDo.getAppStatsDo();
        if (adxFactorReqDo.getAppId() != null) {
            AdxFactorBasePrintDo app = AdxRcmdAlg.factorRunWithPrint(print, appFactorDo, tradeFactorDo, factorDo.getTradeFactorBaseDo(), appStatsDo, resoStatsDo, bidMode, target, "app");
            appFactorDo = app.factorBaseDo;
            print = app.printStr;
        }
        ColdStartFactorDo coldStartFactor = factorDo.getColdStartFactorDo();
        if (adxIdeaDo.getIsColdStart() != null && adxIdeaDo.getIsColdStart().booleanValue() && adxIdeaDo.getColdStartFee() != null && adxIdeaDo.getColdStartFee() > 1L) {
            print = print + "; ColdStartFactorRun: isColdStart = " + adxIdeaDo.getIsColdStart() + ", coldStartFee = " + adxIdeaDo.getColdStartFee() + ", {lastParams: isExplore = " + coldStartFactor.isExplore() + ", factor = " + coldStartFactor.getFactor() + "}";
            AdxRcmdAlg.adColdStartFactorRun(coldStartFactor, adxIdeaDo, adxFactorReqDo.getColdStatsDo());
            print = print + "; coldStatsDo = " + JSON.toJSONString((Object)adxFactorReqDo.getColdStatsDo()) + "; {newParams: isExplore = " + coldStartFactor.isExplore() + ", factor = " + coldStartFactor.getFactor() + "}";
        }
        adFactorDo.setAdxIdeaDo(adxIdeaDo);
        ret.setAdFactorBaseDo(adFactorDo);
        ret.setTradeFactorBaseDo(tradeFactorDo);
        ret.setAppFactorBaseDo(appFactorDo);
        ret.setColdStartFactorDo(coldStartFactor);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        ret.setPrintStr(print);
        return ret;
    }

    public static AdxFactorBasePrintDo factorRunWithPrint(String print, AdxFactorBaseDo params, AdxFactorBaseDo baseParams, AdxFactorBaseDo lastBaseParams, AdxStatsDo statsDo, AdxStatsDo resoStatsDo, Integer bidMode, Double target, String dimType) {
        AdxFactorBasePrintDo ret = new AdxFactorBasePrintDo();
        print = print + "; dimType = " + dimType + "; {lastParams: conf = " + params.conf + ", factor = " + params.getFactor() + "}";
        AdxIndexStatDo last20MinStat = AdxRcmdBase.getStatusVo(statsDo.getLast20MinStat(), bidMode, target);
        AdxIndexStatDo last1HourStat = AdxRcmdBase.getStatusVo(statsDo.getLast1HourStat(), bidMode, target);
        AdxIndexStatDo last1DayStat = AdxRcmdBase.getStatusVo(statsDo.getLast1DayStat(), bidMode, target);
        print = print + "; data: {last1DayStat : " + JSON.toJSONString((Object)last1DayStat) + "}; {last1HourStat : " + JSON.toJSONString((Object)last1HourStat) + "}; {last20MinStat : " + JSON.toJSONString((Object)last20MinStat) + "}";
        AdxIndexStatDo last1DayResoStat = AdxRcmdBase.getStatusVo(resoStatsDo.getLast1DayStat(), bidMode, target);
        AdxRcmdAlg.updateStatIndex(params, baseParams, last20MinStat, last1HourStat, last1DayStat, last1DayResoStat);
        if (!params.conf && lastBaseParams != null) {
            params.setFactor(lastBaseParams.getFactor());
        }
        Double factor = params.getFactor();
        if (!AdxRcmdBase.isConfident(last1DayStat) || AdxIndexStatDo.getExpCnt(last20MinStat) < 10L) {
            params.setConf(false);
            factor = factor + (1.0 - factor) * 0.1;
            params.setFactor(DataUtil.formatDouble((Double)factor, (int)4));
            print = print + "; {newParams: conf = " + params.conf + ", factor = " + params.getFactor() + "}";
            ret.setFactorBaseDo(params);
            ret.setPrintStr(print);
            return ret;
        }
        double biasTarget = 0.001;
        double factorAvg = last1DayStat.getAvgfactor();
        PidController pidController = new PidController();
        double signal = pidController.update2(biasTarget, last20MinStat.bias, last1HourStat.bias, last1DayStat.bias, factor.doubleValue(), 0.5);
        factor = 0.01 + 0.99 * (0.9 * factor + 0.1 * factorAvg) + signal;
        if (last1DayStat.bias < -0.03) {
            factor = Math.max(factor, 1.0);
        }
        if (last1DayStat.bias > 0.03) {
            factor = Math.min(factor, 1.0);
        }
        if (Math.max(last1HourStat.sucRate, last20MinStat.sucRate) < last1DayStat.sucRate * 0.1) {
            factor = Math.max(factor, 1.0);
        }
        factor = DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)factor, (double)0.2, (double)3.0), (int)4);
        params.setConf(true);
        params.setFactor(factor);
        print = print + "; {newParams: conf = " + params.conf + ", factor = " + params.getFactor() + "}";
        ret.setFactorBaseDo(params);
        ret.setPrintStr(print);
        return ret;
    }

    public static void updateStatIndex(AdxFactorBaseDo params, AdxFactorBaseDo baseParams, AdxIndexStatDo last20MinStat, AdxIndexStatDo last1HourStat, AdxIndexStatDo last1DayStat, AdxIndexStatDo last1DayResoStat) {
        baseParams = Optional.ofNullable(baseParams).orElse(new AdxFactorBaseDo());
        if (!(params.dataConf || baseParams.dataConf || last1DayStat.getIsConfident().booleanValue())) {
            params.setDataConf(false);
            params.setStatCtr(AdxRcmdBase.getStatCtr(last1DayResoStat));
            params.setLaunchPv(AdxRcmdBase.getStatPvLaunch(last1DayResoStat));
            params.setArpu(AdxRcmdBase.getStatArpu(last1DayResoStat));
            params.setCpm(AdxRcmdBase.getStatCpm(last1DayResoStat));
            params.setStatEcpm(AdxRcmdBase.getStatEcpm(last1DayResoStat));
            return;
        }
        Double statCtr = baseParams.getStatCtr();
        Double launchPv = baseParams.getLaunchPv();
        Double arpu = baseParams.getArpu();
        Double cpm = baseParams.getCpm();
        Double statEcpm = baseParams.getStatEcpm();
        if (params.dataConf) {
            statCtr = params.getStatCtr();
            launchPv = params.getLaunchPv();
            arpu = params.getArpu();
            cpm = params.getCpm();
            statEcpm = params.getStatEcpm();
        }
        statCtr = AdxRcmdBase.getStatCtr(statCtr, last20MinStat, last1HourStat, last1DayStat);
        launchPv = AdxRcmdBase.getStatPvLaunch(launchPv, last20MinStat, last1HourStat, last1DayStat);
        arpu = AdxRcmdBase.getStatArpu(arpu, last20MinStat, last1HourStat, last1DayStat);
        cpm = AdxRcmdBase.getStatCpm(cpm, last20MinStat, last1HourStat, last1DayStat);
        statEcpm = AdxRcmdBase.getStatEcpm(statEcpm, last20MinStat, last1HourStat, last1DayStat);
        params.setDataConf(true);
        params.setStatCtr(statCtr);
        params.setLaunchPv(launchPv);
        params.setArpu(arpu);
        params.setCpm(cpm);
        params.setStatEcpm(statEcpm);
    }

    public static void adColdStartFactorRun(ColdStartFactorDo params, AdxIdeaDo adxIdeaDo, AdxStatsDo coldStatsDo) {
        double factor = params.getFactor();
        double targetCost = adxIdeaDo.getColdStartFee().longValue();
        Long coldBidCnt = AdxStatsDo.getBidCnt(coldStatsDo, 3);
        Long coldSucCnt = AdxStatsDo.getBidSucCnt(coldStatsDo, 3);
        Long coldAdxCost = AdxStatsDo.getAdxCost(coldStatsDo, 3);
        Long coldAdCost = AdxStatsDo.getAdCost(coldStatsDo, 3);
        double roi = DataUtil.division((Long)(coldAdCost + 1000L), (Long)(coldAdxCost + 1000L), (int)4);
        double sucRate = DataUtil.division((Long)(coldSucCnt + 100L), (Long)(coldBidCnt + 100L), (int)4);
        if (coldBidCnt == 0L || (double)coldAdxCost.longValue() >= targetCost) {
            factor += (1.0 - factor) * 0.2;
            params.setIdeaId(adxIdeaDo.getIdeaId());
            params.setFactor(factor);
            params.setExplore(false);
            params.setIsColdStart(false);
            params.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
            return;
        }
        double p = 0.9;
        PidController pidController = new PidController();
        double signal = pidController.update(targetCost * p, (double)coldAdxCost.longValue(), 0.5, -0.1, 0.1);
        if (roi > 1.0) {
            signal = Math.max(signal, 0.01) * 1.5;
        }
        if (sucRate < 0.1) {
            signal = Math.max(signal, 0.01) * 1.5;
        }
        factor = 0.01 + 0.99 * factor + signal;
        params.setFactor(DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)factor, (double)1.1, (double)3.0), (int)4));
        params.setIdeaId(adxIdeaDo.getIdeaId());
        params.setExplore(true);
        params.setIsColdStart(true);
        params.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
    }

    public static SlotFactorDo slotFactorRun(SlotFactorReqDo factorReqDo) {
        SlotFactorDo ret = new SlotFactorDo();
        if (!AdxRcmdAlg.slotFactorReqValid(factorReqDo)) {
            return ret;
        }
        ret.setResId(factorReqDo.getResId());
        ret.setSlotId(factorReqDo.getSlotId());
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        SlotFactorDo lastFactorDo = Optional.ofNullable(factorReqDo.getSlotFactorDo()).orElse(new SlotFactorDo());
        String print = "slotFactorRun, resId = " + factorReqDo.getResId() + ", slotId = " + factorReqDo.getSlotId() + "; {lastParams: isExplore = " + lastFactorDo.isExplore() + ", factor = " + lastFactorDo.getFactor() + ", flowRatio = " + lastFactorDo.getFlowRatio() + ", updateTime = " + lastFactorDo.getUpdateTime() + "}";
        if (!lastFactorDo.isExplore()) {
            ret.setExplore(false);
            print = print + "; {newParams: isExplore = " + ret.isExplore() + "}";
            ret.setPrintStr(print);
            return ret;
        }
        AdxStatsDo slotStatsDo = Optional.ofNullable(factorReqDo.getSlotStatsDo()).orElse(new AdxStatsDo());
        Long last7DayExpCnt = AdxStatsDo.getExpCnt(slotStatsDo, 5);
        Long last7DayAdxCost = AdxStatsDo.getAdxCost(slotStatsDo, 5);
        Long last7DayAdCost = AdxStatsDo.getAdCost(slotStatsDo, 5);
        print = print + "; data: last7DayExpCnt = " + last7DayExpCnt + ", last7DayAdxCost = " + last7DayAdxCost + ", last7DayAdCost = " + last7DayAdCost;
        Long adxCostLimit = 10000L;
        Long expCntLimit = 5000L;
        if (last7DayAdxCost > adxCostLimit || last7DayExpCnt > expCntLimit) {
            ret.setExplore(false);
            print = print + "; {newParams: isExplore = " + ret.isExplore() + "}";
            ret.setPrintStr(print);
            return ret;
        }
        AdxStatsDo exploreStatsDo = Optional.ofNullable(factorReqDo.getSlotExploreStatsDo()).orElse(new AdxStatsDo());
        AdxRcmdAlg.updateSlotFactor(print, ret, lastFactorDo, adxCostLimit, expCntLimit, last7DayAdxCost, last7DayExpCnt, exploreStatsDo);
        print = print + "; {newParams: isExplore = " + ret.isExplore() + ", factor = " + ret.getFactor() + ", flowRatio = " + ret.getFlowRatio() + "}";
        ret.setPrintStr(print);
        return ret;
    }

    public static void updateSlotFactor(String print, SlotFactorDo params, SlotFactorDo lastParams, long targetCost, long targetExp, long actualCost, long actualExp, AdxStatsDo exploreStatsDo) {
        double p = 0.9;
        Long last7DayEExpCnt = AdxStatsDo.getExpCnt(exploreStatsDo, 5);
        Long last7DayEAdCost = AdxStatsDo.getAdCost(exploreStatsDo, 5);
        double factor = lastParams.getFactor();
        PidController pidController = new PidController();
        double signal1 = pidController.update((double)targetCost * p, (double)actualCost, 0.2, -0.05, 0.05);
        double signal2 = pidController.update((double)targetExp * p, (double)actualExp, 0.2, -0.05, 0.05);
        factor = 0.01 + 0.99 * factor + Math.min(signal1, signal2);
        params.setFactor(DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)factor, (double)1.05, (double)2.0), (int)4));
        double flowRatio = lastParams.getFlowRatio();
        double r = DataUtil.division((Long)actualCost, (Long)targetCost);
        params.setFlowRatio(DataUtil.formatDouble((Double)MathUtil.stdwithBoundary((double)(flowRatio += r < 0.2 ? 0.06 : (r < 0.5 ? 0.04 : (r < 0.8 ? 0.02 : 0.01))), (double)0.1, (double)0.3), (int)4));
        params.setExplore(true);
    }

    public static boolean recallIdeaReqValid(AdxRecallReqDo recallReqDo) {
        if (recallReqDo == null) {
            logger.warn("recallIdeaRun recallReqDo is null");
            return false;
        }
        if (recallReqDo.getResId() == null) {
            logger.warn("recallIdeaRun resId is null");
            return false;
        }
        if (recallReqDo.getIdeaUnitDos() == null || recallReqDo.getIdeaUnitDos().size() < 1) {
            logger.warn("recallIdeaRun ideaUnitDos is null, resId = {}", (Object)recallReqDo.getResId());
            return false;
        }
        return true;
    }

    public static boolean recallAdIdeaReqValid(AdxRecallReqDo recallReqDo) {
        if (recallReqDo == null) {
            logger.warn("recallAdIdeaRun recallReqDo is null");
            return false;
        }
        if (recallReqDo.getResId() == null) {
            logger.warn("recallAdIdeaRun resId is null");
            return false;
        }
        if (recallReqDo.getAdIdeaDos() == null || recallReqDo.getAdIdeaDos().size() < 1) {
            logger.warn("recallAdIdeaRun adIdeaDos is null, resId = {}", (Object)recallReqDo.getResId());
            return false;
        }
        if (recallReqDo.getIdeaUnitDos() == null || recallReqDo.getIdeaUnitDos().size() < 1) {
            logger.warn("recallAdIdeaRun ideaUnitDos is null, resId = {}", (Object)recallReqDo.getResId());
            return false;
        }
        return true;
    }

    public static boolean adxFactorReqValid(AdxFactorReqDo adxFactorReqDo) {
        if (adxFactorReqDo == null) {
            logger.warn("adIdeaFactorRun adxFactorReqDo is null");
            return false;
        }
        if (adxFactorReqDo.getAdxIdeaDo() == null) {
            logger.warn("adIdeaFactorRun adxIdeaDo is null");
            return false;
        }
        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        if (adxIdeaDo.getIdeaId() == null) {
            logger.warn("adIdeaFactorRun ideaId is null");
            return false;
        }
        if (adxIdeaDo.getBidMode() == null) {
            logger.warn("adIdeaFactorRun bidMode is null, adxIdeaDo = {}", (Object)JSON.toJSONString((Object)adxIdeaDo));
            return false;
        }
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);
        if (target == null) {
            logger.warn("AdxRoiFactor target is null, adxIdeaDo = {}", (Object)JSON.toJSONString((Object)adxIdeaDo));
            return false;
        }
        return true;
    }

    public static boolean slotFactorReqValid(SlotFactorReqDo factorReqDo) {
        if (factorReqDo == null) {
            logger.warn("slotFactorRun factorReqDo is null");
            return false;
        }
        if (factorReqDo.getResId() == null) {
            logger.warn("slotFactorRun resId is null");
            return false;
        }
        if (factorReqDo.getSlotId() == null) {
            logger.warn("slotFactorRun slotId is null");
            return false;
        }
        return true;
    }
}

