package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import lombok.Data;

import java.util.List;
import java.util.Optional;


@Data
public class IdeaUnitDo {

    /**
     * 创意素材ID
     */
    private Long ideaUnitId;

    /**
     * 创意计划ID
     */
    private Long adIdeaId;

    /**
     * 素材ID
     */
    private List<Long> materialIds;

    /**
     * 创意比例区间
     */
    private Integer ratioType;

    /**
     * 创意素材类型
     */
    private Long type;

    /**
     * 出价
     */
    private Double price;

    /**
     * 预估ctr
     */
    private Double preCtr;

    /**
     * 统计ctr
     */
    private Double statCtr;

    /**
     * ctr
     */
    private Double ctr;

    /**
     * 预估每pv发券
     */
    private Double preLaunchPv;

    /**
     * 统计每pv发券
     */
    private Double statLaunchPv;

    /**
     * 每pv发券
     */
    private Double launchPv;

    /**
     * arpu
     */
    private Double arpu;

    /**
     * 预估arpu
     */
    private Double preArpu;

    /**
     * 创意素材+当前资源位统计数据
     */
    private AdxStatsDo adxStatsDo;

    /**
     * 统计广告ecpm(广告消耗/adx曝光*1000)
     */
    private Double statAdEcpm;

    /**
     * 算法判断--计划创意来源池：true-冷启动池，false-优选池
     */
    private Boolean isNew;

    /**
     * 近7d曝光次数(包含当天)
     */
    private Long last7DayExpCnt;

    /**
     * 近7d广告消耗/分(包含当天)
     */
    private Long last7DayAdCost;

    /**
     * 当天曝光次数
     */
    private Long last1DayExpCnt;

    /**
     * 当天广告消耗/分
     */
    private Long last1DayAdCost;


    public static Double getStatEcpm(IdeaUnitDo ideaUnitDo){
        Double ret = null;
        if(ideaUnitDo != null) {
            AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
            AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
            ret = AdxIndexStatDo.getStatEcpm(last1DayStat);
        }
        if(ret == null) {ret = 10000.0;}
        return ret;

    }



    /**
     * 判断创意来源池：true-冷启动池，false-优选池
     */
    public static boolean getNewStatus(IdeaUnitDo ideaUnitDo){

        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());

        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last7DayStat = adxStatsDo.getLast7DayStat();
        Long last1DayExp = AdxIndexStatDo.getExpCnt(last1DayStat);
        Long last7DayExp = AdxIndexStatDo.getExpCnt(last7DayStat);

        if(last7DayExp > 1000L || last1DayExp > 500L) {
            return false;
        } else {
            return true;
        }
    }


    /**
     * 计算曝光次数，选择时间维度timeType
     */
    public static Long countExpCnt(IdeaUnitDo ideaUnitDo, int timeType){
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.getExpCnt(adxStatsDo, timeType);
    }


    /**
     * 计算广告消耗/分，选择时间维度timeType
     */
    public static Long countAdCost(IdeaUnitDo ideaUnitDo, int timeType){
        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());
        return AdxStatsDo.getAdCost(adxStatsDo, timeType);
    }



    /**
     * 融合计算统计广告ecpm(广告消耗/adx曝光*1000)
     */
    public static Double mergeStatAdEcpm(IdeaUnitDo ideaUnitDo, long limit, int mergeType){

        ideaUnitDo = Optional.ofNullable(ideaUnitDo).orElse(new IdeaUnitDo());
        AdxStatsDo adxStatsDo = Optional.ofNullable(ideaUnitDo.getAdxStatsDo()).orElse(new AdxStatsDo());

        return AdxStatsDo.mergeStatAdEcpm(adxStatsDo, limit, mergeType);
    }




}
