/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.MaterialExtractDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialMatchDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.material.RerankMaterial;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.MaterialFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.MaterialFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.UserMaterialFeature;
import cn.com.duiba.nezha.alg.model.FM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialRcmder {
    public static MaterialRcmdDo forkFeatureParse(MaterialFeatureDo materialFeatureDo) {
        ArrayList idList = new ArrayList(materialFeatureDo.getMaterialFeatureMap().keySet());
        if (AssertUtil.isEmpty(idList) || idList.size() < 1) {
            return null;
        }
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = (Long)idList.get(0);
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(1);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo rcmd(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        MaterialRcmdDo ret = null;
        ret = MaterialRcmder.rank(model, materialExtractDo, materialFeatureDo);
        return ret;
    }

    private static MaterialRcmdDo randomStrategy(MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) {
        List<MaterialMatchDo> materialMatchDoList = materialExtractDo.getMaterialMatchDoList();
        if (materialMatchDoList.size() < 1) {
            return null;
        }
        Collections.shuffle(materialMatchDoList);
        MaterialMatchDo materialMatchDo = materialMatchDoList.get(0);
        MaterialRcmdDo materialRcmdDo = new MaterialRcmdDo();
        Long materialId = materialMatchDo.getMaterialId();
        materialRcmdDo.setRid(materialFeatureDo.getRid());
        materialRcmdDo.setMaterialId(materialId);
        materialRcmdDo.setScore(0.0);
        materialRcmdDo.setType(0);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo));
        featureMap.putAll(MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId));
        materialRcmdDo.setFeatureMap(featureMap);
        return materialRcmdDo;
    }

    public static MaterialRcmdDo rank(FM model, MaterialExtractDo materialExtractDo, MaterialFeatureDo materialFeatureDo) throws Exception {
        FeatureMapDo featureMapDo;
        MaterialRcmdDo ret = null;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{materialExtractDo, materialFeatureDo})) {
            return ret;
        }
        HashMap<Long, FeatureMapDo> featureDoMap = new HashMap<Long, FeatureMapDo>();
        Set<Long> recallMaterialSet = MaterialRcmder.mergeMultiRecallStrategy(materialExtractDo);
        Map staticFeatureMap = MaterialFeatureParse.generateFeatureMapStatic((MaterialFeatureDo)materialFeatureDo);
        for (Long materialId : recallMaterialSet) {
            Map dynamicFeatureMap = MaterialFeatureParse.generateFeatureMapDynamic((MaterialFeatureDo)materialFeatureDo, (MaterialFeatureDo)materialFeatureDo, (Long)materialId);
            featureMapDo = new FeatureMapDo();
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureDoMap.put(materialId, featureMapDo);
        }
        HashMap<Long, Double> preCTR = new HashMap();
        preCTR = model.predictsNew(featureDoMap);
        RerankMaterial rerankMaterial = MaterialRcmder.reRank(preCTR, materialFeatureDo);
        ret = new MaterialRcmdDo();
        Long reRankId = rerankMaterial.getMaterialId();
        ret.setMaterialId(reRankId);
        featureMapDo = (FeatureMapDo)featureDoMap.get(reRankId);
        Map resultFeatureMap = featureMapDo.getStaticFeatureMap();
        resultFeatureMap.putAll(featureMapDo.getDynamicFeatureMap());
        ret.setFeatureMap(resultFeatureMap);
        ret.setRid(materialFeatureDo.getRid());
        ret.setType(2);
        ret.setScore(rerankMaterial.getRankScore());
        return ret;
    }

    private static Set<Long> mergeMultiRecallStrategy(MaterialExtractDo materialExtractDo) {
        HashSet<Long> recallMaterialSet = new HashSet<Long>();
        materialExtractDo.getMaterialMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        materialExtractDo.getMaterialCostMatchDoList().forEach(material -> recallMaterialSet.add(material.getMaterialId()));
        return recallMaterialSet;
    }

    private static RerankMaterial reRank(Map<Long, Double> preCTR, MaterialFeatureDo materialFeatureDo) {
        RerankMaterial rerankMaterial = new RerankMaterial();
        Map userMaterialFeatureMap = materialFeatureDo.getUserMaterialFeatureMap();
        double upWeight = 0.1;
        double maxScore = -1.0;
        double rawScore = -1.0;
        Long resultId = 0L;
        for (Map.Entry<Long, Double> entry : preCTR.entrySet()) {
            UserMaterialFeature userMaterialFeature;
            Long exposeCnt;
            double score = entry.getValue();
            Long materialId = entry.getKey();
            double tmpScore = score;
            if (userMaterialFeatureMap.containsKey(materialId) && null != (exposeCnt = (userMaterialFeature = (UserMaterialFeature)userMaterialFeatureMap.get(materialId)).getUExposeDayCnt())) {
                score /= (double)(1L + exposeCnt);
            }
            if (!(score > maxScore)) continue;
            maxScore = score;
            resultId = materialId;
            rawScore = tmpScore;
        }
        rerankMaterial.setMaterialId(resultId);
        rerankMaterial.setRankScore(rawScore);
        rerankMaterial.setReRankScore(maxScore);
        return rerankMaterial;
    }
}

