package cn.com.duiba.nezha.alg.alg.adx.rtbbid2;

import cn.com.duiba.nezha.alg.alg.vo.adx.flowfilter.AdxIndexStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.pd.AdxStatsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rtb2.*;
import cn.com.duiba.nezha.alg.common.model.ocpxControl.PidController;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {

    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);


    /**
     * 维稳定时任务调用接口
     * @param adxFactorReqDo
     * @return
     */
    public static AdxFactorBaseDo run(AdxFactorReqDo adxFactorReqDo) {

        if(!valid(adxFactorReqDo)) {
            return null;
        }

        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        AdxFactorBaseDo factorBaseDo = adxFactorReqDo.getFactorBaseDo();
        AdxStatsDo adxStatsDo = adxFactorReqDo.getAdxStatsDo();

        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);

        /**
         * 获取统计数据
         */
        AdxIndexStatDo last20MinStat = adxStatsDo.getLast20MinStat();
        AdxIndexStatDo last1DayStat = adxStatsDo.getLast1DayStat();
        AdxIndexStatDo last3DayStat = adxStatsDo.getLast3DayStat();
        String appId = adxFactorReqDo.getAppId();

        String prefix = appId == null ? "ideaId" + adxIdeaDo.getIdeaId() + ",bidMode" + bidMode + ",target" + target
                : "ideaId" + adxIdeaDo.getIdeaId() + ",appId" + appId +  ",bidMode" + bidMode + ",target" + target;

        //数据不置信，直接返回
        if(!AdxIndexStatDo.isCostConfidence(last1DayStat)) {
            if (Math.random() < 0.002) {
                logger.info("AdxFactorBaseDo.run adxIndexStatDo is not Confidence, ideaId{}", adxIdeaDo.getIdeaId());
            }

            if(factorBaseDo == null) { factorBaseDo = new AdxFactorBaseDo(); }
            return factorBaseDo;
        }

        //是否重置
        boolean reset = false;
        if(factorBaseDo == null) {
            factorBaseDo = new AdxFactorBaseDo();
        }
        else if (factorBaseDo.getAdxIdeaDo() != null){
//            reset = !adxIdeaDo.equals(factorBaseDo.getAdxIdeaDo());

            Double lastTarget = AdxIdeaDo.getTarget(factorBaseDo.getAdxIdeaDo());
            if (AssertUtil.isAnyEmpty(lastTarget, target) || !target.equals(lastTarget)){
                reset = true;
                logger.info("roitask reset target = {}, lastTarget = {}, adxIdeaDo = {}, factorBaseDo.getAdxIdeaDo() = {}",
                        target, lastTarget, JSON.toJSONString(adxIdeaDo), JSON.toJSONString(factorBaseDo.getAdxIdeaDo()));
            }
        }

        /**
         * 更新维稳因子
         */
        updateFactor(prefix, target, factorBaseDo, bidMode, last20MinStat, last1DayStat, last3DayStat, reset);

        /**
         * 更新统计数据
         */
        updateStatValue(factorBaseDo, last20MinStat, last1DayStat);

        factorBaseDo.setAdxIdeaDo(adxIdeaDo);

        return factorBaseDo;

    }


    public static void updateFactor(String prefix, Double target, AdxFactorBaseDo factorBaseDo, Integer bidMode, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay, AdxIndexStatDo statBaseDo3Days, boolean reset) {

        try {

            double factor = factorBaseDo.getFactor();

            if(reset){
                logger.warn("roitask reset prefix{}, factorBaseDo{}", prefix, factorBaseDo);
                factorBaseDo.setFactor(1.0);
                return;
            }

            //20分钟
            Double realValueMins = AdxRoiFactor.getRealValue(adxStatBaseDo, bidMode, target);

            //当日
            Double realValueDay = AdxRoiFactor.getRealValue(statBaseDoDay, bidMode, target);

            //近三日
            Double realValue3Days = AdxRoiFactor.getRealValue(statBaseDo3Days, bidMode, target);

            Double costWeigh = AdxIndexStatDo.getCostWeigh(adxStatBaseDo, statBaseDoDay);
            boolean winRateStatus = AdxIndexStatDo.getWinRateStatus(adxStatBaseDo, statBaseDoDay);

            PidController pidController = new PidController();
            double signal = pidController.runPid2(target, realValueMins, realValueDay, realValue3Days, costWeigh);
            factor = factor + signal;

            factor = limitFactor(factor, realValueDay, target, statBaseDoDay.getAdxConsume2(), winRateStatus);
            factor = MathUtil.stdwithBoundary(factor, 0.2, 3);
            factorBaseDo.setFactor(factor);

            logger.info("roitask prefix{}, 20mins{}, day{}, 3days{}, factorDo{}", prefix, adxStatBaseDo, statBaseDoDay, statBaseDo3Days, factorBaseDo);

        }catch (Exception e) {
            logger.error("AdxRoiFactor.updateFactor error:", e);
        }
    }

    public static double limitFactor(double factor, Double realValueDay, Double target, Double adxCost, boolean winRateStatus) {
        double ret = factor;
        if (AssertUtil.isAnyEmpty(realValueDay, target, adxCost)) {
            return ret;
        }

        //兜底逻辑处理
        if(realValueDay > 3 && adxCost > 50000. ) {
            ret = factor + (0.2 - factor) * 0.1;
        }else if(realValueDay/target - 1 > 0.2 && adxCost > 10000.) {
            factor = factor + (0.2 - factor) * 0.01;
            ret = Math.min(factor, 1);
        }else if(realValueDay/target - 1 < -0.05) {
            ret = factor + (3 - factor) * 0.03;
        }

        if(realValueDay/target - 1 < 0.05 || winRateStatus) {
            ret = Math.max(ret, 1);
        }

        return ret;
    }




    /**
     * 更新统计值
     * 数据不置信，继承base参数
     */
    public static void updateStatValue(AdxFactorBaseDo factorBaseDo, AdxIndexStatDo adxStatBaseDo, AdxIndexStatDo statBaseDoDay) {
        if(factorBaseDo == null) {
            factorBaseDo = new AdxFactorBaseDo();
        }
        try{
            Double arpu = factorBaseDo.getArpu();
            Double launchPv = factorBaseDo.getLaunchPv();
            Double statCtr = factorBaseDo.getStatCtr();
            Double cpm = factorBaseDo.getCpm();
            Double clickValue = factorBaseDo.getClickValue();

            if(AdxIndexStatDo.isCostConfidence(statBaseDoDay)) {

                arpu = AdxIndexStatDo.getArpu(arpu, adxStatBaseDo, statBaseDoDay);
                launchPv = AdxIndexStatDo.getLaunchPv(launchPv, adxStatBaseDo, statBaseDoDay);
                statCtr = AdxIndexStatDo.getStatCtr(statCtr, adxStatBaseDo, statBaseDoDay);
                cpm = AdxIndexStatDo.getStatCpm(cpm, adxStatBaseDo, statBaseDoDay);
                clickValue = AdxIndexStatDo.getStatClickValue(clickValue, adxStatBaseDo, statBaseDoDay);
            }

            factorBaseDo.setArpu(arpu);
            factorBaseDo.setLaunchPv(launchPv);
            factorBaseDo.setStatCtr(statCtr);
            factorBaseDo.setCpm(cpm);
            factorBaseDo.setClickValue(clickValue);
        }catch (Exception e) {
            logger.info("AdxRoiFactor.updateStatValue:", e);
        }

    }

    /**
     * 根据出价类型，计算实际指标
     */
    public static Double getRealValue(AdxIndexStatDo adxStatBaseDo, Integer bidMode, Double defaultValue) {
        Double ret = null;
        if(AssertUtil.isAllNotEmpty(adxStatBaseDo, bidMode)) {
            ret = bidMode == 2 ? AdxIndexStatDo.getCpc(adxStatBaseDo) : AdxIndexStatDo.getRoi(adxStatBaseDo) ;
        }

        if(ret == null) {
            ret = defaultValue;
        }
        return ret;
    }


    public static boolean valid(AdxFactorReqDo adxFactorReqDo) {

        if(adxFactorReqDo == null) {
            logger.warn("AdxRoiFactor.run params is invalid");
            return false;
        }

        if(AssertUtil.isAnyEmpty(adxFactorReqDo.getAdxIdeaDo(), adxFactorReqDo.getAdxStatsDo())) {
            logger.warn("AdxRoiFactor.run params is invalid, adxIdeaDo or adxStatsDo is null");
            return false;
        }

        AdxIdeaDo adxIdeaDo = adxFactorReqDo.getAdxIdeaDo();
        Integer bidMode = adxIdeaDo.getBidMode();
        Double target = AdxIdeaDo.getTarget(adxIdeaDo);

        if(AssertUtil.isAnyEmpty(bidMode, target)) {
            logger.warn("AdxRoiFactor.run params is invalid, bidMode or target is null，adxIdeaDo={}", JSON.toJSONString(adxIdeaDo));
            return false;
        }

        return true;
    }

}
