/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.dpa.intercept;

import cn.com.duiba.nezha.alg.alg.vo.dpa.intercept.InterceptInfoDo;
import cn.com.duiba.nezha.alg.common.model.activityrecommend.WilsonInterval;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.CandidateInterceptDo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptRecall {
    private static final Logger logger = LoggerFactory.getLogger(InterceptRecall.class);

    public static List<CandidateInterceptDo> match(List<InterceptInfoDo> interceptInfoDoList) {
        return InterceptRecall.wilMatch(interceptInfoDoList, 30, 3);
    }

    public static List<CandidateInterceptDo> wilMatch(List<InterceptInfoDo> interceptInfoDos, int topN, int topK) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{interceptInfoDos})) {
            logger.error("InterceptRecall wilMatch input params is null");
            return null;
        }
        ArrayList<CandidateInterceptDo> result = new ArrayList<CandidateInterceptDo>();
        Comparator<CandidateInterceptDo> iComparator = new Comparator<CandidateInterceptDo>(){

            @Override
            public int compare(CandidateInterceptDo o1, CandidateInterceptDo o2) {
                return o2.getMatchScore() > o1.getMatchScore() ? 1 : -1;
            }
        };
        PriorityBlockingQueue<CandidateInterceptDo> intercepts = new PriorityBlockingQueue<CandidateInterceptDo>(interceptInfoDos.size(), iComparator);
        HashSet<Long> ids = new HashSet<Long>();
        int supportIdLen = 0;
        for (InterceptInfoDo iid : interceptInfoDos) {
            CandidateInterceptDo candidateInterceptDo = new CandidateInterceptDo();
            candidateInterceptDo.setActivityId(iid.getActivityId());
            candidateInterceptDo.setSlotId(iid.getSlotId());
            candidateInterceptDo.setAppId(iid.getAppId());
            candidateInterceptDo.setCreateTime(iid.getCreateTime());
            candidateInterceptDo.setHisRequest(iid.getHisRequest());
            candidateInterceptDo.setHistClick(iid.getHistClick());
            candidateInterceptDo.setHisCost(iid.getHisCost());
            candidateInterceptDo.setHisEffect(iid.getHisEffect());
            if (iid.getHisRequest().getGlobalVal() < 10.0 && System.currentTimeMillis() - iid.getCreateTime() < 25920000L) {
                if (!(Math.random() < 0.01) || supportIdLen >= topK) continue;
                result.add(candidateInterceptDo);
                ids.add(iid.getActivityId());
                ++supportIdLen;
                continue;
            }
            double w1 = 1.0 * Math.min(iid.getHisRequest().getSlotVal() / 100.0, 1.0);
            double w2 = 0.6 * (1.0 - w1) * Math.min(iid.getHisRequest().getAppVal() / 200.0, 1.0);
            double w3 = 0.2 * (1.0 - w1 - w2) * Math.min(iid.getHisRequest().getGlobalVal() / 1000.0, 1.0);
            double matchScore = w1 * WilsonInterval.wilsonCalc((double)(iid.getHisCost().getSlotVal() / 100.0), (double)iid.getHisRequest().getSlotVal()).lowerBound + w2 * WilsonInterval.wilsonCalc((double)(iid.getHisCost().getAppVal() / 100.0), (double)iid.getHisRequest().getAppVal()).lowerBound + w3 * WilsonInterval.wilsonCalc((double)(iid.getHisCost().getGlobalVal() / 100.0), (double)iid.getHisRequest().getGlobalVal()).lowerBound;
            candidateInterceptDo.setMatchScore(Double.valueOf(matchScore));
            intercepts.add(candidateInterceptDo);
        }
        for (int i = 0; i < intercepts.size(); ++i) {
            CandidateInterceptDo imd = (CandidateInterceptDo)intercepts.poll();
            if (result.size() >= topN || ids.contains(imd.getActivityId())) continue;
            result.add(imd);
        }
        return result;
    }
}

