package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

@Data
public class Model {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);

    private IModel ctrModel;
    private IModel launchPvCoder;
    private IModel ARPUCoder;
    private LocalTFModel launchPvTFModel;  // launchPvCoder对应的TF model
    private LocalTFModel arpuTFModel;   // ARPUCoder对应的TF model
    private LocalTFModel localTFModel;

    public <T> Map<T, Double> predictCtr(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<T, Double> ret;
            ret = ctrModel.predictsNew(featureMap);
            return ret;
        }
        catch (Exception e) {
            logger.error("Model.predictCtr error{} ctrModel{}", e, ctrModel);
        }
        return null;
    }

    public <T> Map<T, Double> predictLaunchPv(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<T, Double> ret;
//        logger.info("featureMap{}, launchPvTFModel{}", JSONObject.toJSON(featureMap), JSONObject.toJSON(launchPvTFModel));
            ret = launchPvCoder.predictWithLocalTFNew(featureMap, launchPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv error{}, launchPvCoder{}, launchPvTFModel{}", e, launchPvCoder, launchPvTFModel);
        }
        return null;
    }

    public <T> Map<T, Double> predictARPU(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<T, Double> ret;
            ret = ARPUCoder.predictWithLocalTFNew(featureMap, arpuTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU error{}, ARPUCoder{}, arpuTFModel{}", e, ARPUCoder, arpuTFModel);
        }
        return null;
    }


}
