package cn.com.duiba.nezha.alg.alg.vo.adx.rcmd2;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 创意素材特征对象
 */
@Data
public class AdxIdeaMaterialFeatureDo {
    private Long ideaUnitId;    //创意素材ID
    private Integer styleType; //创意素材类型
    private List<AdxMaterialFeatureDo> adxMaterialFeatureDos; //素材图片特征


    /**
     * 创意素材统计数据
     */
    private Long matAdxExpDay;  //创意素材 当天入口曝光次数
    private Long matAdxClickDay;    //创意素材 当天入口点击次数
    private Long matActReqDay;   //创意素材 当天活动访问次数
    private Long matActJoinDay;   //创意素材 当天活动参与次数
    private Long matAdvertExpDay;   //创意素材 当天广告曝光次数
    private Long matAdvertClkDay;   //创意素材 当天广告点击次数

    private Long matActReq7d;   //创意素材 7天活动访问次数
    private Long matActJoin7d;   //创意素材 7天活动参与次数
    private Long matAdvertExp7d;   //创意素材 7天广告曝光次数
    private Long matAdvertClk7d;   //创意素材 7天广告点击次数

    private Long matActReq28d;   //创意素材 28天活动访问次数
    private Long matActJoin28d;   //创意素材 28天活动参与次数
    private Long matAdvertExp28d;   //创意素材 28天广告曝光次数
    private Long matAdvertClk28d;   //创意素材 28天广告点击次数

    private Long matResoAdxExpDay;  //创意素材+资源位 当天入口曝光次数
    private Long matResoAdxClickDay;    //创意素材+资源位 当天入口点击次数
    private Long matResoActReqDay;   //创意素材+资源位 当天活动访问次数
    private Long matResoActJoinDay;   //创意素材+资源位 当天活动参与次数
    private Long matResoAdvertExpDay;   //创意素材+资源位 当天广告曝光次数
    private Long matResoAdvertClkDay;   //创意素材+资源位 当天广告点击次数

    private Long matResoActReq7d;   //创意素材+资源位 7天活动访问次数
    private Long matResoActJoin7d;   //创意素材+资源位 7天活动参与次数
    private Long matResoAdvertExp7d;   //创意素材+资源位 7天广告曝光次数
    private Long matResoAdvertClk7d;   //创意素材+资源位 7天广告点击次数

    private Long matResoActReq28d;   //创意素材+资源位 28天活动访问次数
    private Long matResoActJoin28d;   //创意素材+资源位 28天活动参与次数
    private Long matResoAdvertExp28d;   //创意素材+资源位 28天广告曝光次数
    private Long matResoAdvertClk28d;   //创意素材+资源位 28天广告点击次数

    private Map<Long, Long> matAdvertTradeExp7d; //创意素材 7天内不同广告行业券曝光次数
    private Map<Long, Long> matAdvertTradeClk7d; //创意素材 7天内不同广告行业券点击次数
    private Map<Long, Long> matAdvertTradeExp28d; //创意素材 28天内不同广告行业券曝光次数
    private Map<Long, Long> matAdvertTradeClk28d; //创意素材 28天内不同广告行业券点击次数

    private Map<Long, Long> matResoAdvertTradeExp7d; //创意素材+资源位 7天内不同广告行业券曝光次数
    private Map<Long, Long> matResoAdvertTradeClk7d; //创意素材+资源位 7天内不同广告行业券点击次数
    private Map<Long, Long> matResoAdvertTradeExp28d; //创意素材+资源位 28天内不同广告行业券曝光次数
    private Map<Long, Long> matResoAdvertTradeClk28d; //创意素材+资源位 28天内不同广告行业券点击次数
}
