/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.directly2;

import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxDataBaseDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxDataDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxDataSubDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxExpFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxExpStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxPkFactorReqDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.ExploreFactor;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxPkExplore {
    private static final Logger logger = LoggerFactory.getLogger(AdxPkExplore.class);

    public static ExploreFactor getExploreFactor(AdxPkFactorReqDo adxPkFactorReqDo) {
        Map<Long, AdxDataDo> resDataDoMap = adxPkFactorReqDo.getResDataDoMap();
        Map<Long, AdxDataDo> ideaDataDoMap = adxPkFactorReqDo.getIdeaDataDoMap();
        ExploreFactor exploreFactor = adxPkFactorReqDo.getExploreFactor();
        try {
            resDataDoMap.forEach((resId, adxDataDo) -> {
                String pkPrefix = "resId" + resId;
                AdxExpFactorDo eFactor = ExploreFactor.getEFactor(exploreFactor, resId);
                AdxPkExplore.runEFactor(pkPrefix, adxDataDo, eFactor);
                exploreFactor.putResFactor((Long)resId, eFactor);
            });
            ideaDataDoMap.forEach((ideaId, adxDataDo) -> {
                String pkPrefix = "ideaId" + ideaId;
                AdxExpStatDo ideaStat = ExploreFactor.getIdeaStat(exploreFactor, ideaId);
                AdxPkExplore.runStat(pkPrefix, adxDataDo, ideaStat);
                exploreFactor.putIdeaStatDo((Long)ideaId, ideaStat);
            });
        }
        catch (Exception e) {
            logger.info("AdxPkExplore.getExploreFactor error", (Throwable)e);
        }
        return exploreFactor;
    }

    public static void runEFactor(String pkPrefix, AdxDataDo adxDataDo, AdxExpFactorDo eFactor) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{pkPrefix, adxDataDo, eFactor})) {
            return;
        }
        try {
            Double resFactor = eFactor.getResFactor();
            AdxDataSubDo statSubDoDay = adxDataDo.getStatSubDo2();
            AdxDataBaseDo resDataBaseDo = statSubDoDay.getAdxDataBaseDo();
            resFactor = AdxPkExplore.updateFactor(pkPrefix, resDataBaseDo, resFactor);
            eFactor.setResFactor(resFactor);
            Map<String, AdxDataBaseDo> adxDataBaseDoMap = statSubDoDay.getAdxDataBaseDoMap();
            adxDataBaseDoMap.forEach((appId, appDataBaseDo) -> {
                String prefix1 = pkPrefix + ",appId" + appId;
                Double appFactor = AdxExpFactorDo.getAppFactor(eFactor, appId);
                appFactor = AdxPkExplore.updateFactor(prefix1, appDataBaseDo, appFactor);
                eFactor.putAppFactor((String)appId, appFactor);
            });
        }
        catch (Exception e) {
            logger.info("AdxPkExplore.runEFactor error", (Throwable)e);
        }
    }

    public static void runStat(String prefix, AdxDataDo adxDataDo, AdxExpStatDo ideaStat) {
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{adxDataDo, ideaStat})) {
            return;
        }
        try {
            Double ideaEcpm = ideaStat.getIdeaEcpm();
            AdxDataSubDo statSubDoDay = adxDataDo.getStatSubDo2();
            AdxDataBaseDo resDataBaseDo = statSubDoDay.getAdxDataBaseDo();
            ideaEcpm = AdxPkExplore.updateStat(prefix, resDataBaseDo, ideaEcpm);
            ideaStat.setIdeaEcpm(ideaEcpm);
            Map<String, AdxDataBaseDo> adxDataBaseDoMap = statSubDoDay.getAdxDataBaseDoMap();
            adxDataBaseDoMap.forEach((appId, appDataBaseDo) -> {
                String prefix1 = prefix + ",appId" + appId;
                Double appEcpm = AdxExpStatDo.getAppEcpm(ideaStat, appId);
                appEcpm = AdxPkExplore.updateStat(prefix1, appDataBaseDo, appEcpm);
                ideaStat.putAppEcpm((String)appId, appEcpm);
            });
        }
        catch (Exception e) {
            logger.info("AdxPkExplore.runStat error", (Throwable)e);
        }
    }

    public static Double updateFactor(String pkPrefix, AdxDataBaseDo adxDataBaseDo, Double factor) {
        Double ret = factor;
        if (adxDataBaseDo == null) {
            return ret;
        }
        Double costDiff = AdxDataBaseDo.getCostDiff(adxDataBaseDo);
        ret = MathUtil.mean((Double)factor, (Double)costDiff, (Double)0.2);
        if (ret == null) {
            ret = 0.2;
        }
        ret = MathUtil.stdwithBoundary((double)ret, (double)0.2, (double)0.4);
        logger.info("pk{}, resFactor{}, lastFactor{}, costDiff{}", new Object[]{pkPrefix, ret, factor, costDiff});
        return ret;
    }

    public static Double updateStat(String prefix, AdxDataBaseDo adxDataBaseDo, Double ecpm) {
        Double ret = ecpm;
        if (adxDataBaseDo == null) {
            return ret;
        }
        Double statEcpm = AdxDataBaseDo.getIdeaEcpm(adxDataBaseDo);
        ret = MathUtil.mean((Double)ecpm, (Double)statEcpm, (Double)0.2);
        if (ret == null) {
            ret = 300.0;
        }
        ret = MathUtil.stdwithBoundary((double)ret, (double)30.0, (double)3000.0);
        logger.info("pk{}, ecpm{}, lastEcpm{}, statEcpm{}", new Object[]{prefix, ret, ecpm, statEcpm});
        return ret;
    }
}

