package cn.com.duiba.nezha.alg.alg.params;

import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxResourceRcmdDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.rcmd.AdxIdeaFeatureDo;
import cn.com.duiba.nezha.alg.feature.vo.AdxFeatureDo;
import cn.com.duiba.nezha.alg.model.CODER;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;

import java.util.List;

public class AdxIdeaRcmdParam {

    /**
     * 创意特征对象List
     *
     * 限定有效创意，拼接创意特征
     */
    private List<AdxIdeaFeatureDo> ideaFeatureList;

    /**
     * 非创意特征对象
     *
     *
     */
    private AdxFeatureDo adxFeatureDo;


    /**
     * 资源位创意推荐统计对象
     *
     * 定时任务输出对象
     * 创意算法1.0 入参
     *
     */
    private AdxResourceRcmdDo adxResourceRcmdDo;



    /**
     * 编码器模型
     *
     * redis热加载，本地异步缓存5分钟
     *
     */
    private CODER coderModel;

    /**
     * 本地TF深度模型
     *
     * nas热加载，本地异步缓存5分钟
     *
     *
     */
    private LocalTFModel ltfModel;

    /**
     * 更新的时候的模型，临时模型，用于预热
     */
    private LocalTFModel ltfModelTemp;

    public LocalTFModel getLtfModelTemp() {
        return ltfModelTemp;
    }

    public void setLtfModelTemp(LocalTFModel ltfModelTemp) {
        this.ltfModelTemp = ltfModelTemp;
    }

    public List<AdxIdeaFeatureDo> getIdeaFeatureList() {

        return ideaFeatureList;
    }

    public void setIdeaFeatureList(List<AdxIdeaFeatureDo> ideaFeatureList) {
        this.ideaFeatureList = ideaFeatureList;
    }

    public AdxFeatureDo getAdxFeatureDo() {
        return adxFeatureDo;
    }

    public void setAdxFeatureDo(AdxFeatureDo adxFeatureDo) {
        this.adxFeatureDo = adxFeatureDo;
    }

    public AdxResourceRcmdDo getAdxResourceRcmdDo() {
        return adxResourceRcmdDo;
    }

    public void setAdxResourceRcmdDo(AdxResourceRcmdDo adxResourceRcmdDo) {
        this.adxResourceRcmdDo = adxResourceRcmdDo;
    }

    public CODER getCoderModel() {
        return coderModel;
    }

    public void setCoderModel(CODER coderModel) {
        this.coderModel = coderModel;
    }

    public LocalTFModel getLtfModel() {
        return ltfModel;
    }

    public void setLtfModel(LocalTFModel ltfModel) {
        this.ltfModel = ltfModel;
    }
}
