package cn.com.duiba.nezha.alg.alg.vo.ocpxControl;

import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class PriceRiseParams {

    /**
     * 提价保量 控制参数
     */

    private Double prFactor; //提价保量因子

    private String updateTime;


    /**
     * 获取提价保量因子
     *
     * @param params
     * @return
     */
    public static Double getPrFactor(PriceRiseParams params) {

        Double ret = null;

        if (params != null) {

            if(params.getPrFactor() == null){
                params.setPrFactor(1.0);
            }
            ret = params.getPrFactor();

            //参数更新延迟，参数约束
            String updateTime = params.getUpdateTime();
            Long durationMin = LocalDateUtil.getIntervalMinutes(updateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
            if (durationMin == null || durationMin >= 30) {
                ret = MathUtil.stdwithBoundary(ret, 1.0, 1.0);
            } else if (durationMin >= 20) {
                ret = MathUtil.stdwithBoundary(ret, 1.0, 1.05);
            }

        }

        return ret;
    }

}
