/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.vo.advertsupport.AdvertSupportInfoV1;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.CvrMonitorInfoV1;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.CvrMonitorRes;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportData;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportDataAdd;
import cn.com.duiba.nezha.alg.alg.vo.advertsupport.SupportParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class StatCvrMonitor {
    public static CvrMonitorRes getCvrMonitorRes(AdvertSupportInfoV1 advertSupportInfo, CvrMonitorInfoV1 cvrMonitorInfo, SupportParams params, Long advStartExposure) {
        CvrMonitorRes res = new CvrMonitorRes();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertSupportInfo, params, cvrMonitorInfo})) {
            return res;
        }
        Double curStatCvr = StatCvrMonitor.getCurStatCvr(cvrMonitorInfo, advertSupportInfo, params.getMinDimClickThresh(), params.getHyperParam());
        if (AssertUtil.isNotEmpty((Object)advStartExposure) && advStartExposure > 0L && advertSupportInfo.getAdvert1Day().getExposure() - advStartExposure <= params.getExposeThresh()) {
            res.setAdjustStaCvr(curStatCvr);
            res.setHighCvrAjaRatio("2");
        } else if (AssertUtil.isNotEmpty((Object)advStartExposure) && advStartExposure > 0L && advertSupportInfo.getAdvert1Day().getExposure() - advStartExposure > params.getExposeThresh()) {
            res.setHighCvrAjaRatio("3");
        } else if (StatCvrMonitor.cvrMonitor(cvrMonitorInfo.getCurTenMinStaCvr(), curStatCvr, params.getCvrDisRatio()).booleanValue()) {
            res.setAdjustStaCvr(curStatCvr);
            res.setExposure(advertSupportInfo.getAdvert1Day().getExposure());
            res.setHighCvrAjaRatio("1");
        } else {
            res.setHighCvrAjaRatio("0");
        }
        res.setAdvertId(advertSupportInfo.getAdvertId());
        return res;
    }

    public static Boolean cvrMonitor(double curStatCvr, Double comCvr, double ratio) {
        if (AssertUtil.isEmpty((Object)comCvr)) {
            return false;
        }
        return curStatCvr < ratio * comCvr;
    }

    public static Double getCurStatCvr(CvrMonitorInfoV1 cvrMonitorInfo, AdvertSupportInfoV1 advertSupportInfoV1, Long threshold, Double hyperParam) {
        double res = 0.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertSupportInfoV1})) {
            return res;
        }
        Long dayTradeAppClick = cvrMonitorInfo.getDayTradeAppData().getClick();
        Long dayTradeAppConvert = cvrMonitorInfo.getDayTradeAppData().getConvert();
        Long dayTradeClick = cvrMonitorInfo.getDayTradeData().getClick();
        Long dayTradeConvert = cvrMonitorInfo.getDayTradeData().getConvert();
        Long dayTradeAppSecTagClick = cvrMonitorInfo.getDayTradeAppSecTagData().getClick();
        Long dayTradeAppSecTagConvert = cvrMonitorInfo.getDayTradeAppSecTagData().getConvert();
        Long triDayTradeAppClick = cvrMonitorInfo.getTriDayTradeAppData().getClick();
        Long triDayTradeAppConvert = cvrMonitorInfo.getTriDayTradeAppData().getConvert();
        Long triDayTradeClick = cvrMonitorInfo.getTriDayTradeData().getClick();
        Long triDayTradeConvert = cvrMonitorInfo.getTriDayTradeData().getConvert();
        Long triDayTradeAppSecTagClick = cvrMonitorInfo.getTriDayTradeAppSecTagData().getClick();
        Long triDayTradeAppSecTagConvert = cvrMonitorInfo.getTriDayTradeAppSecTagData().getConvert();
        Double dayTradeAppCvr = Optional.ofNullable(MathUtil.division((Long)dayTradeAppConvert, (Long)dayTradeAppClick, (int)6)).orElse(0.0);
        Double dayTradeCvr = Optional.ofNullable(MathUtil.division((Long)dayTradeConvert, (Long)dayTradeClick, (int)6)).orElse(0.0);
        Double dayTradeAppSecTagCvr = Optional.ofNullable(MathUtil.division((Long)dayTradeAppSecTagConvert, (Long)dayTradeAppSecTagClick, (int)6)).orElse(0.0);
        Double triDayTradeAppCvr = Optional.ofNullable(MathUtil.division((Long)triDayTradeAppConvert, (Long)triDayTradeAppClick, (int)6)).orElse(0.0);
        Double triDayTradeCvr = Optional.ofNullable(MathUtil.division((Long)triDayTradeConvert, (Long)triDayTradeClick, (int)6)).orElse(0.0);
        Double triDayTradeAppSecTagCvr = Optional.ofNullable(MathUtil.division((Long)triDayTradeAppSecTagConvert, (Long)triDayTradeAppSecTagClick, (int)6)).orElse(0.0);
        List<Long> clickList = Arrays.asList(dayTradeAppClick, dayTradeAppSecTagClick, dayTradeClick, triDayTradeAppClick, triDayTradeAppSecTagClick, triDayTradeClick);
        List<Double> cvrList = Arrays.asList(dayTradeAppCvr, dayTradeAppSecTagCvr, dayTradeCvr, triDayTradeAppCvr, triDayTradeAppSecTagCvr, triDayTradeCvr);
        int index = StatCvrMonitor.getMinDim(clickList, threshold);
        if (index == 6) {
            return 0.025;
        }
        List<Double> dimsWeights = StatCvrMonitor.getEachDimWeight(clickList.size() - index, hyperParam);
        for (int i = 0; i < dimsWeights.size(); ++i) {
            res += dimsWeights.get(i) * cvrList.get(i + index);
        }
        return res;
    }

    public static Integer getMinDim(List<Long> diffDimsClickList, Long threshold) {
        Integer res = 6;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{diffDimsClickList, threshold})) {
            return res;
        }
        for (Long diffDimsClick : diffDimsClickList) {
            diffDimsClick = diffDimsClick == null ? 0L : diffDimsClick;
            if (diffDimsClick < threshold) continue;
            return diffDimsClickList.indexOf(diffDimsClick);
        }
        return res;
    }

    public static List<Double> getEachDimWeight(Integer size, double hyperParam) {
        ArrayList<Double> res = new ArrayList<Double>();
        ArrayList<Double> tmp_y = new ArrayList<Double>();
        double totValue = 0.0;
        if (size.equals(0)) {
            return res;
        }
        for (int i = 0; i < size; ++i) {
            double curValue = Math.exp((double)(-1 * i) * hyperParam);
            tmp_y.add(curValue);
            totValue += curValue;
        }
        Iterator iterator = tmp_y.iterator();
        while (iterator.hasNext()) {
            double item = (Double)iterator.next();
            res.add(MathUtil.division((Double)item, (Double)totValue, (int)6));
        }
        return res;
    }

    public static void main(String[] args) {
        AdvertSupportInfoV1 info = new AdvertSupportInfoV1();
        CvrMonitorInfoV1 cvrInfo = new CvrMonitorInfoV1();
        SupportData advert3Day = new SupportData();
        advert3Day.setClick(10L);
        HashMap<Integer, Long> convs = new HashMap<Integer, Long>();
        convs.put(1, 10L);
        convs.put(3, 10L);
        advert3Day.setConv(convs);
        advert3Day.setExposure(100L);
        advert3Day.setConsume(100L);
        advert3Day.setOcpcConsume(100L);
        advert3Day.setCost(50.0);
        advert3Day.setCostBias(1.0);
        info.setAdvert1Day(advert3Day);
        info.setAdvertId(12346L);
        double curTenMinStaCvr = 2.5E-4;
        cvrInfo.setCurTenMinStaCvr(curTenMinStaCvr);
        SupportDataAdd dayTradeAppData = new SupportDataAdd();
        SupportDataAdd dayTradeData = new SupportDataAdd();
        SupportDataAdd dayTradeAppSecTagData = new SupportDataAdd();
        SupportDataAdd triDayTradeAppData = new SupportDataAdd();
        SupportDataAdd triDayTradeData = new SupportDataAdd();
        SupportDataAdd triDayTradeAppSecTagData = new SupportDataAdd();
        dayTradeAppData.setClick(10L);
        dayTradeAppData.setConvert(0L);
        dayTradeData.setClick(3000L);
        dayTradeData.setConvert(200L);
        dayTradeAppSecTagData.setClick(6000L);
        dayTradeAppSecTagData.setConvert(300L);
        triDayTradeAppData.setClick(100000L);
        triDayTradeAppData.setConvert(2500L);
        triDayTradeData.setClick(500000L);
        triDayTradeData.setConvert(10000L);
        triDayTradeAppSecTagData.setClick(1000000L);
        triDayTradeAppSecTagData.setConvert(15000L);
        cvrInfo.setDayTradeAppData(dayTradeAppData);
        cvrInfo.setDayTradeData(dayTradeData);
        cvrInfo.setDayTradeAppSecTagData(dayTradeAppSecTagData);
        cvrInfo.setTriDayTradeAppData(triDayTradeAppData);
        cvrInfo.setTriDayTradeData(triDayTradeData);
        cvrInfo.setTriDayTradeAppSecTagData(triDayTradeAppSecTagData);
        SupportParams params = new SupportParams();
        params.setMinDimClickThresh(5000L);
        params.setExposeThresh(2000L);
        params.setCvrDisRatio(0.1);
        params.setHyperParam(1.0);
        CvrMonitorRes f = StatCvrMonitor.getCvrMonitorRes(info, cvrInfo, params, null);
        System.out.println(JSON.toJSONString((Object)f));
    }
}

