package cn.com.duiba.nezha.alg.alg.advert;

import cn.com.duiba.nezha.alg.alg.advert.v2.BidExploreStrategy;
import cn.com.duiba.nezha.alg.alg.advert.v2.BidJichengStrategy;
import cn.com.duiba.nezha.alg.alg.advert.v2.BidReCostStrategy;
import cn.com.duiba.nezha.alg.alg.vo.advert.AbTestDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;


/**
 * 广告出价控制模块
 */
public class BidExploreAlg {


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、探价
     * 4、底价放弃
     * 5、预算平滑（暂无）
     * 6、纠偏出价调节（暂无）
     * <p>
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象
     * <p>
     * 输出说明：
     * 1、出价、是否放弃
     * 2、控制参数
     *
     * @param controlResultMap 出价返回对象
     * @param adEEModelMap     探价对象         redis_key         String key = "NZ_K119_1_" + advertId ;
     * @param appGroupDo       媒体包映射对象    redis_key         String key = "NZ_K119_2_app";
     * @return
     */
    public static Map<String, AdBidResultDo> bidExplore(Map<String, AdBidResultDo> controlResultMap,

                                                        Map<Long, AdExploreModel> adEEModelMap,

                                                        AppGroupDo appGroupDo,

                                                        Long slotId,
                                                        Integer putIndex,
                                                        Integer eeAbTestId

    ) {

        if (AssertUtil.isEmpty(controlResultMap)) {
            return controlResultMap;
        }

        BidExploreStrategy.updateInfo(controlResultMap, appGroupDo, putIndex, slotId);
        /**
         * 探价实验
         */
        if (eeAbTestId != null && eeAbTestId.equals(2) && AssertUtil.isNotEmpty(adEEModelMap)) {

            /**
             * 探价+起量
             */

            BidExploreStrategy.bidExplore(controlResultMap, adEEModelMap, appGroupDo, putIndex, slotId);

            /**
             * 一键继承
             */
            BidJichengStrategy.jichengExplore(controlResultMap, adEEModelMap);


        }


        /**
         * 计费调节
         */
        //BidReCostStrategy.reCost(controlResultMap);

        return controlResultMap;


    }


    public static void main(String[] args) {
        Map<String, AdBidResultDo> controlResultMap = getControlResultMap();
        Long slotId = 1L;

        Map<Long, AdExploreModel> adEEModelMap = getAdEEModelMap();
        AppGroupDo appGroupDo = getAppGroupDo();
        AbTestDo abTestDo = getAbTestDo();

        bidExplore(controlResultMap, adEEModelMap, appGroupDo, 100L, 1, 2);

        System.out.println(JSON.toJSONString(controlResultMap));
    }


    public static Map<String, AdBidResultDo> getControlResultMap() {

        Map<String, AdBidResultDo> ret = new HashMap<>();

        AdBidResultDo d1 = new AdBidResultDo();

        d1.setAdvertId(10L);
        d1.setAccountId(101L);
        d1.setFee(130L);

        d1.setCtr(0.5);
        d1.setChargeType(2);

        AdBidParamsDo adp1 = new AdBidParamsDo();
        adp1.setFee(130L);
        adp1.setOriginalFee(90L);

        adp1.setSecondPriceProject(true);
        adp1.setCFactor(0.6);

        adp1.setExtraCFactor(0.8);
        adp1.setExtraCSwitch(1);
        d1.setAdBidParamsDo(adp1);


        AdBidResultDo d2 = new AdBidResultDo();

        d2.setAdvertId(11L);
        d2.setAccountId(101L);
        d2.setFee(100L);

        d2.setCtr(0.5);
        d2.setChargeType(2);

        AdBidParamsDo adp2 = new AdBidParamsDo();
        adp2.setFee(100L);
        adp2.setOriginalFee(90L);

        adp2.setSecondPriceProject(true);
        adp2.setCFactor(0.7);

        adp2.setExtraCFactor(0.8);
        adp2.setExtraCSwitch(1);
        d2.setAdBidParamsDo(adp2);


        AdBidResultDo d3 = new AdBidResultDo();

        d3.setAdvertId(12L);
        d3.setAccountId(101L);
        d3.setFee(90L);

        d3.setCtr(0.5);
        d3.setChargeType(2);

        AdBidParamsDo adp3 = new AdBidParamsDo();
        adp3.setFee(90L);
        adp3.setOriginalFee(90L);

        adp3.setSecondPriceProject(true);
        adp3.setCFactor(0.4);

        adp3.setExtraCFactor(0.8);
        adp3.setExtraCSwitch(1);
        d3.setAdBidParamsDo(adp3);


        ret.put("10", d1);
//        ret.put("11", d2);
//
//        ret.put("12", d3);


        return ret;
    }


    public static Map<Long, AdExploreModel> getAdEEModelMap() {

        Map<Long, AdExploreModel> ret = new HashMap<>();

        AdExploreModel d1 = new AdExploreModel();
        d1.setIsHighQualityAd(true);
        //d1.setIsJiCheng(false);
        d1.setJcRatio(1.0);
        AdControlParams a1 = new AdControlParams();
        a1.setIsEE(true);
        a1.setEeFactor(1.2);
        a1.setEeFactor2(1.2);
        a1.setEeRatio(0.8);
        a1.setIsQiliang(true);
        d1.setAdEEParams(a1);


        AdExploreModel d2 = new AdExploreModel();
        //d2.setIsHighQualityAd(true);
        d2.setIsJiCheng(false);
        d2.setJcRatio(0.1);
        AdControlParams a2 = new AdControlParams();
        a2.setIsEE(true);
        a2.setEeFactor(1.2);
        a2.setEeRatio(0.9);
        a2.setIsQiliang(true);
        d2.setAdEEParams(a2);


        AdExploreModel d3 = new AdExploreModel();
        // d3.setIsHighQualityAd(true);
        d3.setIsJiCheng(true);
        //d3.setJcRatio(1.);
        AdControlParams a3 = new AdControlParams();
        a3.setIsEE(true);
        a3.setEeFactor(1.2);
        a3.setEeFactor2(1.0);
        a3.setEeRatio(0.9);
        a3.setIsQiliang(true);
        a3.setQlFactor(1.1);
        d3.setAdEEParams(a3);

        ret.put(10L, d1);
        ret.put(11L, d2);
        ret.put(12L, d3);


        return ret;
    }

    public static AppGroupDo getAppGroupDo() {

        AppGroupDo appGroupDo=new AppGroupDo();

        appGroupDo.getAppGroupMap().put(100L,"a100");
        return appGroupDo;
    }


    public static AbTestDo getAbTestDo() {
        AbTestDo abTestDo = new AbTestDo();
        abTestDo.setEeAbTestId(2);
        return abTestDo;
    }


}
