package cn.com.duiba.nezha.alg.alg.alg;

import cn.com.duiba.nezha.alg.alg.advert.v2.BidControlStrategy;
import cn.com.duiba.nezha.alg.alg.advert.v2.BidExploreStrategy;
import cn.com.duiba.nezha.alg.alg.advert.v2.BidJichengStrategy;
import cn.com.duiba.nezha.alg.alg.advert.v2.BidReCostStrategy;
import cn.com.duiba.nezha.alg.alg.vo.advert.AbTestDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidInputDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.alg.vo.ee.AdExploreModel;
import cn.com.duiba.nezha.alg.alg.vo.ee.AppGroupDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlModel;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import java.util.Map;


/**
 * 广告出价控制模块
 */
public class AdBidControlAlg {


    /**
     * 出价控制
     * 描述：
     * 包含所有算法出价调节策略
     * 1、出价维稳调节
     * 2、价格保护
     * 3、探价
     * 4、底价放弃
     * 5、预算平滑（暂无）
     * 6、纠偏出价调节（暂无）
     *
     * 输入说明：
     * 1、所有配置集合
     * 2、算法控制参数对象

     * 输出说明：
     * 1、出价、是否放弃
     * 2、控制参数
     */

    /**
     * @param advertMap   竞价广告列表
     * @param paramsModel 控制参数对象
     */
    public static Map<String, AdBidResultDo> bidControl(Map<String, AdBidInputDo> advertMap,
                                                        OcpxControlModel paramsModel,

                                                        Map<Long, AdExploreModel> adEEModelMap,
                                                        AppGroupDo appGroupDo,

                                                        Long slotId,
                                                        AbTestDo abTestDo
    ) {


        /**
         * 1 成本控制
         */
        Map<String, AdBidResultDo> ret = BidControlStrategy.bidControl(advertMap, paramsModel, abTestDo);


        Integer eeAbTestId = null;
        if (abTestDo != null) {
            eeAbTestId = abTestDo.getEeAbTestId();
        }


        /**
         * 探价实验
         */
        if (eeAbTestId != null && eeAbTestId.equals(2) && AssertUtil.isNotEmpty(adEEModelMap)) {

            /**
             *  2 探价+起量
             */
            BidExploreStrategy.bidExplore(ret, adEEModelMap, appGroupDo, 1,slotId);

            /**
             * 3 一键继承
             */

            BidJichengStrategy.jichengExplore(ret, adEEModelMap);


        }

        /**
         *  4 计费调节
         */

        BidReCostStrategy.reCost(ret);

        return ret;

    }

}
