/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adsupport;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AdvertSupportInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.BiasAndConfidenceDo;
import cn.com.duiba.nezha.alg.alg.vo.BiddingRateDo;
import cn.com.duiba.nezha.alg.alg.vo.BiddingStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.SupportDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import java.util.HashMap;
import java.util.Map;

public class NewAdvertSupport {
    static double[] costWeightBucket = new double[]{10.0, 20.0, 50.0, 100.0, 200.0, 500.0};
    static double[] costWeight = new double[]{0.0, 0.3, 0.8, 1.0, 1.0, 1.1};
    static double[] costEffectWeightBucket = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
    static double[] costEffectWeight = new double[]{0.0, 0.3, 0.8, 1.0, 1.0, 1.1};
    static double[] slotBiasBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 1.0, 2.0, 3.0, 5.0};
    static double[] slotBiasWeight = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 10.0, 16.0};
    static double[] globalBiasBucket = new double[]{0.0, 0.1, 0.2, 0.3, 0.5, 1.0, 2.0};
    static double[] globalBiasWeight = new double[]{0.1, 0.12, 0.18, 0.5, 1.0, 1.0, 2.0};
    static double[] absWeightBucket = new double[]{0.0, 10.0, 20.0, 50.0, 100.0, 200.0};
    static double[] absWeight = new double[]{0.0, 0.3, 0.5, 0.8, 1.0, 1.2};
    static double[] relWeightBucket = new double[]{0.0, 1.0, 2.0, 5.0, 10.0, 20.0};
    static double[] relWeight = new double[]{0.0, 0.3, 0.5, 0.8, 1.0, 1.2};

    public static Double circuitBreaker(AdvertSupportInfoDo supportAdvert) {
        Double ret = null;
        if (AssertUtil.isEmpty((Object)supportAdvert)) {
            return ret;
        }
        AdvertSupportInfoDo adDo = supportAdvert;
        if (adDo != null && adDo.getAdvertSupportType() == 1) {
            ret = 0.5;
        }
        if (adDo != null && adDo.getAFee() != null && adDo.getAFee() > 0L && adDo.getAdvertSupportType() == 0) {
            BiasAndConfidenceDo adSlotBias;
            BiasAndConfidenceDo adBias = NewAdvertSupport.costBias(adDo.getConsume(), adDo.getLandingPageClickPV(), adDo.getAFee(), 1);
            Double breakerScore = NewAdvertSupport.circuitBreaker(adBias, adSlotBias = NewAdvertSupport.costBias(adDo.getSlotConsume(), adDo.getSlotLandingPageClickPV(), adDo.getAFee(), 2));
            if (breakerScore <= 1.0) {
                ret = breakerScore;
            } else if (adBias.getBias() < 0.1 && Math.random() * 5.0 > adSlotBias.getBias() && Math.random() > 0.95) {
                ret = breakerScore;
            }
        }
        return ret;
    }

    public static <T> Map<T, Double> circuitBreaker(Map<T, AdvertSupportInfoDo> supportAdvertMap) {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        for (Map.Entry<T, AdvertSupportInfoDo> entry : supportAdvertMap.entrySet()) {
            BiasAndConfidenceDo adSlotBias;
            AdvertSupportInfoDo adDo = entry.getValue();
            if (adDo == null || adDo.getAFee() <= 0L) continue;
            BiasAndConfidenceDo adBias = NewAdvertSupport.costBias(adDo.getConsume(), adDo.getLandingPageClickPV(), adDo.getAFee(), 1);
            Double breakerScore = NewAdvertSupport.circuitBreaker(adBias, adSlotBias = NewAdvertSupport.costBias(adDo.getSlotConsume(), adDo.getSlotLandingPageClickPV(), adDo.getAFee(), 2));
            if (breakerScore <= 1.0) {
                ret.put(entry.getKey(), breakerScore);
                continue;
            }
            if (!(adBias.getBias() < 0.1) || !(Math.random() * 5.0 > adSlotBias.getBias()) || !(Math.random() > 0.95)) continue;
            ret.put(entry.getKey(), breakerScore);
        }
        return ret;
    }

    public static Double circuitBreaker(BiasAndConfidenceDo adBias, BiasAndConfidenceDo adSlotBias) {
        Double breakerScore = 0.0;
        Double biasFactor = adBias.getBiasFactor() * adSlotBias.getBiasFactor();
        Double confidenceCostWeight = adBias.getConfidenceCostWeight() * adSlotBias.getConfidenceCostWeight();
        Double confidenceEffectWeight = adBias.getConfidenceCostEffectWeight() * adSlotBias.getConfidenceCostEffectWeight();
        breakerScore = biasFactor * confidenceCostWeight * confidenceEffectWeight;
        return DataUtil.formatDouble((Double)breakerScore, (int)3);
    }

    public static Double getConfidenceWeight(double value, double[] bucketList, double[] weightList, double defaultValue) {
        double ret = defaultValue;
        if (bucketList != null && bucketList.length > 0 && weightList != null && weightList.length == bucketList.length) {
            double lastWeight = weightList[0];
            double lastBound = bucketList[0];
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (value <= bound) {
                    double curWeight = weightList[i];
                    double curBound = bucketList[i];
                    if (i > 0) {
                        ret = lastWeight + (curWeight - lastWeight) * (value - lastBound) / (curBound - lastBound);
                        break;
                    }
                    ret = curWeight;
                    break;
                }
                lastWeight = weightList[i];
                lastBound = bucketList[i];
            }
        }
        return DataUtil.formatDouble((Double)ret, (int)3);
    }

    public static <T> Map<T, Double> biddingFactor0(Map<T, Double> supportAdvertCircuitBreakerMap, Map<T, BudgetSmoothDo> budgetSmoothFactorMap, Map<T, Double> statCVRMap, Map<T, Double> preCVRMap) {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{supportAdvertCircuitBreakerMap, statCVRMap, preCVRMap})) {
            return ret;
        }
        for (Map.Entry<T, Double> entry : supportAdvertCircuitBreakerMap.entrySet()) {
            T key = entry.getKey();
            Double breakerScore = entry.getValue();
            Double statCVR = statCVRMap.get(key);
            Double preCVR = preCVRMap.get(key);
            BudgetSmoothDo budgetSmoothDo = budgetSmoothFactorMap.get(key);
            Double factor = NewAdvertSupport.biddingFactor(breakerScore, budgetSmoothDo, statCVR, preCVR);
            if (factor == null) continue;
            ret.put(key, factor);
        }
        return ret;
    }

    public static Double biddingSupportFactor(Double breakerScore, BudgetSmoothDo budgetSmoothDo, Double statCVR, Double preCVR) {
        return NewAdvertSupport.biddingFactor(breakerScore, budgetSmoothDo, statCVR, preCVR);
    }

    public static Double biddingFactor(Double breakerScore, BudgetSmoothDo budgetSmoothDo, Double statCVR, Double preCVR) {
        Double ret = 1.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{breakerScore, budgetSmoothDo, statCVR, preCVR})) {
            return ret;
        }
        Double ratio = budgetSmoothDo.getRatio();
        if (ratio != null && ratio < 0.99 && breakerScore < 0.99) {
            double smoothFactor1 = MathBase.sigmoidWithZoomAndIntervalMap(0.8 - ratio, 0.8, 2.0, 8.0);
            double smoothFactor = 1.0 + (smoothFactor1 - 1.0) * MathBase.noiseSmoother(1.5 - breakerScore, 0.1, 1.0);
            ret = DataUtil.formatDouble((Double)smoothFactor, (int)4);
        }
        return ret;
    }

    public static BiasAndConfidenceDo costBias(Long consume, Long landingPageClickPV, long aFee, int type) {
        BiasAndConfidenceDo ret = new BiasAndConfidenceDo();
        Double bias = 0.0;
        Double confidence = 0.0;
        Double costConfidenceWeight = 1.1;
        Double costEffectConfidenceWeight = 1.1;
        Double globalBiasFactor = 2.0;
        Double slotBiasFactor = 20.0;
        if (aFee > 0L) {
            if (consume == null) {
                consume = 0L;
            }
            if (landingPageClickPV == null) {
                landingPageClickPV = 0L;
            }
            if (consume <= 1L) {
                bias = 0.0;
                confidence = 0.0;
            } else if (landingPageClickPV == null || landingPageClickPV < 1L) {
                bias = DataUtil.division((Long)consume, (Long)aFee, (int)3);
                confidence = DataUtil.division((Long)consume, (Long)aFee, (int)2);
            } else {
                bias = DataUtil.division((Long)consume, (Long)(aFee * landingPageClickPV), (int)3) - 1.0;
                confidence = DataUtil.division((Long)consume, (Long)aFee, (int)2);
            }
            if (type == 1) {
                globalBiasFactor = NewAdvertSupport.getConfidenceWeight(bias, globalBiasBucket, globalBiasWeight, globalBiasFactor);
                ret.setBiasFactor(globalBiasFactor);
            } else {
                slotBiasFactor = NewAdvertSupport.getConfidenceWeight(bias, slotBiasBucket, slotBiasWeight, slotBiasFactor);
                ret.setBiasFactor(slotBiasFactor);
            }
            costConfidenceWeight = NewAdvertSupport.getConfidenceWeight(consume / 100L, costWeightBucket, costWeight, costConfidenceWeight);
            costEffectConfidenceWeight = NewAdvertSupport.getConfidenceWeight(confidence, costEffectWeightBucket, costEffectWeight, costEffectConfidenceWeight);
            ret.setConfidenceCostWeight(costConfidenceWeight);
            ret.setConfidenceCostEffectWeight(costEffectConfidenceWeight);
        }
        ret.setConsume(consume);
        ret.setBias(bias);
        ret.setConfidence(confidence);
        return ret;
    }

    public static Double biddingSupportFactor(SupportDo supportDo, BudgetSmoothDo budgetSmoothDo, BiddingStatDo biddingStatDo, AdvertSupportInfoDo advertSupportInfoDo) {
        return NewAdvertSupport.biddingFactor(supportDo, budgetSmoothDo, biddingStatDo, advertSupportInfoDo);
    }

    public static <T> Map<T, Double> biddingFactor(Map<T, SupportDo> supportDoMap, Map<T, BudgetSmoothDo> budgetSmoothDoMap, Map<T, BiddingStatDo> biddingStatDoMap, Map<T, AdvertSupportInfoDo> advertSupportInfoDoMap) {
        HashMap<T, Double> ret = new HashMap<T, Double>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{supportDoMap, budgetSmoothDoMap, biddingStatDoMap, advertSupportInfoDoMap})) {
            return ret;
        }
        for (Map.Entry<T, SupportDo> entry : supportDoMap.entrySet()) {
            AdvertSupportInfoDo advertSupportInfoDo;
            BiddingStatDo biddingStatDo;
            BudgetSmoothDo budgetSmoothDo;
            T key = entry.getKey();
            SupportDo supportDo = entry.getValue();
            Double factor = NewAdvertSupport.biddingFactor(supportDo, budgetSmoothDo = budgetSmoothDoMap.get(key), biddingStatDo = biddingStatDoMap.get(key), advertSupportInfoDo = advertSupportInfoDoMap.get(key));
            if (factor == null) continue;
            ret.put(key, factor);
        }
        return ret;
    }

    public static Double biddingFactor(SupportDo supportDo, BudgetSmoothDo budgetSmoothDo, BiddingStatDo biddingStatDo, AdvertSupportInfoDo advertSupportInfoDo) {
        Double biddingRateFactor;
        Double confidenceSupportFactor;
        Double circuitBreakerFactor;
        Double ret = 1.0;
        if (advertSupportInfoDo.getAdvertSupportType() == 1) {
            ret = 2.0;
        }
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{supportDo, budgetSmoothDo, biddingStatDo})) {
            return ret;
        }
        Double ratio = budgetSmoothDo.getRatio();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ratio, circuitBreakerFactor = supportDo.getCircuitBreakerFactor(), confidenceSupportFactor = supportDo.getConfidenceSupportFactor(), biddingRateFactor = NewAdvertSupport.biddingRateFactor(biddingStatDo)})) {
            return ret;
        }
        if (circuitBreakerFactor < 0.99) {
            ratio = ratio < 0.99 ? ratio : 0.99;
            double smoothFactor1 = MathBase.sigmoidWithZoomAndIntervalMap(0.8 - ratio, 0.8, 2.0, 8.0);
            double smoothFactor2 = Math.max(smoothFactor1, biddingRateFactor);
            double smoothFactor = 1.0 + (smoothFactor2 - 1.0) * MathBase.noiseSmoother(1.5 - circuitBreakerFactor, 0.1, 1.0) * confidenceSupportFactor;
            ret = DataUtil.formatDouble((Double)smoothFactor, (int)4);
        }
        return ret;
    }

    public static <T> Map<T, SupportDo> circuitBreakerNew(Map<T, AdvertSupportInfoDo> supportAdvertMap) {
        HashMap<T, SupportDo> ret = new HashMap<T, SupportDo>();
        if (AssertUtil.isEmpty(supportAdvertMap)) {
            return ret;
        }
        for (Map.Entry<T, AdvertSupportInfoDo> entry : supportAdvertMap.entrySet()) {
            T key = entry.getKey();
            AdvertSupportInfoDo supportAdvert = supportAdvertMap.get(key);
            SupportDo supportDo = new SupportDo();
            Double circuitBreakerFactor = 0.5;
            Double confidenceSupportFactor = 1.0;
            if (supportAdvert.getAdvertSupportType() != null && supportAdvert.getAdvertSupportType() == 0) {
                circuitBreakerFactor = NewAdvertSupport.circuitBreaker(supportAdvert);
                confidenceSupportFactor = NewAdvertSupport.confidenceSupportFactor(supportAdvert);
            }
            if (circuitBreakerFactor == null || confidenceSupportFactor == null) continue;
            supportDo.setCircuitBreakerFactor(circuitBreakerFactor);
            supportDo.setConfidenceSupportFactor(confidenceSupportFactor);
            ret.put(entry.getKey(), supportDo);
        }
        return ret;
    }

    public static SupportDo circuitBreakerNew(AdvertSupportInfoDo supportAdvert) {
        SupportDo ret = null;
        if (AssertUtil.isEmpty((Object)supportAdvert)) {
            return ret;
        }
        SupportDo supportDo = new SupportDo();
        Double circuitBreakerFactor = 0.5;
        Double confidenceSupportFactor = 1.0;
        if (supportAdvert.getAdvertSupportType() != null && supportAdvert.getAdvertSupportType() == 0) {
            circuitBreakerFactor = NewAdvertSupport.circuitBreaker(supportAdvert);
            confidenceSupportFactor = NewAdvertSupport.confidenceSupportFactor(supportAdvert);
        }
        if (circuitBreakerFactor != null && confidenceSupportFactor != null) {
            ret = new SupportDo();
            ret.setCircuitBreakerFactor(circuitBreakerFactor);
            ret.setConfidenceSupportFactor(confidenceSupportFactor);
        }
        return ret;
    }

    public static Double confidenceSupportFactor(AdvertSupportInfoDo supportAdvert) {
        Double confidenceSupportFactor = 1.0;
        Double absConfidenceWeight = 1.1;
        Double relConfidenceWeight = 1.1;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{supportAdvert})) {
            return confidenceSupportFactor;
        }
        Long slotConsume = supportAdvert.getSlotConsume();
        Long aFee = supportAdvert.getAFee();
        Double confidence = 0.0;
        if (aFee != null && aFee > 0L) {
            if (slotConsume == null) {
                slotConsume = 0L;
            }
            confidence = slotConsume <= 1L ? Double.valueOf(0.0) : DataUtil.division((Long)slotConsume, (Long)aFee, (int)2);
            absConfidenceWeight = NewAdvertSupport.getConfidenceWeight(slotConsume / 100L, absWeightBucket, absWeight, absConfidenceWeight);
            relConfidenceWeight = NewAdvertSupport.getConfidenceWeight(confidence, relWeightBucket, relWeight, relConfidenceWeight);
            Double confidenceFactor = absConfidenceWeight * relConfidenceWeight;
            confidenceSupportFactor = Math.max(0.0, 1.0 - confidenceFactor);
        }
        return confidenceSupportFactor;
    }

    public static Double biddingRateFactor(BiddingStatDo biddingStatDo) {
        Double globalBiddingRate;
        Double tradeBiddingRate;
        Double advertBiddingRate;
        Double advertAndPlanBiddingRate;
        Long globalBiddingTimes;
        Long tradeBiddingTimes;
        Long advertBiddingTimes;
        BiddingRateDo globalBiddingBiddingRateDo;
        BiddingRateDo tradeBiddingBiddingRateDo;
        BiddingRateDo advertBiddingRateDo;
        Double biddingRateFactor = 1.0;
        Double maxBiddingRateFactor = 2.0;
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{biddingStatDo})) {
            return biddingRateFactor;
        }
        BiddingRateDo advertAndPlanBiddingRateDo = biddingStatDo.getAdvertAndPlanBiddingRateDo();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertAndPlanBiddingRateDo, advertBiddingRateDo = biddingStatDo.getAdvertBiddingRateDo(), tradeBiddingBiddingRateDo = biddingStatDo.getTradeBiddingBiddingRateDo(), globalBiddingBiddingRateDo = biddingStatDo.getGlobalBiddingBiddingRateDo()})) {
            return biddingRateFactor;
        }
        Long advertAndPlanBiddingTimes = advertAndPlanBiddingRateDo.getBiddingTimes();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{advertAndPlanBiddingTimes, advertBiddingTimes = advertBiddingRateDo.getBiddingTimes(), tradeBiddingTimes = tradeBiddingBiddingRateDo.getBiddingTimes(), globalBiddingTimes = globalBiddingBiddingRateDo.getBiddingTimes(), advertAndPlanBiddingRate = advertAndPlanBiddingRateDo.getRate(), advertBiddingRate = advertBiddingRateDo.getRate(), tradeBiddingRate = tradeBiddingBiddingRateDo.getRate(), globalBiddingRate = globalBiddingBiddingRateDo.getRate()})) {
            return biddingRateFactor;
        }
        double planAdvertBiddingRateRatio = DataUtil.division((Double)advertAndPlanBiddingRate, (Double)advertBiddingRate, (int)4);
        double planTradeBiddingRateRatio = DataUtil.division((Double)advertAndPlanBiddingRate, (Double)tradeBiddingRate, (int)4);
        double planGlobalBiddingRateRatio = DataUtil.division((Double)advertAndPlanBiddingRate, (Double)globalBiddingRate, (int)4);
        double averageBiddingRateRatio = 0.1 * planAdvertBiddingRateRatio + 0.6 * planTradeBiddingRateRatio + 0.3 * planGlobalBiddingRateRatio;
        if (advertAndPlanBiddingTimes > 500L && advertBiddingTimes > 1000L && tradeBiddingTimes > 1000L && globalBiddingTimes > 1000L && averageBiddingRateRatio <= 1.5) {
            biddingRateFactor = maxBiddingRateFactor - (maxBiddingRateFactor - 1.0) / 1.5 * averageBiddingRateRatio;
        }
        return biddingRateFactor;
    }
}

