/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.vo.NdAdvertFilterInfo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertInfo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertResultDo;
import cn.com.duiba.nezha.alg.alg.vo.NdAdvertStatusDo;
import cn.com.duiba.nezha.alg.alg.vo.NdFilterAppInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdAdvertSupportOrigin1 {
    private static final Logger logger = LoggerFactory.getLogger(NdAdvertSupportOrigin1.class);
    public static Comparator<RectifyNdAdvertResInfo> iComparator = new Comparator<RectifyNdAdvertResInfo>(){

        @Override
        public int compare(RectifyNdAdvertResInfo r1, RectifyNdAdvertResInfo r2) {
            return r2.rectifyBid - r1.rectifyBid >= 0.0 ? 1 : -1;
        }
    };

    public static List<NdAdvertResultDo> NDAdvertColdStartAndExpose(NdFilterAppInfo ndFilterAppInfo, List<NdAdvertFilterInfo> ndAdvertFilterInfoList, List<NdAdvertInfo> ndAdvertInfoList) {
        ArrayList<NdAdvertResultDo> res = new ArrayList<NdAdvertResultDo>();
        PriorityQueue<RectifyNdAdvertResInfo> candis = new PriorityQueue<RectifyNdAdvertResInfo>(iComparator);
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertFilterInfoList, ndAdvertInfoList}) || ndAdvertFilterInfoList.size() != ndAdvertInfoList.size()) {
            return res;
        }
        Long hisAppConvert = ndFilterAppInfo.getHisAppConvert();
        Double hisAppCVR = ndFilterAppInfo.getHisAppCVR();
        Long hisAppConsume = ndFilterAppInfo.getHisAppConsume();
        if (hisAppConvert <= (long)Constance.APP_CONVERT_THRESHOLD || hisAppCVR <= Constance.APP_CVR_THRESHOLD || (double)hisAppConsume.longValue() <= Constance.APP_CONSUME_THRESHOLD) {
            return res;
        }
        for (int i = 0; i < ndAdvertInfoList.size(); ++i) {
            double curRectifyBid = 0.0;
            RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new RectifyNdAdvertResInfo();
            if (AssertUtil.isAnyEmpty((Object[])new Object[]{ndAdvertInfoList.get(i), ndAdvertFilterInfoList.get(i)})) continue;
            Long hisSlotAdvExpose = ndAdvertFilterInfoList.get(i).getHisSlotAdvExpose();
            Long hisAdvertExploreConsume = ndAdvertFilterInfoList.get(i).getHisAdvertExploreConsume();
            Long hisAdvertConsume = ndAdvertFilterInfoList.get(i).getHisAdvertConsume();
            Map<String, Double> AdjustCVRRes = NdAdvertSupportOrigin1.getAdjustCVR(ndAdvertInfoList.get(i));
            double adjustWeight = AdjustCVRRes.get("adjustWeight");
            double adjustCvr = AdjustCVRRes.get("adjustCvr");
            double preCtr = ndAdvertInfoList.get(i).getPreCtr();
            Long bid = ndAdvertInfoList.get(i).getBid();
            if (hisSlotAdvExpose <= (long)Constance.EXPOSE_CONFIDENCE_THRESHOLD && (double)hisAdvertExploreConsume.longValue() <= Constance.EXPLORE_CONSUME_PERCENT_THRESHOLD * (double)hisAdvertConsume.longValue()) {
                curRectifyBid = hisSlotAdvExpose <= (long)Constance.EXPOSE_CONFIDENCE_THRESHOLD2 ? preCtr * adjustCvr * (double)bid.longValue() * NdAdvertSupportOrigin1.functionOfExpose(hisSlotAdvExpose) : preCtr * adjustCvr * (double)bid.longValue();
                rectifyNdAdvertResInfo.ndAdvertResult = NdAdvertSupportOrigin1.fillData(ndAdvertInfoList.get(i), 1.0, 1.0, adjustWeight, preCtr, adjustCvr);
                rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
                candis.add(rectifyNdAdvertResInfo);
                continue;
            }
            res.add(NdAdvertSupportOrigin1.fillData(ndAdvertInfoList.get(i), 1.0, 1.0, adjustWeight, preCtr, adjustCvr));
        }
        for (int idx = 0; idx < candis.size(); ++idx) {
            double curFactor = NdAdvertSupportOrigin1.functionOfRectifyFac(candis.size()).get(idx);
            RectifyNdAdvertResInfo curRectifyNdAdvertResInfo = (RectifyNdAdvertResInfo)candis.poll();
            curRectifyNdAdvertResInfo.ndAdvertResult.setAdjustFactor(curFactor);
            res.add(curRectifyNdAdvertResInfo.ndAdvertResult);
        }
        return res;
    }

    public static Map<String, Double> getAdjustCVR(NdAdvertInfo ndAdvertInfo) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        if (AssertUtil.isEmpty((Object)ndAdvertInfo)) {
            return null;
        }
        Double preCvr = ndAdvertInfo.getPreCvr();
        Long hisClick = ndAdvertInfo.getHisClick();
        Long hisConvert = ndAdvertInfo.getHisConvert();
        Double staCvr = MathUtil.division((Long)hisConvert, (Long)hisClick, (int)6);
        Long advTradeSlotDayClick = ndAdvertInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = ndAdvertInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = ndAdvertInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = ndAdvertInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = ndAdvertInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = ndAdvertInfo.getAdvTradeAppTradeTriDayStats().getClick();
        double minDimsStatCvr = 0.0;
        Long[] clickList = new Long[]{advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick, advTradeAppTriDayClick, advTradeAppTradeTriDayClick};
        NdAdvertStatusDo[] itemList = new NdAdvertStatusDo[]{ndAdvertInfo.getAdvTradeSlotDayStats(), ndAdvertInfo.getAdvTradeAppDayStats(), ndAdvertInfo.getAdvTradeAppTradeDayStats(), ndAdvertInfo.getAdvTradeSlotTriDayStats(), ndAdvertInfo.getAdvTradeAppTriDayStats(), ndAdvertInfo.getAdvTradeAppTradeTriDayStats()};
        if (clickList[clickList.length - 1] <= (long)Constance.CLICK_CONFIDENCE_THRESHOLD) {
            minDimsStatCvr = MathUtil.division((Long)itemList[clickList.length - 1].getConvert(), (Long)clickList[clickList.length - 1], (int)6);
        } else {
            for (int index = 0; index < clickList.length; ++index) {
                if (clickList[index] < (long)Constance.CLICK_CONFIDENCE_THRESHOLD) continue;
                minDimsStatCvr = MathUtil.division((Long)itemList[index].getConvert(), (Long)clickList[index], (int)6);
                break;
            }
        }
        double adjustWeight = 1.0;
        double adjustCvr = preCvr;
        adjustWeight = hisClick < (long)Constance.SEP_STAGE_THRESHOLD ? ((long)Constance.COLD_START_THRESHOLD1 <= hisClick && hisClick < (long)Constance.COLD_START_THRESHOLD2 ? (staCvr == 0.0 || staCvr < 0.4 * minDimsStatCvr ? 0.9 : 1.0) : ((long)Constance.COLD_START_THRESHOLD2 <= hisClick && hisClick < (long)Constance.COLD_START_THRESHOLD3 ? (staCvr == 0.0 || staCvr < 0.4 * minDimsStatCvr ? 0.8 : (staCvr < 0.7 * minDimsStatCvr ? 0.9 : 1.0)) : (hisClick >= (long)Constance.COLD_START_THRESHOLD3 ? (staCvr == 0.0 || staCvr < 0.4 * minDimsStatCvr ? 0.7 : (staCvr < 0.7 * minDimsStatCvr ? 0.8 : 1.0)) : 1.0))) : (staCvr == 0.0 ? 0.1 : 0.3 + 0.4 * Math.min(1.0, MathUtil.division((double)hisClick.longValue(), (int)2000, (int)6)));
        adjustCvr = hisClick >= (long)Constance.SEP_STAGE_THRESHOLD && staCvr != 0.0 ? (1.0 - adjustWeight) * preCvr + adjustWeight * staCvr : (adjustCvr *= adjustWeight);
        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        return res;
    }

    public static double functionOfExpose(Long exposeCnt) {
        double res = 1.0;
        double k = -4.0 * Math.exp(-4.0);
        double b = 1.2;
        res = k * (double)exposeCnt.longValue() + b;
        return res;
    }

    public static List<Double> functionOfRectifyFac(int size) {
        ArrayList<Double> res = new ArrayList<Double>();
        double weight = 1.0;
        Map<String, Double> KBMap1 = NdAdvertSupportOrigin1.calculateKAndB(0, (int)(0.1 * (double)size), 1.2, 1.1);
        Map<String, Double> KBMap2 = NdAdvertSupportOrigin1.calculateKAndB((int)(0.1 * (double)size) + 1, (int)(0.2 * (double)size), 1.1, 1.0);
        double k1 = KBMap1.get("K");
        double k2 = KBMap2.get("K");
        double b1 = KBMap1.get("B");
        double b2 = KBMap1.get("B");
        for (int i = 0; i < size; ++i) {
            if (i <= (int)(0.1 * (double)size)) {
                weight = k1 * (double)i + b1;
                res.add(weight);
                continue;
            }
            if ((int)(0.1 * (double)size) < i && i <= (int)(0.2 * (double)size)) {
                weight = k2 * (double)i + b2;
                res.add(weight);
                continue;
            }
            weight = 1.0;
            res.add(weight);
        }
        return res;
    }

    private static Map<String, Double> calculateKAndB(int x0, int x1, double y0, double y1) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double k = MathUtil.division((double)(y1 - y0), (int)(x1 - x0), (int)6);
        double b = y0 - k * (double)x0;
        res.put("K", k);
        res.put("B", b);
        return res;
    }

    private static NdAdvertResultDo fillData(NdAdvertInfo ndAdvertInfo, double adjustFactor, double ctrRectifyFactor, double cvrRectifyFactor, double rectifyCtr, double rectifyCvr) {
        NdAdvertResultDo ndAdvertRes = new NdAdvertResultDo();
        ndAdvertRes.setAdvertId(ndAdvertInfo.getAdvertId());
        ndAdvertRes.setPlanId(ndAdvertInfo.getPlanId());
        ndAdvertRes.setSlotId(ndAdvertInfo.getSlotId());
        ndAdvertRes.setAppId(ndAdvertInfo.getAppId());
        ndAdvertRes.setAdvertType(ndAdvertInfo.getAdvertType());
        ndAdvertRes.setAdjustFactor(adjustFactor);
        ndAdvertRes.setCtrRectifyFactor(ctrRectifyFactor);
        ndAdvertRes.setCvrRectifyFactor(cvrRectifyFactor);
        ndAdvertRes.setRectifyCtr(rectifyCtr);
        ndAdvertRes.setRectifyCvr(rectifyCvr);
        return ndAdvertRes;
    }

    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;
        NdAdvertResultDo ndAdvertResult;

        RectifyNdAdvertResInfo() {
        }
    }

    static class Constance {
        static int CLICK_CONFIDENCE_THRESHOLD = 5000;
        static int SEP_STAGE_THRESHOLD = 300;
        static int COLD_START_THRESHOLD1 = 50;
        static int COLD_START_THRESHOLD2 = 100;
        static int COLD_START_THRESHOLD3 = 150;
        static int APP_CONVERT_THRESHOLD = 50;
        static double APP_CVR_THRESHOLD = 0.03;
        static double APP_CONSUME_THRESHOLD = 500.0;
        static int EXPOSE_CONFIDENCE_THRESHOLD = 20000;
        static double EXPLORE_CONSUME_PERCENT_THRESHOLD = 0.1;
        static int EXPOSE_CONFIDENCE_THRESHOLD2 = 500;

        Constance() {
        }
    }
}

