/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.coldstartandexplore.util;

import cn.com.duiba.nezha.alg.alg.coldstartandexplore.util.WeightingFunction;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCvr {
    private static final Logger logger = LoggerFactory.getLogger(GetCvr.class);

    public static Double getMinDimsStatCvr(STEParams steParams, List<Long> clickList, List<Double> cvrList, String paramType) {
        Double minDimsStatCvr = 0.0;
        if (clickList.get(clickList.size() - 1) <= (long)(paramType.equals("secondSet") ? steParams.getClickConfidenceThresholdSet2() : steParams.getClickConfidenceThreshold()).intValue()) {
            minDimsStatCvr = cvrList.get(clickList.size() - 1);
        } else {
            for (int index = 0; index < clickList.size(); ++index) {
                if (clickList.get(index) < (long)(paramType.equals("secondSet") ? steParams.getClickConfidenceThresholdSet2() : steParams.getClickConfidenceThreshold()).intValue()) continue;
                minDimsStatCvr = cvrList.get(index);
                break;
            }
        }
        return minDimsStatCvr;
    }

    public static Map<String, Object> getAdjustCVR(STEParams steParams, STEInfoDo steInfo) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{steParams, steInfo})) {
            return null;
        }
        Double preCvr = steInfo.getPreCvr();
        Long hisClick = steInfo.getHisClick();
        Long hisConvert = steInfo.getHisConvert();
        Double staCvr = Optional.ofNullable(MathUtil.division((Long)hisConvert, (Long)hisClick, (int)6)).orElse(0.0);
        Long advTradeSlotDayClick = steInfo.getAdvTradeSlotDayStats().getClick();
        Long advTradeAppDayClick = steInfo.getAdvTradeAppDayStats().getClick();
        Long advTradeAppTradeDayClick = steInfo.getAdvTradeAppTradeDayStats().getClick();
        Long advTradeSlotTriDayClick = steInfo.getAdvTradeSlotTriDayStats().getClick();
        Long advTradeAppTriDayClick = steInfo.getAdvTradeAppTriDayStats().getClick();
        Long advTradeAppTradeTriDayClick = steInfo.getAdvTradeAppTradeTriDayStats().getClick();
        Long advTradeSlotDayConvert = steInfo.getAdvTradeSlotDayStats().getConvert();
        Long advTradeAppDayConvert = steInfo.getAdvTradeAppDayStats().getConvert();
        Long advTradeAppTradeDayConvert = steInfo.getAdvTradeAppTradeDayStats().getConvert();
        Long advTradeSlotTriDayConvert = steInfo.getAdvTradeSlotTriDayStats().getConvert();
        Long advTradeAppTriDayConvert = steInfo.getAdvTradeAppTriDayStats().getConvert();
        Long advTradeAppTradeTriDayConvert = steInfo.getAdvTradeAppTradeTriDayStats().getConvert();
        Double advTradeSlotDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeSlotDayConvert, (Long)advTradeSlotDayClick, (int)6)).orElse(0.0);
        Double advTradeAppDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppDayConvert, (Long)advTradeAppDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTradeDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTradeDayConvert, (Long)advTradeAppTradeDayClick, (int)6)).orElse(0.0);
        Double advTradeSlotTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeSlotTriDayConvert, (Long)advTradeSlotTriDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTriDayConvert, (Long)advTradeAppTriDayClick, (int)6)).orElse(0.0);
        Double advTradeAppTradeTriDayCvr = Optional.ofNullable(MathUtil.division((Long)advTradeAppTradeTriDayConvert, (Long)advTradeAppTradeTriDayClick, (int)6)).orElse(0.0);
        List<Long> clickList = Arrays.asList(advTradeSlotDayClick, advTradeAppDayClick, advTradeAppTradeDayClick, advTradeSlotTriDayClick, advTradeAppTriDayClick, advTradeAppTradeTriDayClick);
        List<Double> cvrList = Arrays.asList(advTradeSlotDayCvr, advTradeAppDayCvr, advTradeAppTradeDayCvr, advTradeSlotTriDayCvr, advTradeAppTriDayCvr, advTradeAppTradeTriDayCvr);
        double adjustWeight = 1.0;
        String paramType = "firstSet";
        paramType = Collections.max(cvrList) < steParams.getMinDimStatsCvrThreshold() ? "secondSet" : "firstSet";
        HashMap<String, Object> AdjustWeightRes = WeightingFunction.getAdjustWeight(steParams, clickList, cvrList, paramType, hisClick, staCvr);
        adjustWeight = (Double)AdjustWeightRes.get("adjustWeight");
        double minDimsStatCvr = (Double)AdjustWeightRes.get("minDimsStatCvr");
        double adjustCvr = preCvr;
        adjustCvr = hisClick >= (long)(paramType.equals("firstSet") ? steParams.getSepStageThreshold() : steParams.getSepStageThresholdSet2()).intValue() && staCvr >= Math.pow(10.0, -8.0) ? adjustWeight * preCvr + (1.0 - adjustWeight) * minDimsStatCvr : (adjustCvr *= adjustWeight);
        res.put("adjustWeight", adjustWeight);
        res.put("adjustCvr", adjustCvr);
        res.put("paramType", paramType.equals("firstSet") ? 1.0 : 2.0);
        return res;
    }
}

