package cn.com.duiba.nezha.alg.alg.vo.adx.directly.meituan;

import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.Data;

@Data
public class AdxBaseStatDo {
    /**
     * 竞价请求次数
     */
    private long reqCnt;

    /**
     * 竞价返回次数
     */
    private long bidCnt;

    /**
     * 曝光次数
     */
    private long impCnt;

    /**
     * 点击次数
     */
    private long clickCnt;

    /**
     * 媒体消耗
     */
    private long adxFee;

    /**
     * 广告消耗
     */
    private long adFee;


    /**
     * 计算分成比例
     * @param adxBaseStatDo
     * @return
     */
    public static Double getShareRate(AdxBaseStatDo adxBaseStatDo) {
        Double ret = 1.;

        if(adxBaseStatDo != null) {
            if(adxBaseStatDo.adFee > 1000) {
                ret = DataUtil.division(adxBaseStatDo.adxFee, adxBaseStatDo.adFee, 3);
            }
        }
        return ret;
    }

    /**
     * 计算竞价成功率
     */
    public static Double getSucRate(AdxBaseStatDo adxBaseStatDo) {
        Double ret = null;
        if(adxBaseStatDo != null) {
            if(adxBaseStatDo.bidCnt > 1000) {
                ret = DataUtil.division(adxBaseStatDo.impCnt, adxBaseStatDo.bidCnt, 3);
            }
        }
        return ret;
    }

    /**
     * 计算平均点击价格
     */
    public static Double getAvgPrice(AdxBaseStatDo adxBaseStatDo) {
        Double ret = null;
        if(adxBaseStatDo != null) {
            if(adxBaseStatDo.clickCnt > 50) {
                ret = DataUtil.division(adxBaseStatDo.adxFee, adxBaseStatDo.clickCnt, 3);
            }
        }
        return ret;
    }

    /**
     * 平均点击价格融合
     */
    public static Double getMergePrice(AdxBaseStatDo adxBaseStatDo1, AdxBaseStatDo adxBaseStatDo2) {
        Double ret = null;

        //实时点击价格
        Double avgPriceMins =  AdxBaseStatDo.getAvgPrice(adxBaseStatDo1);

        //过去三日同时段点击价格
        Double avgPriceDay =  AdxBaseStatDo.getAvgPrice(adxBaseStatDo2);

        if(adxBaseStatDo1 == null) {
           return avgPriceDay;
        }else if(adxBaseStatDo2 == null) {
            return avgPriceMins;
        }

        Double weigh = DataUtil.division(adxBaseStatDo2.clickCnt, adxBaseStatDo2.clickCnt + adxBaseStatDo1.clickCnt, 3);


        if(avgPriceMins == null || weigh == null || avgPriceDay == null) {return avgPriceDay;}

        weigh = MathUtil.stdwithBoundary(weigh,0.2,0.8);

        ret = weigh * avgPriceDay + (1 - weigh) * avgPriceMins;

        return ret;
    }


}
