package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlFactors;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.DeepControlParams;
import cn.com.duiba.nezha.alg.alg.vo.ocpxControl.OcpxControlParams;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import lombok.extern.slf4j.Slf4j;


@Slf4j
public class DeepBidStrategy {

    static Double targetCost = 1.0; // 预估因子瞄准目标

    //普通情况下的计算双出价因子方法，其中的各个数字为离线取数所得或人工设置
    public static DeepControlFactors calculateNormal(Long deepFee, Long aFee, Double preDcvr, Double confWeight,
                                                     Double preMergeWeight,
                                                     Double statFactor, Double preMergeDiffU, Double preMergeDiffL) {


        DeepControlFactors retDto = new DeepControlFactors();
        //默认取统计因子
        Double ret = statFactor;
        Double preFactor = targetCost * deepFee * preDcvr / aFee;
        //对preDcvr严格为0.0的部分证明预估出问题了，单独处理
        if (preDcvr < 0.00000001) {
            preMergeWeight = 0.0;
        }

        preFactor = MathUtil.stdwithBoundary(preFactor, 0.1, 1.8);
        Double conFactor = (confWeight * preMergeWeight) * preFactor + (1 - confWeight * preMergeWeight) * statFactor;
        ret = MathUtil.formatDouble(MathUtil.stdwithBoundary(conFactor, preMergeDiffL * statFactor, preMergeDiffU * statFactor),
                5);
        preFactor = MathUtil.formatDouble(preFactor, 5);
        retDto.setDeepFactor(ret);
        retDto.setPreDeepFactor(preFactor);
        retDto.setStatDeepFactor(statFactor);
        return retDto;

    }

    /**
     * 获取深度调价因子 流量调价
     *
     * @param params
     * @return
     */
    public static DeepControlFactors getDeepFactor(OcpxControlParams costParams, DeepControlParams params,
                                                   AdBidParamsDo adBidParamsDo) {
        //取计算所需属性
        Integer appLimitReleaseMark = adBidParamsDo.getAppLimitReleaseMark();
        Long deepFee = adBidParamsDo.getDeepFee();
        Long aFee = adBidParamsDo.getAFee();
        Long appAFee = adBidParamsDo.getAppAFee();
        Long usefulAfee = aFee;
        if (appAFee != null && appAFee > 0) {
            usefulAfee = appAFee;
        }
        Double preDcvr = adBidParamsDo.getPreDcvr();

        DeepControlFactors retDto = new DeepControlFactors();
        Double ret = null;

        if (params == null || params.getDeepFactor() == null) {
            return retDto;
        }

        ret = params.getDeepFactor();
        Double statFactor = params.getDeepFactor();

        ////限流释放媒体-深度目标调价因子
        if (appLimitReleaseMark != null && appLimitReleaseMark.equals(1) && params.getLimitDeepFactor() != null) {
            ret = params.getLimitDeepFactor();
            statFactor = params.getLimitDeepFactor();
        }

        //默认取统计的因子
        retDto.setDeepFactor(ret);
        retDto.setStatDeepFactor(statFactor);

        Long controlType = params.getControlType();
        Double confWeight = params.getConfWeight();

        Double preMergeWeight = params.getPreMergeWeight();

        Double preMergeDiffU = params.getPreMergeDiffU();
        Double preMergeDiffL = params.getPreMergeDiffL();

        if (AssertUtil.isAllNotEmpty(confWeight, controlType, preDcvr, deepFee, usefulAfee, preMergeWeight, preMergeDiffU,
                preMergeDiffL, statFactor)) {
            retDto = DeepBidStrategy.calculateNormal(deepFee, usefulAfee, preDcvr, confWeight, preMergeWeight, statFactor,
                    preMergeDiffU, preMergeDiffL);
        }

        return retDto;
    }

    public static Boolean dcvrConstrain(DeepControlParams params, AdBidParamsDo adBidParamsDo) {
        Boolean result = false;
//        Integer dcvrConstraint = params.getDcvrConstraint();
//        Double dcvrLowerBound = params.getDcvrLowerBound();
//        Integer dcvrConstraintABId = adBidParamsDo.getDcvrConstraintABId();
//        Double preDcvr = adBidParamsDo.getPreDcvr();
//        if (AssertUtil.isAllNotEmpty(dcvrConstraint, dcvrConstraintABId, preDcvr, dcvrLowerBound)) {
//            if (dcvrConstraint == 1 && dcvrConstraintABId == 2 && preDcvr < dcvrLowerBound) {
//                result = true;
//            }
//        }
        return result;
    }

    public static void main(String[] args) {
        Boolean a = null;
        System.out.println(a == true);
    }
}
