package cn.com.duiba.nezha.alg.alg.material;

import cn.com.duiba.nezha.alg.alg.vo.material.MaterialDataParams1;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialIDselectDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialIDselectReturnDo;
import cn.com.duiba.nezha.alg.alg.vo.material.MaterialSelectModel;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class MaterialSelect {   //新增两个素材优选的策略；更新版本


    /**
     * 素材优选策略1
     * <p>
     * 离线+实时，统计 最优素材
     * <p>
     * 最优素材维度：计划、配置、计划+媒体、配置+媒体
     *
     * @param currentMaterialIds  配置维度，可投放素材集合，不为空
     * @param materialSelectModel 计划维度，素材推荐控制参数,redis 存储对象
     * @return MaterialIDselectReturnDo 返回结果写进对象里面
     */
    public static MaterialIDselectReturnDo materialSelect(Long orientationId, Long appId, List<Long> currentMaterialIds, MaterialSelectModel materialSelectModel) {

        MaterialIDselectReturnDo ret = new MaterialIDselectReturnDo();//推荐结果返回给nezhe的对象

        /**
         * 情况0  可投放素材对象为null，返回null
         */
        if (currentMaterialIds == null) {
            return null;
        }

        /**
         * 情况1 最优素材控制参数为null，随机推荐
         */
        if (materialSelectModel == null) {
            return materialSelectRandom(currentMaterialIds, "5");
        }


        Long bestMaterial = materialSelectModel.getBestMaterial(orientationId, appId);

        /**
         * 情况2 最优素材推荐为null，随机推荐
         */
        if (bestMaterial == null) {
            return materialSelectRandom(currentMaterialIds, "6");
        }


        /**
         * 情况3 最优素材 不在可投放列表，随机推荐
         */

        if (!currentMaterialIds.contains(bestMaterial)) {
            return materialSelectRandom(currentMaterialIds, "2");
        }


        /**
         *  情况41 随机推荐 ，比例默认15%
         */

        Double randomWeight = materialSelectModel.getRandomWeight();

        if (randomWeight == null) {
            randomWeight = 0.15;
        }

        Random rand = new Random();
        double randValue = rand.nextDouble();

        if (randValue <= randomWeight) {
            return materialSelectRandom(currentMaterialIds, "0");
        }


        /**
         * 情况41 最优素材 ，比例默认85%
         */
        ret.setStrategyOneRecmaterialId(bestMaterial);//写进对象里面
        ret.setRandom1("1");

        return ret;

    }


    /**
     * 随机推荐
     *
     * @param currentMaterialIds
     * @param materialFlag
     * @return
     */
    public static MaterialIDselectReturnDo materialSelectRandom(List<Long> currentMaterialIds, String materialFlag) {

        MaterialIDselectReturnDo ret = new MaterialIDselectReturnDo();//推荐结果返回给nezhe的对象
        Random random = new Random();
        int n = random.nextInt(currentMaterialIds.size());
        Long materialId = currentMaterialIds.get(n);
        ret.setStrategyOneRecmaterialId(materialId);//写进对象里面
        ret.setRandom1(materialFlag);
        return ret;
    }


}