package cn.com.duiba.nezha.alg.alg.vo.material;

import lombok.Data;

import java.util.*;


/**
 *
 */
@Data
public class MaterialSelectModel {

    public Long advertId;

    public double randomWeight = 0.15;//策略1的随机比例

    public String updateTime;
    public Set<Long> pkgSet = new HashSet<>();//配置列表


    /**
     * 数据
     */
    public Map<String, Long> bestMaterialIdMap = new HashMap<>(); //最优素材集合


    public Long getBestMaterial(Long pkgId, Long appId) {
        Long ret = null;

        //1 计划下最优素材
        Long adBestMaterialId = getBestMaterialWithInfo(null, null);

        //2 计划维度，最优素材，分媒体
        Long adBestMaterialIdOnApp = getBestMaterialWithInfo(null, appId);

        //3 计划维度，最优素材
        Long pkgBestMaterialId = getBestMaterialWithInfo(pkgId, null);

        //4 素材维度，最优素材，分媒体
        Long pkgBestMaterialIdOnApp = getBestMaterialWithInfo(pkgId, appId);

        /**
         * 优先级
         */

        if (pkgBestMaterialIdOnApp != null) {
            return pkgBestMaterialIdOnApp;
        }

        if (pkgBestMaterialId != null) {
            return pkgBestMaterialId;
        }

        if (adBestMaterialIdOnApp != null) {
            return adBestMaterialIdOnApp;
        }

        if (adBestMaterialId != null) {
            return adBestMaterialId;
        }


        return ret;
    }

    public String getKey(Long pkgId, Long appId) {

        return advertId + "_" + pkgId + "_" + appId;
    }

    public Long getBestMaterialWithInfo(Long pkgId, Long appId) {

        String key = getKey(pkgId, appId);

        return bestMaterialIdMap.get(key);
    }
}