/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.vo.adx.directly2;

import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxExpFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.directly2.AdxExpStatDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;

public class ExploreFactor {
    Map<Long, AdxExpFactorDo> resFactor = new HashMap<Long, AdxExpFactorDo>();
    Map<Long, AdxExpStatDo> ideaStatDo = new HashMap<Long, AdxExpStatDo>();

    public static AdxExpFactorDo getEFactor(ExploreFactor exploreFactor, Long resId) {
        AdxExpFactorDo ret = new AdxExpFactorDo();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{exploreFactor, resId})) {
            return ret;
        }
        if (exploreFactor != null && exploreFactor.getResFactor() != null) {
            ret = exploreFactor.getResFactor().getOrDefault(resId, ret);
        }
        return ret;
    }

    public static AdxExpStatDo getIdeaStat(ExploreFactor exploreFactor, Long ideaId) {
        AdxExpStatDo ret = new AdxExpStatDo();
        if (AssertUtil.isAnyEmpty((Object[])new Object[]{exploreFactor, ideaId})) {
            return ret;
        }
        if (exploreFactor.getIdeaStatDo() != null) {
            ret = exploreFactor.getIdeaStatDo().getOrDefault(ideaId, ret);
        }
        return ret;
    }

    public static Double getEFactor(ExploreFactor exploreFactor, Long resId, String appId) {
        Double ret = null;
        AdxExpFactorDo adxExpFactorDo = ExploreFactor.getEFactor(exploreFactor, resId);
        ret = adxExpFactorDo.getResFactor();
        if (AdxExpFactorDo.getAppFactor(adxExpFactorDo, appId) != null) {
            ret = AdxExpFactorDo.getAppFactor(adxExpFactorDo, appId);
        }
        return ret;
    }

    public static Double getIdeaStat(ExploreFactor exploreFactor, Long ideaId, String appId) {
        Double ret = null;
        AdxExpStatDo adxExpStatDo = ExploreFactor.getIdeaStat(exploreFactor, ideaId);
        ret = adxExpStatDo.getIdeaEcpm();
        if (AdxExpStatDo.getAppEcpm(adxExpStatDo, appId) != null) {
            ret = AdxExpStatDo.getAppEcpm(adxExpStatDo, appId);
        }
        return ret;
    }

    public void putResFactor(Long resId, AdxExpFactorDo adxExpFactorDo) {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{resId, adxExpFactorDo})) {
            this.resFactor.put(resId, adxExpFactorDo);
        }
    }

    public void putIdeaStatDo(Long ideaId, AdxExpStatDo adxExpStatDo) {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ideaId, adxExpStatDo})) {
            this.ideaStatDo.put(ideaId, adxExpStatDo);
        }
    }

    public Map<Long, AdxExpFactorDo> getResFactor() {
        return this.resFactor;
    }

    public Map<Long, AdxExpStatDo> getIdeaStatDo() {
        return this.ideaStatDo;
    }

    public void setResFactor(Map<Long, AdxExpFactorDo> resFactor) {
        this.resFactor = resFactor;
    }

    public void setIdeaStatDo(Map<Long, AdxExpStatDo> ideaStatDo) {
        this.ideaStatDo = ideaStatDo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExploreFactor)) {
            return false;
        }
        ExploreFactor other = (ExploreFactor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Long, AdxExpFactorDo> this$resFactor = this.getResFactor();
        Map<Long, AdxExpFactorDo> other$resFactor = other.getResFactor();
        if (this$resFactor == null ? other$resFactor != null : !((Object)this$resFactor).equals(other$resFactor)) {
            return false;
        }
        Map<Long, AdxExpStatDo> this$ideaStatDo = this.getIdeaStatDo();
        Map<Long, AdxExpStatDo> other$ideaStatDo = other.getIdeaStatDo();
        return !(this$ideaStatDo == null ? other$ideaStatDo != null : !((Object)this$ideaStatDo).equals(other$ideaStatDo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExploreFactor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Long, AdxExpFactorDo> $resFactor = this.getResFactor();
        result = result * 59 + ($resFactor == null ? 43 : ((Object)$resFactor).hashCode());
        Map<Long, AdxExpStatDo> $ideaStatDo = this.getIdeaStatDo();
        result = result * 59 + ($ideaStatDo == null ? 43 : ((Object)$ideaStatDo).hashCode());
        return result;
    }

    public String toString() {
        return "ExploreFactor(resFactor=" + this.getResFactor() + ", ideaStatDo=" + this.getIdeaStatDo() + ")";
    }
}

