/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx.rcmd2;

import cn.com.duiba.nezha.alg.api.model.AdxLocalTFModel;
import cn.com.duiba.nezha.alg.api.model.E2ELocalTFModel;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model {
    private static final Logger logger = LoggerFactory.getLogger(Model.class);
    private IModel ctrModel;
    private IModel launchPvCoder;
    private IModel ARPUCoder;
    private LocalTFModel launchPvTFModel;
    private LocalTFModel arpuTFModel;
    private AdxLocalTFModel esmmTFModel;
    private IModel clickPvCoder;
    private IModel adCpcCoder;
    private LocalTFModelV2 clickPvTFModel;
    private LocalTFModelV2 adCpcTFModel;
    private IModel launchPvCoderV2;
    private LocalTFModelV2 launchPvTFModelV2;
    private IModel ARPUCoderV2;
    private LocalTFModelV2 arpuTFModelV2;
    private E2ELocalTFModel userScoreModel;
    private IModel userScoreCoderV2;
    private LocalTFModelV2 userScoreTFModelV2;
    private IModel adCpcCoderV2;
    private LocalTFModelV2 adCpcTFModelV2;

    public <T> Map<T, Double> predictCtr(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ctrModel.predictsNew(featureMap);
            return ret;
        }
        catch (Exception e) {
            logger.error("Model.predictCtr error{} ctrModel{}", (Object)e, (Object)this.ctrModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictLaunchPv(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.launchPvCoder.predictWithLocalTFNew(featureMap, this.launchPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv error{}, launchPvCoder{}, launchPvTFModel{}", new Object[]{e, this.launchPvCoder, this.launchPvTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictLaunchPvV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.launchPvCoderV2.predictWithLocalTFV2(featureMap, this.launchPvTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictLaunchPv error{}, launchPvCoder{}, launchPvTFModel{}", new Object[]{e, this.launchPvCoderV2, this.launchPvTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictARPU(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ARPUCoder.predictWithLocalTFNew(featureMap, this.arpuTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU error{}, ARPUCoder{}, arpuTFModel{}", new Object[]{e, this.ARPUCoder, this.arpuTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictARPUV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.ARPUCoderV2.predictWithLocalTFV2(featureMap, this.arpuTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictARPU error{}, ARPUCoder{}, arpuTFModel{}", new Object[]{e, this.ARPUCoderV2, this.arpuTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictClickPv(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.clickPvCoder.predictWithLocalTFV2(featureMap, this.clickPvTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictClickPv error{}, clickPvCoder{}, clickPvTFModel{}", new Object[]{e, this.clickPvCoder, this.clickPvTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictAdCpc(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.adCpcCoder.predictWithLocalTFV2(featureMap, this.adCpcTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictAdCpc error{}, adCpcCoder{}, adCpcTFModel{}", new Object[]{e, this.adCpcCoder, this.adCpcTFModel});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCtr2(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap ret = new HashMap();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (Object key : modelOutput.keySet()) {
                Float ctr = ((Float[])((Map)modelOutput.get(key)).get("ctr"))[0];
                Double roundCtr = new BigDecimal(ctr.toString()).setScale(5, 4).doubleValue();
                ret.put(key, roundCtr);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCtr2 error{}, TFModel{}", (Object)e, (Object)this.esmmTFModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictCvr(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap ret = new HashMap();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (Object key : modelOutput.keySet()) {
                BigDecimal ctcvr = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctcvr"))[0].toString());
                BigDecimal ctr = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctr"))[0].toString());
                Double cvr = ctcvr.divide(ctr, 5, 4).doubleValue();
                ret.put(key, cvr);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictCVR error TFModel{}", (Object)this.esmmTFModel, (Object)e);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Map<String, Double>> predictCtrCvr(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap ret = new HashMap();
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map modelOutput = this.esmmTFModel.predict(modelInput);
            for (Object key : modelOutput.keySet()) {
                BigDecimal ctcvrBD = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctcvr"))[0].toString());
                BigDecimal ctrBD = new BigDecimal(((Float[])((Map)modelOutput.get(key)).get("ctr"))[0].toString());
                Double cvr = Objects.equals(ctrBD.doubleValue(), 0.0) ? 0.0 : ctcvrBD.divide(ctrBD, 5, RoundingMode.HALF_UP).doubleValue();
                HashMap<String, Double> perSampleMap = new HashMap<String, Double>(5);
                perSampleMap.put("ctr", ctrBD.setScale(5, RoundingMode.HALF_UP).doubleValue());
                perSampleMap.put("cvr", cvr);
                ret.put(key, perSampleMap);
            }
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictESMM error TFModel {}", (Object)this.esmmTFModel, (Object)e);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictUserScore(Map<T, FeatureMapDo> featureMap) {
        try {
            HashMap<T, Map> modelInput = new HashMap<T, Map>();
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                modelInput.put(entry.getKey(), entry.getValue().getFeatureMap());
            }
            Map ret = this.userScoreModel.predict(modelInput);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictUserScore error{}, userScoreModel{}", (Object)e, (Object)this.userScoreModel);
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictUserScoreV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.userScoreCoderV2.predictWithLocalTFV2(featureMap, this.userScoreTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictUserScoreV2 error{}, userScoreCoderV2{}, userScoreTFModelV2{}", new Object[]{e, this.userScoreCoderV2, this.userScoreTFModelV2});
            return Collections.emptyMap();
        }
    }

    public <T> Map<T, Double> predictAdCpcV2(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map ret = this.adCpcCoderV2.predictWithLocalTFV2(featureMap, this.adCpcTFModelV2);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictAdCpcV2 error{}, adCpcCoderV2{}, adCpcTFModelV2{}", new Object[]{e, this.adCpcCoderV2, this.adCpcTFModelV2});
            return Collections.emptyMap();
        }
    }

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public IModel getLaunchPvCoder() {
        return this.launchPvCoder;
    }

    public IModel getARPUCoder() {
        return this.ARPUCoder;
    }

    public LocalTFModel getLaunchPvTFModel() {
        return this.launchPvTFModel;
    }

    public LocalTFModel getArpuTFModel() {
        return this.arpuTFModel;
    }

    public AdxLocalTFModel getEsmmTFModel() {
        return this.esmmTFModel;
    }

    public IModel getClickPvCoder() {
        return this.clickPvCoder;
    }

    public IModel getAdCpcCoder() {
        return this.adCpcCoder;
    }

    public LocalTFModelV2 getClickPvTFModel() {
        return this.clickPvTFModel;
    }

    public LocalTFModelV2 getAdCpcTFModel() {
        return this.adCpcTFModel;
    }

    public IModel getLaunchPvCoderV2() {
        return this.launchPvCoderV2;
    }

    public LocalTFModelV2 getLaunchPvTFModelV2() {
        return this.launchPvTFModelV2;
    }

    public IModel getARPUCoderV2() {
        return this.ARPUCoderV2;
    }

    public LocalTFModelV2 getArpuTFModelV2() {
        return this.arpuTFModelV2;
    }

    public E2ELocalTFModel getUserScoreModel() {
        return this.userScoreModel;
    }

    public IModel getUserScoreCoderV2() {
        return this.userScoreCoderV2;
    }

    public LocalTFModelV2 getUserScoreTFModelV2() {
        return this.userScoreTFModelV2;
    }

    public IModel getAdCpcCoderV2() {
        return this.adCpcCoderV2;
    }

    public LocalTFModelV2 getAdCpcTFModelV2() {
        return this.adCpcTFModelV2;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public void setLaunchPvCoder(IModel launchPvCoder) {
        this.launchPvCoder = launchPvCoder;
    }

    public void setARPUCoder(IModel ARPUCoder) {
        this.ARPUCoder = ARPUCoder;
    }

    public void setLaunchPvTFModel(LocalTFModel launchPvTFModel) {
        this.launchPvTFModel = launchPvTFModel;
    }

    public void setArpuTFModel(LocalTFModel arpuTFModel) {
        this.arpuTFModel = arpuTFModel;
    }

    public void setEsmmTFModel(AdxLocalTFModel esmmTFModel) {
        this.esmmTFModel = esmmTFModel;
    }

    public void setClickPvCoder(IModel clickPvCoder) {
        this.clickPvCoder = clickPvCoder;
    }

    public void setAdCpcCoder(IModel adCpcCoder) {
        this.adCpcCoder = adCpcCoder;
    }

    public void setClickPvTFModel(LocalTFModelV2 clickPvTFModel) {
        this.clickPvTFModel = clickPvTFModel;
    }

    public void setAdCpcTFModel(LocalTFModelV2 adCpcTFModel) {
        this.adCpcTFModel = adCpcTFModel;
    }

    public void setLaunchPvCoderV2(IModel launchPvCoderV2) {
        this.launchPvCoderV2 = launchPvCoderV2;
    }

    public void setLaunchPvTFModelV2(LocalTFModelV2 launchPvTFModelV2) {
        this.launchPvTFModelV2 = launchPvTFModelV2;
    }

    public void setARPUCoderV2(IModel ARPUCoderV2) {
        this.ARPUCoderV2 = ARPUCoderV2;
    }

    public void setArpuTFModelV2(LocalTFModelV2 arpuTFModelV2) {
        this.arpuTFModelV2 = arpuTFModelV2;
    }

    public void setUserScoreModel(E2ELocalTFModel userScoreModel) {
        this.userScoreModel = userScoreModel;
    }

    public void setUserScoreCoderV2(IModel userScoreCoderV2) {
        this.userScoreCoderV2 = userScoreCoderV2;
    }

    public void setUserScoreTFModelV2(LocalTFModelV2 userScoreTFModelV2) {
        this.userScoreTFModelV2 = userScoreTFModelV2;
    }

    public void setAdCpcCoderV2(IModel adCpcCoderV2) {
        this.adCpcCoderV2 = adCpcCoderV2;
    }

    public void setAdCpcTFModelV2(LocalTFModelV2 adCpcTFModelV2) {
        this.adCpcTFModelV2 = adCpcTFModelV2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IModel this$ctrModel = this.getCtrModel();
        IModel other$ctrModel = other.getCtrModel();
        if (this$ctrModel == null ? other$ctrModel != null : !this$ctrModel.equals(other$ctrModel)) {
            return false;
        }
        IModel this$launchPvCoder = this.getLaunchPvCoder();
        IModel other$launchPvCoder = other.getLaunchPvCoder();
        if (this$launchPvCoder == null ? other$launchPvCoder != null : !this$launchPvCoder.equals(other$launchPvCoder)) {
            return false;
        }
        IModel this$ARPUCoder = this.getARPUCoder();
        IModel other$ARPUCoder = other.getARPUCoder();
        if (this$ARPUCoder == null ? other$ARPUCoder != null : !this$ARPUCoder.equals(other$ARPUCoder)) {
            return false;
        }
        LocalTFModel this$launchPvTFModel = this.getLaunchPvTFModel();
        LocalTFModel other$launchPvTFModel = other.getLaunchPvTFModel();
        if (this$launchPvTFModel == null ? other$launchPvTFModel != null : !this$launchPvTFModel.equals(other$launchPvTFModel)) {
            return false;
        }
        LocalTFModel this$arpuTFModel = this.getArpuTFModel();
        LocalTFModel other$arpuTFModel = other.getArpuTFModel();
        if (this$arpuTFModel == null ? other$arpuTFModel != null : !this$arpuTFModel.equals(other$arpuTFModel)) {
            return false;
        }
        AdxLocalTFModel this$esmmTFModel = this.getEsmmTFModel();
        AdxLocalTFModel other$esmmTFModel = other.getEsmmTFModel();
        if (this$esmmTFModel == null ? other$esmmTFModel != null : !this$esmmTFModel.equals(other$esmmTFModel)) {
            return false;
        }
        IModel this$clickPvCoder = this.getClickPvCoder();
        IModel other$clickPvCoder = other.getClickPvCoder();
        if (this$clickPvCoder == null ? other$clickPvCoder != null : !this$clickPvCoder.equals(other$clickPvCoder)) {
            return false;
        }
        IModel this$adCpcCoder = this.getAdCpcCoder();
        IModel other$adCpcCoder = other.getAdCpcCoder();
        if (this$adCpcCoder == null ? other$adCpcCoder != null : !this$adCpcCoder.equals(other$adCpcCoder)) {
            return false;
        }
        LocalTFModelV2 this$clickPvTFModel = this.getClickPvTFModel();
        LocalTFModelV2 other$clickPvTFModel = other.getClickPvTFModel();
        if (this$clickPvTFModel == null ? other$clickPvTFModel != null : !this$clickPvTFModel.equals(other$clickPvTFModel)) {
            return false;
        }
        LocalTFModelV2 this$adCpcTFModel = this.getAdCpcTFModel();
        LocalTFModelV2 other$adCpcTFModel = other.getAdCpcTFModel();
        if (this$adCpcTFModel == null ? other$adCpcTFModel != null : !this$adCpcTFModel.equals(other$adCpcTFModel)) {
            return false;
        }
        IModel this$launchPvCoderV2 = this.getLaunchPvCoderV2();
        IModel other$launchPvCoderV2 = other.getLaunchPvCoderV2();
        if (this$launchPvCoderV2 == null ? other$launchPvCoderV2 != null : !this$launchPvCoderV2.equals(other$launchPvCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$launchPvTFModelV2 = this.getLaunchPvTFModelV2();
        LocalTFModelV2 other$launchPvTFModelV2 = other.getLaunchPvTFModelV2();
        if (this$launchPvTFModelV2 == null ? other$launchPvTFModelV2 != null : !this$launchPvTFModelV2.equals(other$launchPvTFModelV2)) {
            return false;
        }
        IModel this$ARPUCoderV2 = this.getARPUCoderV2();
        IModel other$ARPUCoderV2 = other.getARPUCoderV2();
        if (this$ARPUCoderV2 == null ? other$ARPUCoderV2 != null : !this$ARPUCoderV2.equals(other$ARPUCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$arpuTFModelV2 = this.getArpuTFModelV2();
        LocalTFModelV2 other$arpuTFModelV2 = other.getArpuTFModelV2();
        if (this$arpuTFModelV2 == null ? other$arpuTFModelV2 != null : !this$arpuTFModelV2.equals(other$arpuTFModelV2)) {
            return false;
        }
        E2ELocalTFModel this$userScoreModel = this.getUserScoreModel();
        E2ELocalTFModel other$userScoreModel = other.getUserScoreModel();
        if (this$userScoreModel == null ? other$userScoreModel != null : !this$userScoreModel.equals(other$userScoreModel)) {
            return false;
        }
        IModel this$userScoreCoderV2 = this.getUserScoreCoderV2();
        IModel other$userScoreCoderV2 = other.getUserScoreCoderV2();
        if (this$userScoreCoderV2 == null ? other$userScoreCoderV2 != null : !this$userScoreCoderV2.equals(other$userScoreCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$userScoreTFModelV2 = this.getUserScoreTFModelV2();
        LocalTFModelV2 other$userScoreTFModelV2 = other.getUserScoreTFModelV2();
        if (this$userScoreTFModelV2 == null ? other$userScoreTFModelV2 != null : !this$userScoreTFModelV2.equals(other$userScoreTFModelV2)) {
            return false;
        }
        IModel this$adCpcCoderV2 = this.getAdCpcCoderV2();
        IModel other$adCpcCoderV2 = other.getAdCpcCoderV2();
        if (this$adCpcCoderV2 == null ? other$adCpcCoderV2 != null : !this$adCpcCoderV2.equals(other$adCpcCoderV2)) {
            return false;
        }
        LocalTFModelV2 this$adCpcTFModelV2 = this.getAdCpcTFModelV2();
        LocalTFModelV2 other$adCpcTFModelV2 = other.getAdCpcTFModelV2();
        return !(this$adCpcTFModelV2 == null ? other$adCpcTFModelV2 != null : !this$adCpcTFModelV2.equals(other$adCpcTFModelV2));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Model;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IModel $ctrModel = this.getCtrModel();
        result = result * 59 + ($ctrModel == null ? 43 : $ctrModel.hashCode());
        IModel $launchPvCoder = this.getLaunchPvCoder();
        result = result * 59 + ($launchPvCoder == null ? 43 : $launchPvCoder.hashCode());
        IModel $ARPUCoder = this.getARPUCoder();
        result = result * 59 + ($ARPUCoder == null ? 43 : $ARPUCoder.hashCode());
        LocalTFModel $launchPvTFModel = this.getLaunchPvTFModel();
        result = result * 59 + ($launchPvTFModel == null ? 43 : $launchPvTFModel.hashCode());
        LocalTFModel $arpuTFModel = this.getArpuTFModel();
        result = result * 59 + ($arpuTFModel == null ? 43 : $arpuTFModel.hashCode());
        AdxLocalTFModel $esmmTFModel = this.getEsmmTFModel();
        result = result * 59 + ($esmmTFModel == null ? 43 : $esmmTFModel.hashCode());
        IModel $clickPvCoder = this.getClickPvCoder();
        result = result * 59 + ($clickPvCoder == null ? 43 : $clickPvCoder.hashCode());
        IModel $adCpcCoder = this.getAdCpcCoder();
        result = result * 59 + ($adCpcCoder == null ? 43 : $adCpcCoder.hashCode());
        LocalTFModelV2 $clickPvTFModel = this.getClickPvTFModel();
        result = result * 59 + ($clickPvTFModel == null ? 43 : $clickPvTFModel.hashCode());
        LocalTFModelV2 $adCpcTFModel = this.getAdCpcTFModel();
        result = result * 59 + ($adCpcTFModel == null ? 43 : $adCpcTFModel.hashCode());
        IModel $launchPvCoderV2 = this.getLaunchPvCoderV2();
        result = result * 59 + ($launchPvCoderV2 == null ? 43 : $launchPvCoderV2.hashCode());
        LocalTFModelV2 $launchPvTFModelV2 = this.getLaunchPvTFModelV2();
        result = result * 59 + ($launchPvTFModelV2 == null ? 43 : $launchPvTFModelV2.hashCode());
        IModel $ARPUCoderV2 = this.getARPUCoderV2();
        result = result * 59 + ($ARPUCoderV2 == null ? 43 : $ARPUCoderV2.hashCode());
        LocalTFModelV2 $arpuTFModelV2 = this.getArpuTFModelV2();
        result = result * 59 + ($arpuTFModelV2 == null ? 43 : $arpuTFModelV2.hashCode());
        E2ELocalTFModel $userScoreModel = this.getUserScoreModel();
        result = result * 59 + ($userScoreModel == null ? 43 : $userScoreModel.hashCode());
        IModel $userScoreCoderV2 = this.getUserScoreCoderV2();
        result = result * 59 + ($userScoreCoderV2 == null ? 43 : $userScoreCoderV2.hashCode());
        LocalTFModelV2 $userScoreTFModelV2 = this.getUserScoreTFModelV2();
        result = result * 59 + ($userScoreTFModelV2 == null ? 43 : $userScoreTFModelV2.hashCode());
        IModel $adCpcCoderV2 = this.getAdCpcCoderV2();
        result = result * 59 + ($adCpcCoderV2 == null ? 43 : $adCpcCoderV2.hashCode());
        LocalTFModelV2 $adCpcTFModelV2 = this.getAdCpcTFModelV2();
        result = result * 59 + ($adCpcTFModelV2 == null ? 43 : $adCpcTFModelV2.hashCode());
        return result;
    }

    public String toString() {
        return "Model(ctrModel=" + this.getCtrModel() + ", launchPvCoder=" + this.getLaunchPvCoder() + ", ARPUCoder=" + this.getARPUCoder() + ", launchPvTFModel=" + this.getLaunchPvTFModel() + ", arpuTFModel=" + this.getArpuTFModel() + ", esmmTFModel=" + this.getEsmmTFModel() + ", clickPvCoder=" + this.getClickPvCoder() + ", adCpcCoder=" + this.getAdCpcCoder() + ", clickPvTFModel=" + this.getClickPvTFModel() + ", adCpcTFModel=" + this.getAdCpcTFModel() + ", launchPvCoderV2=" + this.getLaunchPvCoderV2() + ", launchPvTFModelV2=" + this.getLaunchPvTFModelV2() + ", ARPUCoderV2=" + this.getARPUCoderV2() + ", arpuTFModelV2=" + this.getArpuTFModelV2() + ", userScoreModel=" + this.getUserScoreModel() + ", userScoreCoderV2=" + this.getUserScoreCoderV2() + ", userScoreTFModelV2=" + this.getUserScoreTFModelV2() + ", adCpcCoderV2=" + this.getAdCpcCoderV2() + ", adCpcTFModelV2=" + this.getAdCpcTFModelV2() + ")";
    }
}

