package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;

import java.util.List;
import java.util.Map;

/**
 * 活动推荐接口，工程系统推荐调用，只和该对象交互
 */
public class ActivityAlg {



    /**
     * 活动推荐接口
     *
     * @param activityRcmdReqList 活动列表
     * @param contextFeatureDoV2  上下文特征
     * @param userFeatureDoV2     用户特征
     * @param deepModelV2         编码器模型
     * @param localTFModelV2      TF预估模型
     * @param activityParams   算法控制参数,广告位
     * @return
     * @throws Exception
     */
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList,

                                       ContextFeatureDoV2 contextFeatureDoV2,
                                       UserFeatureDoV2 userFeatureDoV2,
                                       DeepModelV2 deepModelV2,
                                       LocalTFModelV2 localTFModelV2,


                                       ActivityParams activityParams) throws Exception {

        /**
         * 基础信息获取
         */

        Long slotId = contextFeatureDoV2.getSlotId();
        Integer abTestId = contextFeatureDoV2.getAbTestId();
        Integer rcmdType = contextFeatureDoV2.getRcmdTyoe();



        /**
         * 特征解析
         */
        Map<Long, FeatureMapDo> featureMapDoMap = ActivityRcmder.getFeatureMap(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2);

        /**
         * 模型预估
         */
        Map<Long, Double> preEcpmMap = ActivityRcmder.predict(featureMapDoMap, deepModelV2, localTFModelV2);


        /**
         * 推荐
         */
        ActivityRcmdRet ret = ActivityRcmder.rcmd(activityRcmdReqList, activityParams, preEcpmMap, slotId);


        ret.setAbTestId(abTestId);
        ret.setRcmdTyoe(rcmdType);

        ret.setFeatureMap(featureMapDoMap.get(ret.getActivityId()).getFeatureMap());

        return ret;
    }


}
