package cn.com.duiba.nezha.alg.alg.activity;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class ActivitySubParams {


    private double factor = 1.0;//调节因子


    private double statRatio = 0.0;//只是调节比例

    private Boolean isNew;//是否新活动

    private Double statEcpm;//统计ecpm

    private Double statEcpm2;//统计ecpm,理论消耗

    private Boolean isConfidence;//是否置信

    private String updateTime;//更新时间


    /**
     * 取实际ecpm和理论ecpm的最大值
     *
     * @return
     */
    public Double getEcpm() {
        if (statEcpm == null) {
            return statEcpm2;
        }

        if (statEcpm2 == null) {
            return statEcpm;
        }

        return Math.max(statEcpm, statEcpm2);
    }

}
