/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.alg.activity.ActivityParams;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdReq;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdRet;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmder;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActivityAlg {
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList, ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2, DeepModelV2 deepModelV2, LocalTFModelV2 localTFModelV2, ActivityParams activityParams) throws Exception {
        Long slotId = contextFeatureDoV2.getSlotId();
        String abTestId = contextFeatureDoV2.getAbTestId();
        Integer rcmdType = contextFeatureDoV2.getRcmdType();
        Map<Long, FeatureMapDo> featureMapDoMap = ActivityRcmder.getFeatureMap(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2);
        Map<Long, Double> preEcpmMap = ActivityRcmder.predict(featureMapDoMap, deepModelV2, localTFModelV2);
        ActivityRcmdRet ret = ActivityRcmder.rcmd(activityRcmdReqList, activityParams, preEcpmMap, slotId);
        if (ret != null) {
            ret.setAbTestId(abTestId);
            ret.setRcmdType(rcmdType);
            ret.setFeatureMap(featureMapDoMap.get(ret.getActivityId()).getFeatureMap());
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            ActivityAlg.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run() throws Exception {
        ArrayList<ActivityRcmdReq> activityRcmdReqList = new ArrayList<ActivityRcmdReq>();
        for (int i = 0; i < 50; ++i) {
            ActivityRcmdReq activityRcmdReq = new ActivityRcmdReq();
            activityRcmdReq.setActivityId(1001L);
        }
        UserFeatureDoV2 userFeatureDoV2 = new UserFeatureDoV2();
        ContextFeatureDoV2 contextFeatureDoV2 = new ContextFeatureDoV2();
        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long d1 = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            ActivityAlg.rcmd(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2, null, null, null);
        }
        long d2 = System.currentTimeMillis();
        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("\u8017\u65f6\uff1a" + (d2 - d1) + " ms");
    }
}

