/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.alg.activity.ActivityParams;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdReq;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdRet;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmder;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActivityAlg {
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList, ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2, DeepModelV2 deepModelV2, LocalTFModelV2 localTFModelV2, ActivityParams activityParams) throws Exception {
        Map<Long, FeatureMapDo> featureMapDoMap;
        Map<Long, Double> preEcpmMap;
        ActivityRcmdRet ret;
        if (contextFeatureDoV2 == null) {
            contextFeatureDoV2 = new ContextFeatureDoV2();
        }
        Long slotId = contextFeatureDoV2.getSlotId();
        String abTestId = contextFeatureDoV2.getAbTestId();
        Integer rcmdType = contextFeatureDoV2.getRcmdType();
        String appPkgTrade2 = contextFeatureDoV2.getUaAppPackageTrade2();
        Long algRcmdType = ActivityRcmder.getAlgRcmdType();
        List<ActivityRcmdReq> activityRcmdRecallList = activityRcmdReqList;
        if ("openRCMD".equals(abTestId)) {
            activityRcmdRecallList = ActivityRcmder.recall(activityRcmdReqList, appPkgTrade2, slotId, algRcmdType);
        }
        if ((ret = ActivityRcmder.rcmd(activityRcmdRecallList, activityParams, preEcpmMap = ActivityRcmder.predict(featureMapDoMap = ActivityRcmder.getFeatureMap(activityRcmdRecallList, contextFeatureDoV2, userFeatureDoV2), deepModelV2, localTFModelV2), slotId, appPkgTrade2, algRcmdType)) != null) {
            ret.setAbTestId(abTestId);
            ret.setRcmdType(rcmdType);
            ret.setFeatureMap(featureMapDoMap.get(ret.getActivityId()).getFeatureMap());
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            ActivityAlg.run2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void run2() throws Exception {
        ArrayList<ActivityRcmdReq> activityRcmdReqList = new ArrayList<ActivityRcmdReq>();
        ActivityRcmdReq activityRcmdReq0 = new ActivityRcmdReq();
        activityRcmdReq0.setActivityId(31184L);
        activityRcmdReqList.add(activityRcmdReq0);
        ActivityRcmdReq activityRcmdReq1 = new ActivityRcmdReq();
        activityRcmdReq1.setActivityId(30915L);
        activityRcmdReqList.add(activityRcmdReq1);
        ActivityRcmdReq activityRcmdReq2 = new ActivityRcmdReq();
        activityRcmdReq2.setActivityId(31143L);
        activityRcmdReqList.add(activityRcmdReq2);
        ActivityRcmdReq activityRcmdReq3 = new ActivityRcmdReq();
        activityRcmdReq3.setActivityId(30942L);
        activityRcmdReqList.add(activityRcmdReq3);
        ActivityRcmdReq activityRcmdReq4 = new ActivityRcmdReq();
        activityRcmdReq4.setActivityId(26497L);
        activityRcmdReqList.add(activityRcmdReq4);
        UserFeatureDoV2 userFeatureDoV2 = new UserFeatureDoV2();
        ContextFeatureDoV2 contextFeatureDoV2 = new ContextFeatureDoV2();
        contextFeatureDoV2.setAbTestId("openRCMD");
        contextFeatureDoV2.setUaAppPackageTrade2("1");
        contextFeatureDoV2.setSlotId(Long.valueOf(422622L));
        HashMap<Long, Integer> retMap = new HashMap<Long, Integer>();
        HashMap<String, Integer> retMap2 = new HashMap<String, Integer>();
        HashMap<Long, Integer> retMap3 = new HashMap<Long, Integer>();
        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        for (int i = 0; i < 10000; ++i) {
            ActivityRcmdRet ret = ActivityAlg.rcmd(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2, null, null, null);
            Long act = ret.getActivityId();
            retMap.put(act, retMap.getOrDefault(act, 0) + 1);
            Long algRcmdType = ret.getAlgRcmdType();
            retMap2.put(algRcmdType + "-" + act, retMap2.getOrDefault(algRcmdType + "-" + act, 0) + 1);
            retMap3.put(algRcmdType, retMap3.getOrDefault(algRcmdType, 0) + 1);
        }
        System.out.println("retMap=" + JSON.toJSONString(retMap));
        System.out.println("retMap2=" + JSON.toJSONString(retMap2));
        System.out.println("retMap3=" + JSON.toJSONString(retMap3));
        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
    }

    public static void run() throws Exception {
        ArrayList<ActivityRcmdReq> activityRcmdReqList = new ArrayList<ActivityRcmdReq>();
        for (int i = 0; i < 50; ++i) {
            ActivityRcmdReq activityRcmdReq = new ActivityRcmdReq();
            activityRcmdReq.setActivityId(1001L);
        }
        UserFeatureDoV2 userFeatureDoV2 = new UserFeatureDoV2();
        ContextFeatureDoV2 contextFeatureDoV2 = new ContextFeatureDoV2();
        System.out.println("time start=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        long d1 = System.currentTimeMillis();
        for (int j = 0; j < 1000; ++j) {
            ActivityAlg.rcmd(activityRcmdReqList, contextFeatureDoV2, userFeatureDoV2, null, null, null);
        }
        long d2 = System.currentTimeMillis();
        System.out.println("time end=" + LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS_SSS));
        System.out.println("\u8017\u65f6\uff1a" + (d2 - d1) + " ms");
    }

    public static void run3() throws Exception {
        List<ActivityRcmdRet> activityRcmdRetList = new ArrayList<ActivityRcmdRet>();
        ActivityRcmdRet r1 = new ActivityRcmdRet();
        r1.setActivityId(1L);
        r1.setScore(1.0);
        activityRcmdRetList.add(r1);
        ActivityRcmdRet r2 = new ActivityRcmdRet();
        r2.setActivityId(0L);
        r2.setScore(2.0);
        activityRcmdRetList.add(r2);
        activityRcmdRetList = activityRcmdRetList.stream().sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed()).collect(Collectors.toList());
        System.out.println("activityRcmdRetList=" + JSON.toJSONString(activityRcmdRetList));
    }
}

