/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.alg.activity.ActivityInfo;
import cn.com.duiba.nezha.alg.alg.activity.ActivityParams;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdReq;
import cn.com.duiba.nezha.alg.alg.activity.ActivityRcmdRet;
import cn.com.duiba.nezha.alg.alg.activity.ActivitySubParams;
import cn.com.duiba.nezha.alg.alg.activity.ScoreDo;
import cn.com.duiba.nezha.alg.alg.activity.SlotInfo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRcmder.class);
    private static String LOG_PRIFIX = "ActivityRcmder";
    private static HashMap<Long, String> sActMap = new HashMap();
    private static HashMap<Long, Long> dActMap = new HashMap();
    private static Random random = new Random();
    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap();
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap();
    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L);

    public static Long getAlgRcmdType() {
        double rd = Math.random();
        if (rd <= 0.6) {
            return 1L;
        }
        if (rd <= 0.9) {
            return 2L;
        }
        return 3L;
    }

    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }

    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }

    public static Map<Long, FeatureMapDo> getFeatureMap(List<ActivityRcmdReq> activityRcmdReqList, ContextFeatureDoV2 contextFeatureDoV2, UserFeatureDoV2 userFeatureDoV2) throws Exception {
        HashMap<Long, FeatureMapDo> featureMap = new HashMap<Long, FeatureMapDo>();
        Map staticFeatureMap = ActivityFeatureParse.generateFeatureMapStatic((ContextFeatureDoV2)contextFeatureDoV2, (UserFeatureDoV2)userFeatureDoV2);
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap activityRcmdReqList is null");
            return featureMap;
        }
        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {
            Long activityId = activityRcmdReq.getActivityId();
            String str = JSON.toJSONString((Object)activityRcmdReq);
            ActFeatureDoV2 actFeatureDoV2 = (ActFeatureDoV2)JSON.parseObject((String)str, ActFeatureDoV2.class);
            Map dynamicFeatureMap = ActivityFeatureParse.generateFeatureMapDynamic((ActFeatureDoV2)actFeatureDoV2, (UserFeatureDoV2)userFeatureDoV2);
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);
        }
        return featureMap;
    }

    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap, DeepModelV2 deepModelV2, LocalTFModelV2 localTFModelV2) throws Exception {
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{deepModelV2, localTFModelV2})) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        }
        return new HashMap<Long, Double>();
    }

    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList, ActivityParams activityParams, Map<Long, Double> preEcpmMap, Long slotId, String appPkgTrade2, Long algRcmdType) throws Exception {
        List<ActivityRcmdRet> activityRcmdRetList = ActivityRcmder.getScore(activityRcmdReqList, activityParams, preEcpmMap, slotId);
        ActivityRcmdRet ret = ActivityRcmder.select(activityRcmdRetList, algRcmdType);
        return ret;
    }

    public static List<ActivityRcmdReq> recall(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Long algRcmdType) throws Exception {
        if (algRcmdType.equals(3L)) {
            return ActivityRcmder.recall2(activityRcmdReqList);
        }
        if (algRcmdType.equals(2L)) {
            return ActivityRcmder.recallMade(activityRcmdReqList, appPkgTrade2, slotId);
        }
        return ActivityRcmder.recall1(activityRcmdReqList, appPkgTrade2, slotId);
    }

    public static List<ActivityRcmdReq> recall2(List<ActivityRcmdReq> activityRcmdReqList) throws Exception {
        ArrayList<ActivityRcmdReq> ret = new ArrayList<ActivityRcmdReq>();
        for (int i = 0; i < activityRcmdReqList.size(); ++i) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            if (!testList.contains(activityId)) continue;
            ret.add(activityRcmdReq);
        }
        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }
        return ret;
    }

    public static List<ActivityRcmdReq> recall1(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId) throws Exception {
        ArrayList<ActivityRcmdReq> ret = new ArrayList<ActivityRcmdReq>();
        Long dAct = ActivityRcmder.getDefActId(slotId);
        Long dActType = ActivityRcmder.getDefActType(slotId);
        for (int i = 0; i < activityRcmdReqList.size(); ++i) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = ActivityRcmder.getActTrade2(activityId);
            Long actType = ActivityRcmder.getActType(activityId);
            boolean recall = false;
            if (dAct != null && activityId.equals(dAct)) {
                recall = true;
            }
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2) && dActType != null && dActType.equals(actType)) {
                recall = true;
            }
            if (!recall) continue;
            ret.add(activityRcmdReq);
        }
        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }
        return ret;
    }

    public static List<ActivityRcmdReq> recallMade(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId) throws Exception {
        ArrayList<ActivityRcmdReq> ret = new ArrayList<ActivityRcmdReq>();
        Long dAct = ActivityRcmder.getDefActId(slotId);
        Long dActType = ActivityRcmder.getDefActType(slotId);
        for (int i = 0; i < activityRcmdReqList.size(); ++i) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = ActivityRcmder.getActTrade2(activityId);
            Long actType = ActivityRcmder.getActType(activityId);
            boolean recall = false;
            if (appPkgTrade2 == null && dAct != null && activityId.equals(dAct)) {
                recall = true;
            }
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2) && dActType != null && dActType.equals(actType)) {
                recall = true;
            }
            if (!recall) continue;
            ret.add(activityRcmdReq);
        }
        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }
        return ret;
    }

    private static ActivityRcmdRet select(List<ActivityRcmdRet> activityRcmdRetList, Long algRcmdType) throws Exception {
        ActivityRcmdRet ret = null;
        if (AssertUtil.isEmpty(activityRcmdRetList)) {
            logger.warn(LOG_PRIFIX + ".rank select is Empty,invaild");
            return ret;
        }
        activityRcmdRetList = activityRcmdRetList.stream().sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed()).collect(Collectors.toList());
        if (algRcmdType.equals(1L)) {
            ret = activityRcmdRetList.get(0);
        } else {
            int n = random.nextInt(activityRcmdRetList.size());
            ret = activityRcmdRetList.get(n);
        }
        ret.setAlgRcmdType(algRcmdType);
        ArrayList<ScoreDo> scoreDoList = new ArrayList<ScoreDo>();
        for (int i = 0; i < activityRcmdRetList.size(); ++i) {
            ActivityRcmdRet activityRcmdRet;
            if (i >= 5 || (activityRcmdRet = activityRcmdRetList.get(i)) == null) continue;
            ScoreDo scoreDo = new ScoreDo();
            scoreDo.setActivityId(activityRcmdRet.getActivityId());
            scoreDo.setPreEcpm(activityRcmdRet.getPreEcpm());
            scoreDo.setScore(activityRcmdRet.getScore());
            if (activityRcmdRet.getActivitySubParams() != null) {
                scoreDo.setStatEcpm(activityRcmdRet.getActivitySubParams().getEcpm());
            }
            scoreDoList.add(scoreDo);
        }
        ret.setTopScoreDoList(scoreDoList);
        return ret;
    }

    private static List<ActivityRcmdRet> getScore(List<ActivityRcmdReq> activityRcmdReqList, ActivityParams activityParams, Map<Long, Double> preEcpmMap, Long slotId) throws Exception {
        ArrayList<ActivityRcmdRet> ret = new ArrayList<ActivityRcmdRet>();
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  activityRcmdReqList is Empty,invaild");
            return ret;
        }
        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {
            Long activityId = activityRcmdReq.getActivityId();
            String activitySourceType = activityRcmdReq.getActivitySourceType();
            Double preEcpm = 0.0011;
            if (preEcpmMap != null && preEcpmMap.get(activityId) != null) {
                preEcpm = preEcpmMap.get(activityId);
            }
            ActivitySubParams activitySubParams = null;
            if (activityParams != null) {
                activitySubParams = activityParams.getFactor(activityId, activitySourceType, slotId);
            }
            Double score = ActivityRcmder.getScore(preEcpm, activitySubParams);
            ActivityRcmdRet activityRcmdRet = new ActivityRcmdRet();
            activityRcmdRet.setActivityId(activityId);
            activityRcmdRet.setActivitySubParams(activitySubParams);
            activityRcmdRet.setScore(score);
            activityRcmdRet.setPreEcpm(preEcpm);
            ret.add(activityRcmdRet);
        }
        return ret;
    }

    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;
        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();
            Double factor = activitySubParams.getFactor();
            if (statEcpm != null) {
                ret = Math.random() > statRatio ? preEcpm * 1.0 + statEcpm * 0.0 : statEcpm;
            }
            ret *= factor.doubleValue();
        }
        return ret;
    }

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));
        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 30828L, 2L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 30828L, 2L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
    }
}

