/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.advert.v2;

import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.advert.AdBidResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidReCostStrategy {
    private static final Logger log = LoggerFactory.getLogger(BidReCostStrategy.class);

    public static void reCost(Map<String, AdBidResultDo> controlResultMap) {
        ArrayList<AdBidResultDo> adBidResultDoList = new ArrayList<AdBidResultDo>();
        for (Map.Entry<String, AdBidResultDo> entry : controlResultMap.entrySet()) {
            BidReCostStrategy.scoreUpdate(entry.getValue());
            adBidResultDoList.add(entry.getValue());
        }
        Collections.sort(adBidResultDoList);
        int size = controlResultMap.size();
        for (int i = 0; i < size - 1; ++i) {
            AdBidResultDo leftDo = (AdBidResultDo)adBidResultDoList.get(i);
            AdBidResultDo rightDo = (AdBidResultDo)adBidResultDoList.get(i + 1);
            BidReCostStrategy.reCost(leftDo, rightDo);
        }
        BidReCostStrategy.reCost((AdBidResultDo)adBidResultDoList.get(size - 1), null);
    }

    public static void reCost(AdBidResultDo top1, AdBidResultDo top2) {
        if (AssertUtil.isEmpty((Object)top1)) {
            return;
        }
        if (top1.getChargeType() != 2) {
            return;
        }
        AdBidParamsDo top1Params = top1.getAdBidParamsDo();
        if (AssertUtil.isEmpty((Object)top1Params)) {
            return;
        }
        Boolean isCostProject = top1Params.getSecondPriceProject();
        Double costFactor = top1Params.getCFactor();
        if (isCostProject == null || !isCostProject.booleanValue() || costFactor == null) {
            top1Params.setCostFee(top1.getFee());
            return;
        }
        long top1Fee = top1.getFee();
        long top2Fee = top2 != null ? top2.getFee() : 0L;
        Double top1Ecpm = top1.getEcpm();
        Double top2Ecpm = top2 != null ? top2.getEcpm() : top1.getEcpm();
        double secondRatio = top2 != null ? 1.0 : 0.5;
        Double extraCFactor = top1Params.getExtraCFactor();
        Integer extraCSwitch = top1Params.getExtraCSwitch();
        if (top2 != null && extraCSwitch != null && extraCSwitch == 1 && extraCFactor != null) {
            secondRatio = extraCFactor;
            if (Math.random() < 0.001) {
                log.info("extraCFactor " + extraCFactor.toString() + " extraCSwitch" + extraCSwitch.toString() + " advertId " + top1.getAdvertId() + " pkId " + top1.getPackageId());
            }
        }
        double minCostFactor = top2Ecpm * secondRatio / top1Ecpm;
        costFactor = Math.max(costFactor, minCostFactor);
        long costFee = Math.round((double)top1.getFee().longValue() * costFactor);
        long feeNew = costFactor > 1.0 ? Math.max(top1Fee, costFee) : Math.min(top1Fee, costFee);
        top1.setFee(feeNew);
        top1Params.setFee(feeNew);
        top1Params.setCostFee(feeNew);
        System.out.println("ad=" + top1.getAdvertId() + ",top1Fee=" + top1Fee + ",top2Fee=" + top2Fee + ",feeNew=" + feeNew);
    }

    public static void scoreUpdate(AdBidResultDo adBidResultDo) {
        Double score = adBidResultDo.getCtr() * (double)adBidResultDo.getFee().longValue();
        adBidResultDo.setScore(score);
        adBidResultDo.setEcpm(score);
    }
}

