package cn.com.duiba.nezha.alg.alg.vo.adx.rta;

import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class RtaRoiControlModel {

    /**
     * 广告主账户 数据
     * Map<广告主账户ID，参数>
     */
    Map<Long, RtaRoiControlParams> roiControlParamsMap = new HashMap<>();


    /**
     * 参数更新时间
     */
    String updateTime;


    /**
     * 广告主账户参数
     *
     * @param accountId
     * @return
     */
    public RtaRoiControlParams getRoiControlParams(Long accountId) {

        if (roiControlParamsMap.get(accountId) == null) {
            roiControlParamsMap.put(accountId, new RtaRoiControlParams());
        }
        return roiControlParamsMap.get(accountId);
    }

    /**
     * 广告主账户参数
     *
     * @param accountId
     * @return
     */
    public void putRoiControlParams(Long accountId, RtaRoiControlParams roiControlParams) {

        roiControlParamsMap.put(accountId, roiControlParams);
    }

}
