package cn.com.duiba.nezha.alg.alg.activity;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.parse.v2.ActivityFeatureParse;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.feature.vo.v2.ActFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.ContextFeatureDoV2;
import cn.com.duiba.nezha.alg.feature.vo.v2.UserFeatureDoV2;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;


public class ActivityRcmder {
    private static final Logger logger = LoggerFactory.getLogger(ActivityRcmder.class);

    private static String LOG_PRIFIX = "ActivityRcmder";

    private static HashMap<Long, String> sActMap = new HashMap<>();//定制

    private static HashMap<Long, Long> dActMap = new HashMap<>();//默认


    private static Random random = new Random();


    private static HashMap<Long, ActivityInfo> actWhiteList = new HashMap<>();//活动白名单配置信息
    private static HashMap<Long, SlotInfo> slotWhiteList = new HashMap<>();//广告位白名单配置信息

    private static List testList = Arrays.asList(30942L, 30828L, 26497L, 30222L, 30784L, 31234L,31352L,31185L,31475L,31557L,31545L,30192L);//随机测试活动-配置信息

    static {
        actWhiteList.put(30942L, new ActivityInfo(30942L, 1L, null));
        actWhiteList.put(31143L, new ActivityInfo(31143L, 1L, "1"));
        actWhiteList.put(31346L, new ActivityInfo(31346L, 1L, "1"));
        actWhiteList.put(31144L, new ActivityInfo(31144L, 1L, "2"));
        actWhiteList.put(31145L, new ActivityInfo(31145L, 1L, "3"));
        actWhiteList.put(31146L, new ActivityInfo(31146L, 1L, "4"));
        actWhiteList.put(30828L, new ActivityInfo(30828L, 2L, null));
        actWhiteList.put(31184L, new ActivityInfo(31184L, 2L, "1"));
        actWhiteList.put(30998L, new ActivityInfo(30998L, 2L, "2"));
        actWhiteList.put(31101L, new ActivityInfo(31101L, 2L, "3"));
        actWhiteList.put(31307L, new ActivityInfo(31307L, 2L, "8"));
        actWhiteList.put(31308L, new ActivityInfo(31308L, 2L, "11"));
        actWhiteList.put(31183L, new ActivityInfo(31183L, 2L, "4"));
        actWhiteList.put(30222L, new ActivityInfo(30222L, 1L, null));

    }

    static {

        slotWhiteList.put(417764L, new SlotInfo(417764L, 30942L, 1L));
        slotWhiteList.put(422622L, new SlotInfo(422622L, 30942L, 1L));
        slotWhiteList.put(404873L, new SlotInfo(404873L, 30828L, 2L));
        slotWhiteList.put(417855L, new SlotInfo(417855L, 30828L, 2L));
        slotWhiteList.put(423985L, new SlotInfo(423985L, 30222L, 1L));
        slotWhiteList.put(420877L, new SlotInfo(420877L, 30828L, 2L));
        slotWhiteList.put(404106L, new SlotInfo(404106L, 30828L, 2L));

    }


    public static Long getAlgRcmdType() {
        double rd = Math.random();
        if (rd <= 0.6) {
            return 1L;
        }
        if (rd <= 0.9) {
            return 2L;
        }
        return 3L;

    }

    public static Long getActType(Long activityId) {
        Long ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActType() != null) {
            ret = activityInfo.getActType();
        }
        return ret;
    }

    public static String getActTrade2(Long activityId) {
        String ret = null;
        ActivityInfo activityInfo = actWhiteList.get(activityId);
        if (activityInfo != null && activityInfo.getActTrade2() != null) {
            ret = activityInfo.getActTrade2();
        }
        return ret;
    }


    public static Long getDefActId(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActId() != null) {
            ret = slotInfo.getDefActId();
        }
        return ret;
    }

    public static Long getDefActType(Long slotId) {
        Long ret = null;
        SlotInfo slotInfo = slotWhiteList.get(slotId);
        if (slotInfo != null && slotInfo.getDefActType() != null) {
            ret = slotInfo.getDefActType();
        }
        return ret;
    }


//    public static String getActTrade2(Long activityId) {
//
//        if (sActMap.isEmpty()) {
//            sActMap.put(30915L, "1");
//            sActMap.put(31059L, "1");
//            sActMap.put(30916L, "4");
//            sActMap.put(27870L, "19");
//            sActMap.put(30998L, "2");
//            sActMap.put(31058L, "2");
//            sActMap.put(29084L, "2");
//            sActMap.put(31101L, "3");
//            sActMap.put(29917L, "3");
//            sActMap.put(30553L, "12");
//        }
//        return sActMap.get(activityId);
//    }
//
//    public static Long getActDef(Long slotId) {
//
//        if (dActMap.isEmpty()) {
//            dActMap.put(422622L, 30942L);
//            dActMap.put(417764L, 30942L);
//            dActMap.put(423985L, 30222L);
//            dActMap.put(417855L, 30828L);
//            dActMap.put(404873L, 30828L);
//            dActMap.put(396214L, 26497L);
//        }
//        return dActMap.get(slotId);
//    }

    /**
     * 活动特征解析
     *
     * @return
     */
    public static Map<Long, FeatureMapDo> getFeatureMap(List<ActivityRcmdReq> activityRcmdReqList,
                                                        ContextFeatureDoV2 contextFeatureDoV2,
                                                        UserFeatureDoV2 userFeatureDoV2) throws Exception {

        Map<Long, FeatureMapDo> featureMap = new HashMap<>();

        //1 非计划特征：静态特征解析
        Map<String, String> staticFeatureMap = ActivityFeatureParse.generateFeatureMapStatic(contextFeatureDoV2, userFeatureDoV2);

        Long activityPage = Optional.ofNullable(contextFeatureDoV2.getActivityPage()).orElse(null);


        //2 计划特征：动态特征解析
        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getFeatureMap activityRcmdReqList is null");
            return featureMap;
        }

        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {

            Long activityId = activityRcmdReq.getActivityId();
            if (activityPage == null) {
                activityPage = activityId;
            }
            activityRcmdReq.setActivityPage(activityPage);

            String str = JSON.toJSONString(activityRcmdReq);
            ActFeatureDoV2 actFeatureDoV2 = JSON.parseObject(str, ActFeatureDoV2.class);

            Map<String, String> dynamicFeatureMap = ActivityFeatureParse.generateFeatureMapDynamic(actFeatureDoV2, userFeatureDoV2, contextFeatureDoV2);

            //3 封装计划特征集合
            FeatureMapDo featureMapDo = new FeatureMapDo();
            featureMapDo.setDynamicFeatureMap(dynamicFeatureMap);
            featureMapDo.setStaticFeatureMap(staticFeatureMap);
            featureMap.put(activityId, featureMapDo);

        }

        return featureMap;


    }

    /**
     * 模型预估
     */
    public static Map<Long, Double> predict(Map<Long, FeatureMapDo> featureMapDoMap,
                                            DeepModelV2 deepModelV2,
                                            LocalTFModelV2 localTFModelV2) throws Exception {

        if (AssertUtil.isAllNotEmpty(deepModelV2, localTFModelV2)) {
            return deepModelV2.predictWithLocalTFV2(featureMapDoMap, localTFModelV2);
        } else {
            return new HashMap<>();
        }
    }


    /**
     * 推荐接口
     *
     * @param activityRcmdReqList
     * @param activityParams
     * @param preEcpmMap
     * @return
     * @throws Exception
     */
    public static ActivityRcmdRet rcmd(List<ActivityRcmdReq> activityRcmdReqList,
                                       ActivityParams activityParams,
                                       Map<Long, Double> preEcpmMap, Long slotId, String appPkgTrade2, Long algRcmdType,Long dsm2A) throws Exception {


        /**
         * 计算排序分
         */
        List<ActivityRcmdRet> activityRcmdRetList = getScore(activityRcmdReqList, activityParams, preEcpmMap, slotId,dsm2A);


        /**
         * 推荐
         */
        ActivityRcmdRet ret = select(activityRcmdRetList, algRcmdType);

        return ret;
    }

    /**
     * @param activityRcmdReqList 活动列表
     * @param appPkgTrade2        媒体包
     * @param slotId
     * @param algRcmdType         算法策略类型
     * @param filterActSet        已投放活动，过滤
     * @return
     * @throws Exception
     */
    public static List<ActivityRcmdReq> recall(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Long algRcmdType, Set<Long> filterActSet) throws Exception {
        if (algRcmdType.equals(3L)) {
            return recall2(activityRcmdReqList, filterActSet,appPkgTrade2);
        }
        if (algRcmdType.equals(2L)) {
            return recallMade(activityRcmdReqList, appPkgTrade2, slotId, filterActSet);
        }
        return recall1(activityRcmdReqList, appPkgTrade2, slotId, filterActSet);

    }

    /**
     * 召回随机测试活动
     */
    public static List<ActivityRcmdReq> recall2(List<ActivityRcmdReq> activityRcmdReqList, Set<Long> filterActSet,String appPkgTrade2) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();

        List<ActivityRcmdReq> retDef = new ArrayList<>();//默认活动
        List<ActivityRcmdReq> retSpe = new ArrayList<>();//媒体包+定制活动
        List<ActivityRcmdReq> retOther = new ArrayList<>();//普通活动

        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签

            // 媒体包和活动标签一致，召回
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                continue;
            }

            // 去重
            if (!filterActSet.contains(activityId)) {
                ret.add(activityRcmdReq);
            }

        }


        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }

        return ret;
    }

    /**
     * 策略1-召回
     * 计算排序分
     */
    public static List<ActivityRcmdReq> recall1(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Set<Long> filterActSet) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        Long dAct = getDefActId(slotId); //默认活动id
        Long dActType = getDefActType(slotId); //默认活动玩法

        // 是否媒体包流量+媒体包活动
        boolean hasSpecAct=false;

        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签
            Long actType = getActType(activityId);//当前活动玩法


            /**
             * 活动过滤
             * 1、默认活动
             * 2、媒体包定制活动 且 玩法一致
             */

            boolean recall = false;
            // 默认活动 召回
            if (dAct != null && activityId.equals(dAct)) {
                recall = true;

            }

            // 媒体包和活动标签一致，召回
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                if (dActType != null && dActType.equals(actType)) {
                    recall = true;
                    hasSpecAct=true;
                }
            }

            if (recall) {
                if (!filterActSet.contains(activityId)) {
                    ret.add(activityRcmdReq);
                }
            }

        }


        if(!hasSpecAct){
            ret= activityRcmdReqList;
        }

        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }


        return ret;
    }


    /**
     * 策略2
     * 召回活动
     * 1、非媒体包：默认活动 召回
     * 2、媒体包：定制活动 且 玩法一致 召回
     */
    public static List<ActivityRcmdReq> recallMade(List<ActivityRcmdReq> activityRcmdReqList, String appPkgTrade2, Long slotId, Set<Long> filterActSet) throws Exception {
        List<ActivityRcmdReq> ret = new ArrayList<>();
        Long dAct = getDefActId(slotId); //默认活动id
        Long dActType = getDefActType(slotId); //默认活动玩法
        // 是否媒体包流量+媒体包活动
        boolean hasSpecAct=false;

        for (int i = 0; i < activityRcmdReqList.size(); i++) {
            ActivityRcmdReq activityRcmdReq = activityRcmdReqList.get(i);
            Long activityId = activityRcmdReq.getActivityId();
            String actTrade2 = getActTrade2(activityId);//当前活动行业标签
            Long actType = getActType(activityId);//当前活动玩法


            boolean recall = false;

            // 非媒体包：默认活动 召回
            if (appPkgTrade2 == null) {
                if (dAct != null && activityId.equals(dAct)) {
                    recall = true;
                }
            }

            // 媒体包：定制活动 且 玩法一致 召回
            if (appPkgTrade2 != null && appPkgTrade2.equals(actTrade2)) {
                if (dActType != null && dActType.equals(actType)) {
                    recall = true;
                    hasSpecAct=true;
                }
            }

            if (recall) {
                if (!filterActSet.contains(activityId)) {
                    ret.add(activityRcmdReq);
                }
            }
        }



        if(!hasSpecAct){
            ret= activityRcmdReqList;
        }

        if (ret.isEmpty()) {
            ret.add(activityRcmdReqList.get(0));
        }

        return ret;
    }


    /**
     * 计算排序分
     */
    private static ActivityRcmdRet select(List<ActivityRcmdRet> activityRcmdRetList, Long algRcmdType) throws Exception {
        ActivityRcmdRet ret = null;

        if (AssertUtil.isEmpty(activityRcmdRetList)) {
            logger.warn(LOG_PRIFIX + ".rank select is Empty,invaild");
            return ret;
        }

        activityRcmdRetList = activityRcmdRetList.stream()
                .sorted(Comparator.comparing(ActivityRcmdRet::getScore).reversed())
                .collect(Collectors.toList());


        /**
         * 1 推荐
         */
        if (algRcmdType.equals(1L)) {
            //60%概率，推荐类型1，score最大胜出
            ret = activityRcmdRetList.get(0);

        } else {
            //随机胜出
            int n = random.nextInt(activityRcmdRetList.size());
            ret = activityRcmdRetList.get(n);
        }

        ret.setAlgRcmdType(algRcmdType);


        /**
         * 2 记录top5活动数据
         */
        List<ScoreDo> scoreDoList = new ArrayList<>();

        for (int i = 0; i < activityRcmdRetList.size(); i++) {
            if (i < 5) {
                ActivityRcmdRet activityRcmdRet = activityRcmdRetList.get(i);
                if (activityRcmdRet != null) {
                    ScoreDo scoreDo = new ScoreDo();
                    scoreDo.setActivityId(activityRcmdRet.getActivityId());
                    scoreDo.setPreEcpm(activityRcmdRet.getPreEcpm());
                    scoreDo.setScore(activityRcmdRet.getScore());
                    if (activityRcmdRet.getActivitySubParams() != null) {
                        scoreDo.setStatEcpm(activityRcmdRet.getActivitySubParams().getEcpm());
                    }

                    scoreDoList.add(scoreDo);
                }
            }
        }

        ret.setTopScoreDoList(scoreDoList);
        return ret;

    }

    /**
     * 计算排序分
     */
    private static List<ActivityRcmdRet> getScore(List<ActivityRcmdReq> activityRcmdReqList,
                                                  ActivityParams activityParams,
                                                  Map<Long, Double> preEcpmMap, Long slotId,Long dsm2A) throws Exception {
        List<ActivityRcmdRet> ret = new ArrayList<>();

        if (AssertUtil.isEmpty(activityRcmdReqList)) {
            logger.warn(LOG_PRIFIX + ".getScore  activityRcmdReqList is Empty,invaild");

            return ret;
        }


        for (ActivityRcmdReq activityRcmdReq : activityRcmdReqList) {

            Long activityId = activityRcmdReq.getActivityId();

//            Long slotId = activityRcmdReq.getSlotId();

            // 1、数据准备

            Double preEcpm = 0.0011;
            if (preEcpmMap != null && preEcpmMap.get(activityId) != null) {
                preEcpm = preEcpmMap.get(activityId);
            }

            // 2、计算排序分

            ActivitySubParams activitySubParams = null;
            if (activityParams != null) {
                activitySubParams = activityParams.getFactor(activityId, dsm2A, slotId);
            }
            Double score = getScore(preEcpm, activitySubParams);


            // 3、结果封装
            ActivityRcmdRet activityRcmdRet = new ActivityRcmdRet();
            activityRcmdRet.setActivityId(activityId);
            activityRcmdRet.setActivitySubParams(activitySubParams);
            activityRcmdRet.setScore(score);
            activityRcmdRet.setPreEcpm(preEcpm);

            ret.add(activityRcmdRet);
        }

        return ret;
    }


    /**
     * 计算排序分
     *
     * @param preEcpm
     * @param activitySubParams
     * @return
     */
    private static Double getScore(double preEcpm, ActivitySubParams activitySubParams) {
        double ret = preEcpm;

        /**
         * 1、概率1-p，score=（1-w）* preEcpm + w * statEcpm
         * 2、概率p，score= statEcpm
         */

        if (activitySubParams != null) {
            Double statEcpm = activitySubParams.getEcpm();
            Double statRatio = activitySubParams.getStatRatio();

            Double factor = activitySubParams.getFactor();

            if (statEcpm != null) {

                if (Math.random() > statRatio) {
                    // 概率1-p，score=（1-w）* preEcpm + w * statEcpm

                    ret = preEcpm * 1.0 + statEcpm * 0.0;

                } else {
                    // 概率p，score= statEcpm
                    ret = statEcpm;
                }
            }


            /**
             * 扶持因子
             * 1、新活动、冷启动控制
             * 2、扶持活动【统计表现好、拿量衰减、等】
             */
            ret = ret * factor;
        }

        return ret;
    }

}
