package cn.com.duiba.nezha.alg.alg.adx.rta;

import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

@Data
public class RTAModel {
    private static final Logger logger = LoggerFactory.getLogger(RTAModel.class);

    private IModel RtaCoder;
    private LocalTFModelV2 RtaTFModel;  // RtaCoder对应的TF model

    public <T> Map<T, Double> predictRta(Map<T, FeatureMapDo> featureMap) throws Exception {
        try {
            Map<T, Double> ret;
            logger.info("featureMap{}, RtaTFModel{}", JSONObject.toJSON(featureMap), JSONObject.toJSON(RtaTFModel));
            ret = RtaCoder.predictWithLocalTFV2(featureMap, RtaTFModel);
            return ret;
        }
        catch (Exception e) {
            logger.error("AdxRecommend.predictRta error{}, RtaCoder{}, RtaTFModel{}", e, RtaCoder, RtaTFModel);
        }
        return null;
    }
}