package cn.com.duiba.nezha.alg.alg.coldstartandexplore;

import cn.com.duiba.nezha.alg.alg.coldstartandexplore.util.*;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEInfoDo;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEParams;
import cn.com.duiba.nezha.alg.alg.vo.strongtargetexplore.STEResultDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * 强定向媒体探索 功能接口
 */
public class StrongTargetExplore {
    private static final Logger logger= LoggerFactory.getLogger(StrongTargetExplore.class);

    /**
     * 用于调权因子制定阶段的辅助排序
     */
    static class RectifyNdAdvertResInfo {
        double rectifyBid = 0.0;   // 修正后的bid
        STEResultDo steResult;
    }

    /**
     * 出价降序排
     */
    private static final Comparator<StrongTargetExplore.RectifyNdAdvertResInfo> iComparator = new Comparator<StrongTargetExplore.RectifyNdAdvertResInfo>() {
        @Override
        public int compare(StrongTargetExplore.RectifyNdAdvertResInfo r1, StrongTargetExplore.RectifyNdAdvertResInfo r2) { return (int) (r2.rectifyBid- r1.rectifyBid >= 0 ? 1 : -1); }
    };

    /**
     * 探索入口
     */
    public static List<STEResultDo> STE (STEParams steParams,
                                         List<STEInfoDo> steInfoDoList) {
        List<STEResultDo> res = new ArrayList<>();
        if (AssertUtil.isAnyEmpty(steParams, steInfoDoList)) {
            return res;
        }

        Queue<StrongTargetExplore.RectifyNdAdvertResInfo> candis = new PriorityQueue<>(iComparator);

        // 将要计算调权因子的广告按降序（curRectifyBid）添加到candis（Queen）中
        for (STEInfoDo steInfoDo : steInfoDoList) {
            double curRectifyBid = 0.0D;
            double exposureFactor = 1.0D;
            Integer exposeConfidenceThreshold2;
            StrongTargetExplore.RectifyNdAdvertResInfo rectifyNdAdvertResInfo = new StrongTargetExplore.RectifyNdAdvertResInfo();

            Map<String, Object> AdjustCVRRes = GetCvr.getAdjustCVR(steParams, steInfoDo);
            double adjustWeight = (double) AdjustCVRRes.get("adjustWeight");
            double adjustCvr = (double) AdjustCVRRes.get("adjustCvr");
            String paramType = ((double) AdjustCVRRes.get("paramType") == 1.0) ? "firstSet" : "secondSet";
            double preCtr = steInfoDo.getPreCtr();
            Long bid = steInfoDo.getBid();
            Long hisSlotAdvExpose = steInfoDo.getHisExpose();

            if (paramType.equals("firstSet")) {
                exposeConfidenceThreshold2 = steParams.getExposeConfidenceThreshold2();
            } else {
                exposeConfidenceThreshold2 = steParams.getExposeConfidenceThresholdSet5();
            }

            if (hisSlotAdvExpose <= exposeConfidenceThreshold2) {
                exposureFactor = WeightingFunction.functionOfExpose(hisSlotAdvExpose, steParams, paramType);
                curRectifyBid = preCtr * adjustCvr * bid * exposureFactor;
            } else {
                curRectifyBid = preCtr * adjustCvr * bid;
            }

            rectifyNdAdvertResInfo.steResult = EncapsulateData.fillData(steInfoDo, exposureFactor, 1.0, adjustWeight, adjustCvr, 1);
            rectifyNdAdvertResInfo.rectifyBid = curRectifyBid;
            candis.add(rectifyNdAdvertResInfo);
        }

        // 对candis（Queen）中的广告，求取调权因子
        int lengthOfCandis = candis.size();
        for (int idx=0; idx < lengthOfCandis; idx++) {
            StrongTargetExplore.RectifyNdAdvertResInfo curRectifyNdAdvertResInfo = candis.poll();
            assert curRectifyNdAdvertResInfo != null;
            Double upLimit = curRectifyNdAdvertResInfo.steResult.getStrTarExpAdjFacUpLimit();
            curRectifyNdAdvertResInfo.steResult.setAdjustFactor(Math.max(upLimit*WeightingFunction.decreaseFunc(idx, steParams), 1.0));
            curRectifyNdAdvertResInfo.steResult.setRankInCandis(idx+1);
            res.add(curRectifyNdAdvertResInfo.steResult);
        }

        return res;
    }

}
