package cn.com.duiba.nezha.alg.alg.vo.adx.rtb;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * cpc维稳因子信息
 */

@Data
public class CpcControlDo implements Serializable {

    private static final long serialVersionUID = 3844743322872554726L;

    /**
     * cpc维稳因子表({分level：小数})
     */
    private Map<String, Double> factorMap;

    /**
     * 流量比例表({分level：小数})
     */
    private Map<String, Double> flowRateMap;

    /**
     * 实际cpc表({分level：小数})
     */
    private Map<String, Double> cpcMap;

    /**
     * 实际竞价成功率({分level：小数})
     */
    private Map<String, Double> sucMap;

    /**
     * 冷启动试探标记
     */
    private Integer tryLabel;

    /**
     * 目标cpc(分/单次点击)
     */
    private Double targetCpc;

    /**
     * 实时cpc
     */
    private Double cpcMin;

    /**
     * 当天累计cpc
     */
    private Double cpcDay;

    /**
     * 实时竞价成功率
     */
    private Double sucMin;

    /**
     * 当天累计竞价成功率
     */
    private Double sucDay;

    /**
     * 实时adx消耗
     */
    private Long adxCostMin;

    /**
     * 当天累计adx消耗
     */
    private Long adxCostDay;

    /**
     * 实时advert消耗
     */
    private Long adConsumeMin;

    /**
     * 当天累计advert消耗
     */
    private Long adConsumeDay;

    /**
     * 实时竞价量级
     */
    private Long bidCntMin;

    /**
     * 当天累计竞价量级
     */
    private Long bidCntDay;

    /**
     * 策略实时竞价成功量级
     */
    private Long sucCntMin;

    /**
     * 策略累计竞价成功量级
     */
    private Long sucCntDay;

    /**
     * 策略实时点击量级
     */
    private Long clickCntMin;

    /**
     * 策略累计点击量级
     */
    private Long clickCntDay;

    /**
     * 数据是否置信
     */
    private Boolean isConfidence;

    /**
     * 实时融合cpc
     */
    private Double conCpcMin;

}
