package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;


public class AdxAlgoBidding {


    /**
     * 维度Key
     */
    public static String[] ADX_LEVEL =  AdxDimension.ADX_LEVEL;




    /**
     * 算法最终出价
     *
     * @param adxDoInfo 人工设置
     * @param adxRoiControlDoInfo 统计数据
     * @param adxRoiFactor ROI调节因子
     * @param AdxPriceExplorationDo 价格试探表
     * @param AdxFactorExplorationDo 因子试探表
     * @return isCompareGroup, level, adxAlgoPrice（分/千次曝光)
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo,
                                                      AdxRoiControlDo adxRoiControlDoInfo) {

        Map<String, String> retMap = new HashMap<>();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、当前数据是否合法
         * 步骤4、计算累计消耗，实时消耗
         * 步骤5、冷启动/实时消耗异常：走默认出价
         * 步骤6、根据strategy走策略1,2,3
         *
         */



        try {

            //步骤1 设置默认值
            Double minRoi = 1.00;                     // 默认ROI
            Double defaultRoiFactor = 1.00;           // 默认ROI调节因子
            Double roiFactorLowerLimit = 0.70;        // ROI调节因子下限
            Double roiFactorUpperLimit = 1.40;        // ROI调节因子上限
            Double defaultPreCtr = 0.07;              // 默认ctr
            Double defaultStatClickValue = 0.10*100;  // 默认点击价值
            Long advertFeeDayLimit = 15*100L;         // 当天广告消耗阈值（分）
            Long advertFeeMsLimit = 5*100L;           // 实时广告消耗阈值（分）

            String level = "0"; //默认分桶
            String isCompareGroup = "0"; //默认分组
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000/(minRoi * defaultRoiFactor)));



            //步骤2 当前对象是否合法
            if (AssertUtil.isAllNotEmpty(adxDoInfo, adxRoiControlDoInfo)) {

                //默认出价（分/cpm）
                Long defaultPrice = adxRoiControlDoInfo.getDefaultPrice();
                //全天累计：分策略-分level-分指标-值
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                //历史30min：分策略-分level-分指标-值
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();







                if (adxRoiControlDoInfo.getMinRoi() != null && adxRoiControlDoInfo.getMinRoi() > 1.0) {
                    minRoi = adxRoiControlDoInfo.getMinRoi();
                }

                if (adxRoiControlDoInfo.getBasePrice() != null && adxRoiControlDoInfo.getBasePrice() > 0.0) {
                    adxAlgoPrice = DataUtil.double2Long(adxRoiControlDoInfo.getBasePrice());
                }


                if (AssertUtil.isAllNotEmpty(defaultPrice)){
//
//
//
//
//                    /**
//                     * 解决创意冷启动问题（1：当天广告消耗<1500,对照组；0：当天广告消耗>=1500,实验组）
//                     */
//                    Long expStatAllDayAdvertFee =
//                            nullToDefaultAdvertValue(adxRoiControlDoInfo.getExpStatAllDayAdvertFee(),0L);
//                    Long comStatAllDayAdvertFee =
//                            nullToDefaultAdvertValue(adxRoiControlDoInfo.getComStatAllDayAdvertFee(),0L);
//
//                    if (expStatAllDayAdvertFee + comStatAllDayAdvertFee < advertFeesDayLimit) {
//                        isCompareGroup = "1";
//                    }
//
//
//                    /**
//                     * 实时消耗异常补救（1：实时广告消耗<500,对照组；0：实时广告消耗>=500,实验组）
//                     */
//                    Long expStatAdvertFee =
//                            addAllBucketMap(adxRoiControlDoInfo.getExpStatBucketAdvertFee(),0L);
//                    Long comStatAdvertFee =
//                            addAllBucketMap(adxRoiControlDoInfo.getComStatBucketAdvertFee(),0L);
//
//                    if (expStatAdvertFee + comStatAdvertFee < advertFeesLimit) {
//                        isCompareGroup = "1";
//                    }
//
//
//                    /**
//                     * 算法最终出价（对照组；返回默认出价：实验组：根据ROI调节因子，返回算法出价）
//                     */
//                    Double roiFactor = defaultRoiFactor;
//                    if (adxRoiFactor != null){
//                        roiFactor = adxRoiFactor.get(adxValueLevel);
//                    }
//
//                    if (roiFactor == null) {
//                        roiFactor = defaultRoiFactor;
//                    } else if (roiFactor < roiFactorLowerLimit) {
//                        roiFactor = roiFactorLowerLimit;
//                    } else if (roiFactor > roiFactorUpperLimit) {
//                        roiFactor = roiFactorUpperLimit;
//                    }
//                    //System.out.println("roiFactor:" + JSON.toJSONString(roiFactor));
//
//
//                    adxAlgoPrice = adxRoiControlDoInfo.getDefaultPrice();
//                    if (isCompareGroup.equals("0")){
//                        adxAlgoPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
//                    }
//
                }
            }

            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("level",level);
            retMap.put("adxAlgoPrice", DataUtil.Long2String(adxAlgoPrice));

        } catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }

        return retMap;
    }







    /**
     * 广告消耗缺失情况，默认重置为defaultValue
     *
     * @param value（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Long nullToDefaultAdvertValue(Long value, Long defaultValue) {

        Long ret = defaultValue;
        if (value != null && value > 0L) {
            ret = value;
        }
        return ret;
    }


    /**
     * 合计分桶广告消耗
     *
     * @param valueMap（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Long addAllBucketMap(Map<String, Long> valueMap, Long defaultValue) {

        Long ret = 0L;
        for (int i = 0; i < ADX_LEVEL.length; i++) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                ret += defaultValue;
            } else {
                ret += valueMap.get(ADX_LEVEL[i]);
            }
        }
        return ret;
    }




    //单元测试
    public static void main(String[] args){

        try {

            Map<String, Long> advert1 = new HashMap<>();
            advert1.put("1", 5L);
            advert1.put("2", null);
            advert1.put("3", 573L);
            advert1.put("4", 2L);
            //System.out.println("level:" + addAllBucketMap(advert1,0L));

            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setCurrentPreValue(0.083);
            adxDoInfo1.setStatCtr(0.063486);
            adxDoInfo1.setStatClickValue(20.050279);
            adxDoInfo1.setMinRoi(1.2);

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setMinPrice(1201L);
            adxRoiControlDoInfo1.setMinSuccessPrice(1300L);
            adxRoiControlDoInfo1.setDefaultPrice(1401L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(1899L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(5L);
            adxRoiControlDoInfo1.setExpStatBucketAdvertFee(advert1);
            adxRoiControlDoInfo1.setComStatBucketAdvertFee(null);

            Map<String, Double> adxRoiFactor1 = new HashMap<>();
            adxRoiFactor1.put("1",0.7);
            adxRoiFactor1.put("2",1.0);
            adxRoiFactor1.put("3",0.7);
            adxRoiFactor1.put("4",1.05);

            //Map<String, String> ret1 = AdxAlgoBidding.getAdxAlgoPrice(adxDoInfo1,adxRoiControlDoInfo1,adxRoiFactor1);
            //System.out.println("ret:" + JSON.toJSONString(ret1));

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
