package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.util.resources.ga.LocaleNames_ga;

import java.util.HashMap;
import java.util.Map;


public class AdxAlgoBiddingOld {


    /**
     * 流量分桶Key
     */
    public static String[] adxPricelevel = {"1", "2", "3", "4"};


    /**
     * 流量按价值分桶，流量分组，算法最终出价
     *
     * @param adxDoInfo 人工设置和统计数据
     * @param adxRoiControlDoInfo 人工设置和统计数据
     * @param adxRoiFactor ROI调节因子
     * @return adxPriceLevel, isCompareGroup, adxAlgoPrice（分/千次曝光)
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo,
                                                      AdxRoiControlDo adxRoiControlDoInfo,
                                                      Map<String, Double> adxRoiFactor) {

        Map<String, String> retMap = new HashMap<>();

        try {

            //设置默认值
            String adxValueLevel = "1"; //默认分桶
            String isCompareGroup = "0"; //默认分组

            Double defaultPreCtr  = 0.07; //默认ctr
            Double defaultStatClickValue = 0.10*100; //默认点击价值
            Double defaultMinRoi = 1.00; //默认最低ROI
            Double defaultRoiFactor = 1.00; //默认ROI调节因子
            Double roiFactorLowerLimit = 0.70; //ROI调节因子下限
            Double roiFactorUpperLimit = 1.30; //ROI调节因子上限
            Long advertFeesDayLimit = 15*100L; //当天广告消耗阈值（分）
            Long advertFeesLimit = 5*100L; //实时广告消耗阈值（分）

            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000/(defaultMinRoi * defaultRoiFactor)));



            if (AssertUtil.isAllNotEmpty(adxDoInfo, adxRoiControlDoInfo)) {

                Double defaultPrice = DataUtil.toDouble(adxRoiControlDoInfo.getDefaultPrice()); //人工设置-默认出价（分/千次曝光）
                Double minPrice = DataUtil.toDouble(adxRoiControlDoInfo.getMinPrice()); //人工设置-最低出价（分/千次曝光）
                Double maxPrice = DataUtil.toDouble(adxRoiControlDoInfo.getMaxPrice()); //人工设置-最高出价（分/千次曝光）


                if (AssertUtil.isAllNotEmpty(defaultPrice, minPrice, maxPrice)){

                    /**
                     * 流量分桶（按流量价值）
                     */
                    Double[] adxValueBucket = {minPrice, defaultPrice, maxPrice}; //分桶区间
                    //System.out.println("adxValueBucket:" + JSON.toJSONString(adxValueBucket));
                    Double adxPrice = DataUtil.toDouble(AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor));//预估出价（分/千次曝光）

                    Double minRoi = adxDoInfo.getMinRoi();
                    if (minRoi == null || minRoi < 1.00) {
                        minRoi = defaultMinRoi;
                    }
                    Double adxValue = adxPrice * minRoi;//预估价值（分/千次曝光）
                    adxValueLevel = bucket(adxValue, adxValueBucket); //分桶标记


                    /**
                     * 解决创意冷启动问题（1：当天广告消耗<1500,对照组；0：当天广告消耗>=1500,实验组）
                     */
                    Long expStatAllDayAdvertFee =
                            nullToDefaultAdvertValue(adxRoiControlDoInfo.getExpStatAllDayAdvertFee(),0L);
                    Long comStatAllDayAdvertFee =
                            nullToDefaultAdvertValue(adxRoiControlDoInfo.getComStatAllDayAdvertFee(),0L);

                    if (expStatAllDayAdvertFee + comStatAllDayAdvertFee < advertFeesDayLimit) {
                        isCompareGroup = "1";
                    }


                    /**
                     * 实时消耗异常补救（1：实时广告消耗<500,对照组；0：实时广告消耗>=500,实验组）
                     */
                    Long expStatAdvertFee =
                            addAllBucketMap(adxRoiControlDoInfo.getExpStatBucketAdvertFee(),0L);
                    Long comStatAdvertFee =
                            addAllBucketMap(adxRoiControlDoInfo.getComStatBucketAdvertFee(),0L);

                    if (expStatAdvertFee + comStatAdvertFee < advertFeesLimit) {
                        isCompareGroup = "1";
                    }


                    /**
                     * 算法最终出价（对照组；返回默认出价：实验组：根据ROI调节因子，返回算法出价）
                     */
                    Double roiFactor = defaultRoiFactor;
                    if (adxRoiFactor != null){
                        roiFactor = adxRoiFactor.get(adxValueLevel);
                    }

                    if (roiFactor == null) {
                        roiFactor = defaultRoiFactor;
                    } else if (roiFactor < roiFactorLowerLimit) {
                        roiFactor = roiFactorLowerLimit;
                    } else if (roiFactor > roiFactorUpperLimit) {
                        roiFactor = roiFactorUpperLimit;
                    }
                    //System.out.println("roiFactor:" + JSON.toJSONString(roiFactor));


                    adxAlgoPrice = adxRoiControlDoInfo.getDefaultPrice();
                    if (isCompareGroup.equals("0")){
                        adxAlgoPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
                    }

                }
            }

            retMap.put("adxPriceLevel", adxValueLevel);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String(adxAlgoPrice));


        } catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }

        return retMap;
    }




    /**
     * 分桶函数
     * <p>
     * 左开右闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return 分桶值
     */
    public static String bucket(Double value, Double[] bucketList) {
        int ret = 1;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }

        }
        return adxPricelevel[ret - 1];
    }


    /**
     * 广告消耗缺失情况，默认重置为defaultValue
     *
     * @param value（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Long nullToDefaultAdvertValue(Long value, Long defaultValue) {

        Long ret = defaultValue;
        if (value != null && value > 0L) {
            ret = value;
        }
        return ret;
    }


    /**
     * 合计分桶广告消耗
     *
     * @param valueMap（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Long addAllBucketMap(Map<String, Long> valueMap, Long defaultValue) {

        Long ret = 0L;
        for (int i = 0; i < adxPricelevel.length; i++) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(adxPricelevel[i]) == null || valueMap.get(adxPricelevel[i]) < 0L) {
                ret += defaultValue;
            } else {
                ret += valueMap.get(adxPricelevel[i]);
            }
        }
        return ret;
    }




    //单元测试
    public static void main(String[] args){

        try {

            Double value1 = 5000.0;
            Double[] list1 = {1000.0, 1400.0, 2400.0};
            String level1 = bucket(value1, list1);
            //System.out.println("level:" + level1);

            Map<String, Long> advert1 = new HashMap<>();
            advert1.put("1", 5L);
            advert1.put("2", null);
            advert1.put("3", 573L);
            advert1.put("4", 2L);
            //System.out.println("level:" + addAllBucketMap(advert1,0L));

            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setCurrentPreValue(0.083);
            adxDoInfo1.setStatCtr(0.063486);
            adxDoInfo1.setStatClickValue(20.050279);
            adxDoInfo1.setMinRoi(1.2);

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setMinPrice(1201L);
            adxRoiControlDoInfo1.setMinSuccessPrice(1300L);
            adxRoiControlDoInfo1.setDefaultPrice(1401L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(1899L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(5L);
            adxRoiControlDoInfo1.setExpStatBucketAdvertFee(advert1);
            adxRoiControlDoInfo1.setComStatBucketAdvertFee(null);

            Map<String, Double> adxRoiFactor1 = new HashMap<>();
            adxRoiFactor1.put("1",0.7);
            adxRoiFactor1.put("2",1.0);
            adxRoiFactor1.put("3",0.7);
            adxRoiFactor1.put("4",1.05);

            Map<String, String> ret1 = AdxAlgoBiddingOld.getAdxAlgoPrice(adxDoInfo1,adxRoiControlDoInfo1,adxRoiFactor1);
            System.out.println("ret:" + JSON.toJSONString(ret1));

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
