package cn.com.duiba.nezha.alg.alg.adx;

import com.alibaba.fastjson.JSON;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;

public class AdxBidding {

    /**
     * ADX出价
     *
     * @param adxDoInfo  统计数据 & 模型数据
     * @return (adx标准出价:分/cpm)
     */

    public static Long getAdxParPrice(AdxDo adxDoInfo, Double adxBiddingRoiFactor) {


        //设置默认值
        Double defaultMinRoi = 1.00;              // 默认ROI
        Double defaultRoiFactor = 1.00;           // 默认ROI调节因子
        Double roiFactorLowerLimit = 0.70;        // ROI调节因子下限
        Double roiFactorUpperLimit = 1.40;        // ROI调节因子上限
        Double defaultPreCtr  = 0.07;             // 默认ctr
        Double defaultStatClickValue = 0.10*100;  // 默认点击价值



        if (adxBiddingRoiFactor == null) {
            adxBiddingRoiFactor = defaultRoiFactor;
        } else if (adxBiddingRoiFactor < roiFactorLowerLimit ) {
            adxBiddingRoiFactor = roiFactorLowerLimit;
        } else if (adxBiddingRoiFactor > roiFactorUpperLimit) {
            adxBiddingRoiFactor = roiFactorUpperLimit;
        }

        Long parPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000/(defaultMinRoi * adxBiddingRoiFactor)));


        if (AssertUtil.isNotEmpty(adxDoInfo)){

            Double minRoi = adxDoInfo.getMinRoi();                                 //最低minRoi(小数，如1.50)
            Double statCtr = adxDoInfo.getStatCtr();                               //统计ctr-创意纬度
            Double statCtrResource = adxDoInfo.getStatCtrResource();               //统计ctr-资源位维度
            Double currentPreValue = adxDoInfo.getCurrentPreValue();               //模型ctr-创意纬度
            Double statClickValue = adxDoInfo.getStatClickValue();                 //统计点击价值-创意纬度(分/单次点击)
            Double statClickValueResource = adxDoInfo.getStatClickValueResource(); //统计点击价值-资源位维度(分/单次点击)

            // 最低ROI默认值
            if (minRoi == null || minRoi < 1.00) {
                minRoi = defaultMinRoi;
            }

            //预估ctr
            Double preCtr = getPreCtr(statCtr, statCtrResource, currentPreValue);
            if (preCtr == null || preCtr <= 0.00 || preCtr > 1.00) {
                preCtr = defaultPreCtr;
            }


            // 预估点击价值
            Double preClickValue =
                    getReduceValue(statClickValue, statClickValueResource, defaultStatClickValue,100.0*100,0.00 );
            if (statClickValue == null || statClickValue <= 0.00) {
                statClickValue = defaultStatClickValue;
            }



            //adx标准出价 = 预估的收益回报/（最低ROI*最低ROI调节因子）*1000
            parPrice = Math.round(Math.floor(preCtr * statClickValue * 1000/(minRoi * adxBiddingRoiFactor)));

        }
        return parPrice;
    }




    /**
     * 降级预估
     *
     * @param value1  原始维度
     * @param value2  降级维度
     * @return 降级预估值
     */
    public static Double getReduceValue( Double value1,
                                         Double value2,
                                         Double defValue,
                                         Double uppLimit,
                                         Double lowLimit) {

        Double ret = defValue;
        if (value2 != null && value2 > lowLimit && value2 <= uppLimit){
            ret = value2;
        }

        if(value1 != null && value1 > lowLimit && value1 <= uppLimit){
            ret = value1;
        }

        return ret;
    }




    /**
     * 预估CTR
     *
     * @param statValue          统计ctr-创意维度
     * @param statValueResource  统计ctr-资源位维度
     * @param modelPreValue      模型ctr-创意维度
     * @return 预估ctr
     */
    public static Double getPreCtr(Double statValue, Double statValueResource, Double modelPreValue) {

        //设置ctr默认值
        Double ret = 0.07;

        Double preCtrFactor = 0.00; // 预估CTR调节因子
        Double vUpperLimit = 0.9999; // 点击率上限
        Double vLowerLimit = 0.0000; // 点击率下限
        Double fUpperLimit = 3.00; // 比例上限
        Double fLowerLimit = 0.20; // 比例下限

        // 统计CTR默认值
        if (statValue == null || statValue < vLowerLimit || statValue > vUpperLimit) {
            statValue = ret;
        }

        // 模型CTR默认值
        if (modelPreValue == null || modelPreValue < vLowerLimit || modelPreValue > vUpperLimit) {
            ret = statValue;

        } else{

            // 融合CTR
            if (modelPreValue/statValue > fLowerLimit && modelPreValue/statValue < fUpperLimit){
                ret = preCtrFactor * modelPreValue + (1 - preCtrFactor) * statValue;
            } else {
                ret = statValue;
            }

        }

        return ret;
    }







    //单元测试
    public static void main(String[] args) {

        try {

            AdxDo adxDoInfo = new AdxDo();
            adxDoInfo.setCurrentPreValue(null);
            adxDoInfo.setStatCtr(0.00);
            adxDoInfo.setStatClickValue(0.00);
            adxDoInfo.setMinRoi(0.00);
            Double roiFactor=0.00;

            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);

            System.out.println("testGetAdxParPrice:" + JSON.toJSONString(testParPrice));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
