package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxDimension;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;


public class AdxRoiFactor {


    /**
     * 指标Key
     */
    public static String[] ADX_LEVEL = AdxDimension.ADX_LEVEL;




    /**
     * ROI调节因子(根据缓存数据，调用频率：1min调用1次)
     *
     * @param adxRoiControlDoInfo 人工设置，统计数据，上一次缓存数据
     * @return ROI调节因子（小数，如1.50)
     */

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {

        AdxRoiFactorDo ret = null;

//        Map<String, Double> tmpLastAdxRoiFactor = new HashMap<>();
//        if (AssertUtil.isNotEmpty(lastAdxRoiFactor)) {
//            JSONObject jb1 = JSONObject.parseObject(JSONObject.toJSONString(lastAdxRoiFactor));
//            for (String key : jb1.keySet()) {
//                tmpLastAdxRoiFactor.put(key, jb1.getDoubleValue(key));
//            }
//        }
//
//        //设置默认值
//        Double defaultMinRoi = 1.0; //默认最低ROI
//        Double defaultRoiFactor = 1.0; //默认ROI调节因子
//        Double[] roiFactorLowerLimit = {0.7, 0.7, 0.7, 0.7}; //ROI调节因子下限
//        Double[] roiFactorUpperLimit = {1.3, 1.3, 1.3, 1.3}; //ROI调节因子上限
//
//        Double alpha1 = 0.3; //分桶-历史30min调节率
//        Double alpha2 = 0.3; //全局-历史30min调节率
//        Double alpha3 = 0.3; //分桶-当天累计调节率
//        Double alpha4 = 0.3; //全局-当天累计调节率
//        Double w1 = 0.4; //分桶-历史30min调节比重
//        Double w2 = 0.3; //全局-历史30min调节比重
//        Double w3 = 0.2; //分桶-当天累计调节比重
//        Double w4 = 0.1; //全局-当天累计调节比重
//        Double[] step = {0.1, 0.1, 0.1, 0.1}; //步长
//        Double[] bucketDiffList = {0.2, 0.5, 0.8, 1.0}; //ROI偏差分桶值
//        Double backStep = 0.003; //步长
//
//
//        //lastAdxRoiFactor默认值
//        if (AssertUtil.isEmpty(tmpLastAdxRoiFactor)) {
//
//            for (int i = 0; i < adxPricelevel.length; i++) {
//                tmpLastAdxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
//            }
//
//        } else {
//
//            if (tmpLastAdxRoiFactor.get("5") != null) {
//                tmpLastAdxRoiFactor.remove("5");
//            }
//
//            for (int i = 0; i < adxPricelevel.length; i++) {
//                if (tmpLastAdxRoiFactor.get(adxPricelevel[i]) == null) {
//                    tmpLastAdxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
//                } else if (tmpLastAdxRoiFactor.get(adxPricelevel[i]) < roiFactorLowerLimit[i]) {
//                    tmpLastAdxRoiFactor.put(adxPricelevel[i], roiFactorLowerLimit[i]);
//                } else if (tmpLastAdxRoiFactor.get(adxPricelevel[i]) > roiFactorUpperLimit[i]) {
//                    tmpLastAdxRoiFactor.put(adxPricelevel[i], roiFactorUpperLimit[i]);
//                }
//            }
//
//        }
//
//
//        //minRoi默认值
//        if (minRoi == null || minRoi < 1.00) {
//            minRoi = defaultMinRoi;
//        }
//
//
//        //adxRoiFactor(重置；不更新；更新)
//        Map<String, Double> adxRoiFactor = new HashMap<>();
//
        Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));
//
//        //重置
//        if (currentTime == null || (currentTime >= 0L && currentTime < 1L)) {
//
//            for (int i = 0; i < adxPricelevel.length; i++) {
//                adxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
//            }
//
//        } else {
//
//            //不更新；更新
//            adxRoiFactor = tmpLastAdxRoiFactor;
//
//            if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {
//
//                //设置消耗默认值
//                Double defaultFee = 0.00;
//
//                //分桶-历史30min-adx消耗，广告消耗
//                Map<String, Double> expStatBucketAdxFee = nullToDefaultAdxValue(adxRoiControlDoInfo.getExpStatBucketAdxFee(), defaultFee); //实验组-分桶-历史30min-adx消耗（分）
//                Map<String, Double> expStatBucketAdvertFee = nullToDefaultAdvertValue(adxRoiControlDoInfo.getExpStatBucketAdvertFee(), defaultFee); //实验组-分桶-历史30min-广告消耗（分）
//                Map<String, Double> comStatBucketAdxFee = nullToDefaultAdxValue(adxRoiControlDoInfo.getComStatBucketAdxFee(), defaultFee); //对照组-分桶-历史30min-adx消耗（分）
//                Map<String, Double> comStatBucketAdvertFee = nullToDefaultAdvertValue(adxRoiControlDoInfo.getComStatBucketAdvertFee(), defaultFee); //对照组-分桶-历史30min-广告消耗（分）
//
//                //全局-历史30min-adx消耗，广告消耗
//                Double expStatAllAdxFee = addAllBucketAdxMap(adxRoiControlDoInfo.getExpStatBucketAdxFee(), defaultFee); //实验组-全局-历史30min-adx消耗（分）
//                Double expStatAllAdvertFee = addAllBucketAdvertMap(adxRoiControlDoInfo.getExpStatBucketAdvertFee(), defaultFee); //实验组-全局-历史30min-广告消耗（分）
//                Double comStatAllAdxFee = addAllBucketAdxMap(adxRoiControlDoInfo.getComStatBucketAdxFee(), defaultFee); //对照组-全局-历史30min-adx消耗（分）
//                Double comStatAllAdvertFee = addAllBucketAdvertMap(adxRoiControlDoInfo.getComStatBucketAdvertFee(), defaultFee); //对照组-全局-历史30min-广告消耗（分）
//
//                //分桶-当天累计-adx消耗，广告消耗
//                Map<String, Double> expStatBucketDayAdxFee = nullToDefaultAdxValue(adxRoiControlDoInfo.getExpStatBucketDayAdxFee(), defaultFee); //实验组-分桶-当天累计-adx消耗（分）
//                Map<String, Double> expStatBucketDayAdvertFee = nullToDefaultAdvertValue(adxRoiControlDoInfo.getExpStatBucketDayAdvertFee(), defaultFee); //实验组-分桶-当天累计-广告消耗（分）
//                Map<String, Double> comStatBucketDayAdxFee = nullToDefaultAdxValue(adxRoiControlDoInfo.getComStatBucketDayAdxFee(), defaultFee); //对照组-分桶-当天累计-adx消耗（分）
//                Map<String, Double> comStatBucketDayAdvertFee = nullToDefaultAdvertValue(adxRoiControlDoInfo.getComStatBucketDayAdvertFee(), defaultFee); //对照组-分桶-当天累计-广告消耗（分）
//
//                //全局-当天累计-adx消耗，广告消耗
//                Double expStatAllDayAdxFee = nullToDefaultAdxValue(adxRoiControlDoInfo.getExpStatAllDayAdxFee(), defaultFee); //实验组-全局-当天累计-adx消耗（分）
//                Double expStatAllDayAdvertFee = nullToDefaultAdvertValue(adxRoiControlDoInfo.getExpStatAllDayAdvertFee(), defaultFee); //实验组-全局-当天累计-广告消耗（分）
//                Double comStatAllDayAdxFee = nullToDefaultAdxValue(adxRoiControlDoInfo.getComStatAllDayAdxFee(), defaultFee); //对照组-全局-当天累计-adx消耗（分）
//                Double comStatAllDayAdvertFee = nullToDefaultAdvertValue(adxRoiControlDoInfo.getComStatAllDayAdvertFee(), defaultFee); //对照组-全局-当天累计-广告消耗（分）
//
//
//                //实际ROI：分桶-历史30min
//                Map<String, Double> statBucketRoi =
//                        calculateMap(expStatBucketAdxFee, comStatBucketAdxFee, expStatBucketAdvertFee, comStatBucketAdvertFee); //分桶-历史30min-实验组ROI
//
//                //实际ROI：全局-历史30min
//                Double statAllRoi =
//                        DataUtil.division(expStatAllAdvertFee + comStatAllAdvertFee , expStatAllAdxFee + comStatAllAdxFee, 6); //分桶-历史30min-实验组ROI
//
//                //实际ROI：分桶-当天累计
//                Map<String, Double> statBucketDayRoi =
//                        calculateMap(expStatBucketDayAdxFee, comStatBucketDayAdxFee, expStatBucketDayAdvertFee, comStatBucketDayAdvertFee); //分桶-当天累计-实验组ROI
//
//                //实际ROI：全局-当天累计
//                Double statAllDayRoi =
//                        DataUtil.division(expStatAllDayAdvertFee + comStatAllDayAdvertFee, expStatAllDayAdxFee + comStatAllDayAdxFee, 6); //全局-当天累计-实验组ROI
//
//                //System.out.println("statBucketRoi:" + JSON.toJSONString(statBucketRoi));
//                //System.out.println("statAllRoi:" + JSON.toJSONString(statAllRoi));
//                //System.out.println("statBucketDayRoi:" + JSON.toJSONString(statBucketDayRoi));
//                //System.out.println("statAllDayRoi:" + JSON.toJSONString(statAllDayRoi));
//
//
//                //更新adxRoiFactor
//                for (int i = 0; i < adxPricelevel.length; i++) {
//                    String adxValueLevel = adxPricelevel[i];
//                    Double roiFactor = adxRoiFactor.get(adxValueLevel);
//
//                    //根据分桶-历史30min的roi调节
//                    Double roiFactor1 = roiFactor;
//                    Double diff1 = bucket(Math.abs(statBucketRoi.get(adxValueLevel) / minRoi - 1.00), bucketDiffList);
//
//                    //根据全局-历史30min的roi调节
//                    Double roiFactor2 = roiFactor;
//                    Double diff2 = bucket(Math.abs(statAllRoi / minRoi - 1.00), bucketDiffList);
//
//                    //根据分桶-当天累计的roi调节
//                    Double roiFactor3 = roiFactor;
//                    Double diff3 = bucket(Math.abs(statBucketDayRoi.get(adxValueLevel) / minRoi - 1.00), bucketDiffList);
//
//                    //根据全局-当天累计的roi调节
//                    Double roiFactor4 = roiFactor;
//                    Double diff4 = bucket(Math.abs(statAllDayRoi / minRoi - 1.00), bucketDiffList);
//
//
//                    if (expStatBucketAdxFee.get(adxValueLevel) + comStatBucketAdxFee.get(adxValueLevel) < 5.0 * 100){
//
//                        if (roiFactor1 > 1.00) {
//                            roiFactor1 += -backStep * diff1;
//                        } else if (roiFactor1 < 1.00) {
//                            roiFactor1 += backStep * diff1;
//                        }
//
//                    } else {
//
//                        if (statBucketRoi.get(adxValueLevel) < minRoi) {
//                            roiFactor1 += alpha1 * step[i] * diff1;
//                        } else if (statBucketRoi.get(adxValueLevel) > minRoi) {
//                            roiFactor1 += -alpha1 * step[i] * diff1;
//                        }
//
//                        if (expStatAllAdxFee + comStatAllAdxFee >= 5.0 * 100) {
//                            if (statAllRoi < minRoi) {
//                                roiFactor2 += alpha2 * step[i] * diff2;
//                            } else if (statAllRoi > minRoi) {
//                                roiFactor2 += -alpha2 * step[i] * diff2;
//                            }
//                        }
//
//                        if (expStatBucketDayAdxFee.get(adxValueLevel) + comStatBucketDayAdxFee.get(adxValueLevel) >= 10.0 * 100) {
//                            if (statBucketDayRoi.get(adxValueLevel) < minRoi) {
//                                roiFactor3 += alpha3 * step[i] * diff3;
//                            } else if (statBucketDayRoi.get(adxValueLevel) > minRoi) {
//                                roiFactor3 += -alpha3 * step[i] * diff3;
//                            }
//                        }
//
//                        if (expStatAllDayAdxFee + comStatAllDayAdxFee >= 10.0 * 100) {
//                            if (statAllDayRoi < minRoi) {
//                                roiFactor4 += alpha4 * step[i] * diff4;
//                            } else if (statAllDayRoi > minRoi) {
//                                roiFactor4 += -alpha4 * step[i] * diff4;
//                            }
//                        }
//
//                    }
//
//
//                    //融合调节
//                    roiFactor = DataUtil.formatDouble(w1 * roiFactor1 + w2 * roiFactor2 + w3 * roiFactor3 + w4 * roiFactor4,6);
//
//
//                    if (roiFactor < roiFactorLowerLimit[i]) {
//                        roiFactor = roiFactorLowerLimit[i];
//                    } else if (roiFactor > roiFactorUpperLimit[i]) {
//                        roiFactor = roiFactorUpperLimit[i];
//                    }
//
//                    adxRoiFactor.put(adxValueLevel, roiFactor);
//                }
//                //System.out.println("lastAdxRoiFactor:" + JSON.toJSONString(lastAdxRoiFactor));
//            }
//        }


        return ret;

    }


    /**
     * 分桶计算ROI
     *
     * @param expAdxFeeMap
     * @param comAdxFeeMap
     * @param expAdvertFeeMap
     * @param comAdvertFeeMap
     * @return 分桶ROI（小数，如1.10)
     */
    public static Map<String, Double> calculateMap(Map<String, Double> expAdxFeeMap,
                                                   Map<String, Double> comAdxFeeMap,
                                                   Map<String, Double> expAdvertFeeMap,
                                                   Map<String, Double> comAdvertFeeMap) {

        Map<String, Double> retMap = new HashMap<>();

        for (Map.Entry<String, Double> entry : expAdxFeeMap.entrySet()) {
            String key = entry.getKey();
            Double adx = expAdxFeeMap.get(key) + comAdxFeeMap.get(key);
            Double advert = expAdvertFeeMap.get(key) + comAdvertFeeMap.get(key);

            Double roi = DataUtil.division(advert, adx, 6);
            retMap.put(key, roi);
        }

        return retMap;
    }


    /**
     * adx消耗缺失情况，默认重置为defaultValue
     *
     * @param value（分*10^4/千次曝光）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Double nullToDefaultAdxValue(Long value, Double defaultValue) {

        Double ret = defaultValue;
        if (value != null && value > 0L) {
            ret = DataUtil.toDouble(value) / 10000 / 1000;
        }
        return ret;
    }


    /**
     * 广告消耗缺失情况，默认重置为defaultValue
     *
     * @param value（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Double nullToDefaultAdvertValue(Long value, Double defaultValue) {

        Double ret = defaultValue;
        if (value != null && value > 0L) {
            ret = DataUtil.toDouble(value);
        }
        return ret;
    }


    /**
     * adx消耗缺失情况，默认重置为defaultValue
     *
     * @param valueMap（分*10^4/千次曝光）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Map<String, Double> nullToDefaultAdxValue(Map<String, Long> valueMap, Double defaultValue) {

        Map<String, Double> retMap = new HashMap<>();
        for (int i = 0; i < ADX_LEVEL.length; i++) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                retMap.put(ADX_LEVEL[i], defaultValue);
            } else {
                retMap.put(ADX_LEVEL[i], DataUtil.toDouble(valueMap.get(ADX_LEVEL[i])) / 10000 / 1000);
            }
        }
        return retMap;
    }


    /**
     * 广告消耗缺失情况，默认重置为defaultValue
     *
     * @param valueMap（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Map<String, Double> nullToDefaultAdvertValue(Map<String, Long> valueMap, Double defaultValue) {

        Map<String, Double> retMap = new HashMap<>();
        for (int i = 0; i < ADX_LEVEL.length; i++) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                retMap.put(ADX_LEVEL[i], defaultValue);
            } else {
                retMap.put(ADX_LEVEL[i], DataUtil.toDouble(valueMap.get(ADX_LEVEL[i])));
            }
        }
        return retMap;
    }


    /**
     * 合计分桶adx消耗
     *
     * @param valueMap（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Double addAllBucketAdxMap(Map<String, Long> valueMap, Double defaultValue) {

        Double ret = defaultValue;
        for (int i = 0; i < ADX_LEVEL.length; i++) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                ret += defaultValue;
            } else {
                ret += DataUtil.toDouble(valueMap.get(ADX_LEVEL[i])) / 10000 / 1000;
            }
        }
        return ret;
    }


    /**
     * 合计分桶广告消耗
     *
     * @param valueMap（分）
     * @param defaultValue
     * @return 默认值（分）
     */
    public static Double addAllBucketAdvertMap(Map<String, Long> valueMap, Double defaultValue) {

        Double ret = defaultValue;
        for (int i = 0; i < ADX_LEVEL.length; i++) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(ADX_LEVEL[i]) == null || valueMap.get(ADX_LEVEL[i]) < 0L) {
                ret += defaultValue;
            } else {
                ret += DataUtil.toDouble(valueMap.get(ADX_LEVEL[i]));
            }
        }
        return ret;
    }


    /**
     * 分桶函数
     * <p>
     * 左开右闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return 分桶值
     */
    public static Double bucket(Double value, Double[] bucketList) {
        Double ret = 0.00;

        if (value != null && bucketList != null && bucketList.length > 0) {
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];
                if (value <= bound) {
                    ret = bound;
                    break;
                }
            }

            if(value > bucketList[bucketList.length - 1]){
                ret = bucketList[bucketList.length - 1];
            }
        }
        return ret;
    }


    //单元测试
    public static void main(String[] args) {

        try {
            Double[] v1 = {0.2, 0.5, 0.8, 1.0};
            //System.out.println("ret2:" + JSON.toJSONString(bucket(3.0,v1)));

            Map<String, Double> lastAdxRoiFactor1 = new HashMap<>();
            lastAdxRoiFactor1.put("1", 1.3);
            lastAdxRoiFactor1.put("2", 1.3);
            lastAdxRoiFactor1.put("3", 1.277543885714286);
            lastAdxRoiFactor1.put("4", 1.3);
            lastAdxRoiFactor1.put("5", null);

            Map<String, Long> adx1 = new HashMap<>();
            adx1.put("1", 1107503120000L);
            adx1.put("2", 24207390000L);
            adx1.put("3", 79705700000L);
            adx1.put("4", 41989670000L);

            Map<String, Long> advert1 = new HashMap<>();
            advert1.put("1", 107986L);
            advert1.put("2", 2516L);
            advert1.put("3", 13042L);
            advert1.put("4", 6205L);

            Map<String, Long> adx2 = new HashMap<>();
            adx2.put("1", 48730890000L);
            adx2.put("2", 2602280000L);
            adx2.put("3", 44230000L);
            adx2.put("4", 65470000L);

            Map<String, Long> advert2 = new HashMap<>();
            advert2.put("1", 6758L);
            advert2.put("2", 19L);
            advert2.put("3", 3L);
            advert2.put("4", 26L);

            Map<String, Long> comAdx1 = new HashMap<>();
            comAdx1.put("1", 11286750000L);
            comAdx1.put("2", 0L);
            comAdx1.put("3", 0L);
            comAdx1.put("4", 22580000L);

            Map<String, Long> comAdvert1 = new HashMap<>();
            comAdvert1.put("1", 1372L);
            comAdvert1.put("2", 0L);
            comAdvert1.put("3", 0L);
            comAdvert1.put("4", 0L);

            Map<String, Long> comAdx2 = new HashMap<>();
            comAdx2.put("1", 0L);
            comAdx2.put("2", 0L);
            comAdx2.put("3", 0L);
            comAdx2.put("4", 0L);

            Map<String, Long> comAdvert2 = new HashMap<>();
            comAdvert2.put("1", 7570000L);
            comAdvert2.put("2", 0L);
            comAdvert2.put("3", 0L);
            comAdvert2.put("4", 0L);

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setExpStatAllDayAdxFee(1253394870000L);
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(129749L);
            adxRoiControlDoInfo1.setExpStatBucketDayAdxFee(adx1);
            adxRoiControlDoInfo1.setExpStatBucketDayAdvertFee(advert1);
            adxRoiControlDoInfo1.setExpStatBucketAdxFee(adx2);
            adxRoiControlDoInfo1.setExpStatBucketAdvertFee(advert2);
            adxRoiControlDoInfo1.setComStatAllDayAdxFee(11309330000L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(1372L);
            adxRoiControlDoInfo1.setComStatBucketDayAdxFee(comAdx1);
            adxRoiControlDoInfo1.setComStatBucketDayAdvertFee(comAdvert1);
            adxRoiControlDoInfo1.setComStatBucketAdxFee(comAdx2);
            adxRoiControlDoInfo1.setComStatBucketAdvertFee(comAdvert2);

            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString(ret2));


        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
