package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;




public class AdxAlgoBidding {



    /**
     * 算法最终出价
     *
     * @param adxDoInfo
     * @param adxRoiControlDoInfo
     * @return isCompareGroup, level, adxAlgoPrice（分/千次曝光)
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo, AdxRoiControlDo adxRoiControlDoInfo) {

        Map<String, String> retMap = new HashMap<>();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、当前数据是否合法
         * 步骤4、计算累计消耗，实时消耗
         * 步骤5、冷启动：走默认出价
         * 步骤6、根据strategy走策略1,2,3
         *
         */


        try {

            //1、设置默认值
            Double defaultMinRoi = 1.00;              // 默认ROI
            Double defaultRoiFactor = 1.00;           // 默认ROI调节因子
            Double defaultPreCtr = 0.07;              // 默认ctr
            Double defaultStatClickValue = 0.10*100;  // 默认点击价值
            Long advertConsumeDayLimit = 10*100L;     // 创意当天广告消耗阈值（分）

            String isCompareGroup = "0";
            String level = AdxLevel.ADX_LEVEL_ZER.getCode();
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000/(defaultMinRoi * defaultRoiFactor)));



            //2、当前对象是否合法
            if (AssertUtil.isAllNotEmpty(adxDoInfo, adxRoiControlDoInfo)) {


                //3、当前数据是否合法

                //默认出价(分/cpm)
                Long defaultPrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(),100L);
                //底价(分/cpm)（默认出价-1分)
                Double basePrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getBasePrice(), (DataUtil.toDouble(defaultPrice)-1));

                //全天累计-不同策略：分level-分指标-值
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());


                //4、计算广告消耗
                Long defaultConsume = 0L;
                Long ideaAdvertConsumeMs = 0L;
                Long resoAdvertConsumeMs = 0L;
                Map<String, Long> advertConsumeInfo = new HashMap<>();
                Map<String, Long> ideaMapInfo = adxRoiControlDoInfo.getIdeaIndexMap();
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();

                Long ideaAdvertConsumeDay =
                          StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume)
                        + StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume)
                        + StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);

                if (AssertUtil.isNotEmpty(ideaMapInfo)) {
                    ideaAdvertConsumeMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()),defaultConsume);
                    resoAdvertConsumeMs = StrategyBid.nullToDefault(resoMapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()),defaultConsume);
                }

                advertConsumeInfo.put("ideaDay",ideaAdvertConsumeDay);     //创意维度-全天累计-广告消耗
                advertConsumeInfo.put("ideaMs", ideaAdvertConsumeMs);      //创意维度-历史30min-广告消耗
                advertConsumeInfo.put("resourceMs", resoAdvertConsumeMs);  //资源位维度-历史30min-广告消耗


                //5、冷启动：走默认出价
                if (ideaAdvertConsumeDay < advertConsumeDayLimit) {

                    isCompareGroup = "1";
                    level = AdxLevel.ADX_LEVEL_ZER.getCode();
                    adxAlgoPrice = defaultPrice;

                } else{

                    //步骤6、根据strategy走策略1,2,3
                    String strategy = adxRoiControlDoInfo.getStrategy();
                    AdxRoiFactorDo adxRoiFactor = adxRoiControlDoInfo.getAdxRoiFactorDo();
                    AdxPriceExplorationDo priceExploration = adxRoiControlDoInfo.getPriceExplorationDo();
                    AdxFactorExplorationDo factorExploration = adxRoiControlDoInfo.getFactorExplorationDo();

                    Map<String, String> result = StrategyBid.getStrategyFirBid(adxDoInfo, adxRoiFactor, advertConsumeInfo);

                    if (AdxStrategy.ADX_STRATEGY_SEC.getCode().equals(strategy)){
                        result = StrategyBid.getStrategySecBid(priceExploration, defaultPrice);

                    } else if (AdxStrategy.ADX_STRATEGY_THI.getCode().equals(strategy)){
                        result = StrategyBid.getStrategyThiBid(adxDoInfo, factorExploration, advertConsumeInfo);

                    }

                    isCompareGroup = "0";
                    level = result.get("level");
                    adxAlgoPrice = DataUtil.string2Long(result.get("price"));

                }

            }

            retMap.put("level", level);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String(adxAlgoPrice));


        } catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }

        return retMap;
    }






    //单元测试
    public static void main(String[] args){

        try {

            AdxDo adxDoInfo1 = new AdxDo();

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();



            Map<String, String> ret1 = AdxAlgoBidding.getAdxAlgoPrice(adxDoInfo1,adxRoiControlDoInfo1);
            System.out.println("ret:" + JSON.toJSONString(ret1));

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
