package cn.com.duiba.nezha.alg.alg.adx;

import com.alibaba.fastjson.JSON;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;

import java.util.HashMap;
import java.util.Map;



public class AdxBidding {

    /**
     * 出价
     *
     * @param adxDoInfo  统计数据 & 模型数据
     * @return (出价:分/cpm)
     */

    public static Long getAdxParPrice(AdxDo adxDoInfo,
                                      Double roiFactor,
                                      Map<String, Long> advertConsume) {


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、获取统计数据
         * 步骤4、ctr,点击价值(降级/融合)
         * 步骤5、计算出价
         *
         */


        //1、设置默认值
        Double defaultMinRoi = 1.0;              // 默认ROI
        Double defaultRoiFactor = 1.0;           // 默认ROI调节因子
        Double lowerLimit = 0.7;                 // ROI调节因子下限
        Double upperLimit = 1.4;                 // ROI调节因子上限
        Double defaultPreCtr  = 0.07;            // 默认ctr
        Double defaultClickValue = 0.1*100;      // 默认点击价值(分/单次点击)
        Long advertConsumeDayLimit = 10*100L;    // 创意当天广告消耗阈值（分）
        Long advertConsumeMsLimit = 5*100L;      // 创意实时广告消耗阈值（分）

        Long ret = Math.round(Math.floor(defaultPreCtr * defaultClickValue * 1000/(defaultMinRoi * defaultRoiFactor)));


        //2、当前对象是否合法
        if (AssertUtil.isNotEmpty(adxDoInfo)){

            //3、获取统计数据
            Double statCtr = adxDoInfo.getStatCtr();                               //统计ctr-创意纬度
            Double statCtrResource = adxDoInfo.getStatCtrResource();               //统计ctr-资源位维度
            Double currentPreValue = adxDoInfo.getCurrentPreValue();               //模型ctr-创意纬度
            Double statClickValue = adxDoInfo.getStatClickValue();                 //统计点击价值-创意纬度
            Double statClickValueResource = adxDoInfo.getStatClickValueResource(); //统计点击价值-资源位维度

            //4、ctr,点击价值(降级/融合)
            Double preCtr = statCtr;
            Double preClickValue = statClickValue;

            if (AssertUtil.isNotEmpty(advertConsume)) {
                //创意维度-全天累计-广告消耗
                Long ideaAdvertConsumeDay = StrategyBid.nullToDefault(advertConsume.get("ideaDay"), 0L);
                //创意维度-历史30min-广告消耗
                Long ideaAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("ideaMs"), 0L);
                //资源维度-历史30min-广告消耗
                Long resoAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("resourceMs"), 0L);

                if (ideaAdvertConsumeDay < advertConsumeDayLimit
                        || ideaAdvertConsumeMs < advertConsumeMsLimit
                        || ideaAdvertConsumeMs * 20L <= resoAdvertConsumeMs) {

                    preCtr = statCtrResource;
                    preClickValue = statClickValueResource;
                }
            }

            //融合ctr
            Double conCtr = getConCtr(preCtr, currentPreValue);

            //预估点击价值
            if (preClickValue == null || preClickValue <= 0.0) {
                preClickValue = defaultClickValue;
            }


            //5、计算出价 = 预估曝光价值 * 1000 /（设置ROI * ROI调节因子）
            roiFactor = StrategyBid.getNormalValue(roiFactor, defaultRoiFactor, lowerLimit, upperLimit);
            Double minRoi = StrategyBid.nullToDefault(adxDoInfo.getMinRoi(), defaultMinRoi);
            ret = Math.round(Math.floor(conCtr * preClickValue * 1000/(minRoi * roiFactor)));

        }

        return ret;
    }





    /**
     * 预估CTR
     *
     * @param statValue          统计ctr-创意维度
     * @param modelPreValue      模型ctr-创意维度
     * @return 融合ctr
     */
    public static Double getConCtr(Double statValue, Double modelPreValue) {

        Double defaultCtr = 0.07;     // ctr默认值
        Double preCtrFactor = 0.3;    // 预估CTR调节因子
        Double fUpperLimit = 3.0;     // 比例上限
        Double fLowerLimit = 0.2;     // 比例下限
        Double vUpperLimit = 0.9999;  // 点击率上限
        Double vLowerLimit = 0.0000;  // 点击率下限

        if (statValue == null || statValue < vLowerLimit || statValue > vUpperLimit) {
            statValue = defaultCtr;
        }

        Double ret = statValue;

        if (modelPreValue != null && modelPreValue >= vLowerLimit && modelPreValue <= vUpperLimit) {

            if (modelPreValue> fLowerLimit * statValue && modelPreValue < fUpperLimit * statValue) {
                ret = preCtrFactor * modelPreValue + (1 - preCtrFactor) * statValue;
            }
        }

        return ret;
    }







    //单元测试
    public static void main(String[] args) {

        try {

            Map<String, Long> advertConsumeInfo = new HashMap<>();
            advertConsumeInfo.put("ideaDay", 20*100L);
            advertConsumeInfo.put("ideaMs", 10*100L);
            advertConsumeInfo.put("resourceMs", 10*100L);

            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setMinRoi(null);
            adxDoInfo1.setCurrentPreValue(null);
            adxDoInfo1.setStatCtr(0.08);
            adxDoInfo1.setStatClickValue(0.1*100);
            adxDoInfo1.setStatCtrResource(null);
            adxDoInfo1.setStatClickValueResource(null);
            Double roiFactor = 2.0;

            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo1, roiFactor, advertConsumeInfo);

            System.out.println("testGetAdxParPrice:" + JSON.toJSONString(testParPrice));

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
