package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



public class AdxRoiFactor {



    /**
     * 策略1-ROI调节因子(根据缓存数据，调用频率：1min调用1次)
     *
     * @param adxRoiControlDoInfo 人工设置，统计数据，上一次缓存数据
     * @return ROI调节因子（小数，如1.50)
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {

        AdxRoiFactorDo ret = new AdxRoiFactorDo();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、获取上一次调节因子(初始值)
         * 步骤4、计算adx消耗、roi、竞价成功率
         * 步骤5、判断调节因子是否重置
         * 步骤6、判断调节因子是否回归
         * 步骤7、更新调节因子
         *
         */


        try {

            // 1、设置默认值
            Double defaultFactor = 1.0;                      // 默认ROI调节因子
            Double defaultMinRoi = 1.0;                      // 默认最低ROI
            Double lowerLimit = 0.70;                        // ROI调节因子下限
            Double upperLimit = 1.40;                        // ROI调节因子上限

            Double w1 = 0.8;                                 // 历史30min调节比重
            Double w2 = 0.2;                                 // 当天累计调节比重
            Double step1 = 0.03;                             // 历史30min调节步长
            Double step2 = 0.03;                             // 当天累计调节步长
            Double backStep = 0.003;                         // 回归步长

            Double[] bucketDiffList = {0.2, 0.5, 0.8, 1.0};  // ROI偏差分桶值
            Double adxConsumeMsLimit = 2.0 * 100;            // 策略实时adx消耗阈值（分）

            Double lastRoi = 0.0;                            // 默认上一次实际roi
            Double factor = defaultFactor;


            //2、当前对象是否合法
            if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {


                //3、获取上一次调节因子(初始值)
                AdxRoiFactorDo lastRoiFactor = adxRoiControlDoInfo.getLastAdxRoiFactorDo();
                if (AssertUtil.isNotEmpty(lastRoiFactor)) {
                    Double lastFactor = lastRoiFactor.getAdxRoiFactor();
                    factor = StrategyBid.getNormalValue(lastFactor, defaultFactor, lowerLimit, upperLimit);
                }


                //4、计算adx消耗、roi、竞价成功率
                //策略1-历史30min-ROI,竞价成功率,adx消耗
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                Double roiMs = StrategyBid.getRoi(strategyFirMs);
                Double sucRateMs = StrategyBid.getSucRate(strategyFirMs);
                Double adxConsumeMs = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume))/10000/1000;

                //策略1-全天累计-ROI,竞价成功率,adx消耗
                //ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                //List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                //Double roiDay = StrategyBid.getRoi(strategyFirDay);
                //Double sucRateDay = StrategyBid.getSucRate(strategyFirDay);
                //Double adxConsumeDay = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume))/10000/1000;

                //资源位维度-历史30min-ROI,竞价成功率
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }


                //5、判断调节因子是否重置
                //重置--人工设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:01:00
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));

                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || (currentTime >= 0L && currentTime < 1L)) {
                    factor = defaultFactor;

                } else {

                    Double diff = StrategyBid.bucket(Math.abs(roiMs / minRoi - 1.00), bucketDiffList);

                    //6、判断调节因子是否回归
                    if (adxConsumeMs < adxConsumeMsLimit || sucRateMs < resoSucRateMs * 0.5) {

                        if (factor > defaultFactor) {
                            factor += -backStep * diff;
                        } else if (factor < defaultFactor) {
                            factor += backStep * diff;
                        }

                    } else {

                        //7、更新调节因子
                        if (roiMs < minRoi && sucRateMs >= resoSucRateMs * 0.9) {
                            factor += step1 * diff;
                        } else if (roiMs > minRoi && sucRateMs < resoSucRateMs * 0.9) {
                            factor += -step1 * diff;
                        }
                    }
                }

                //更新上一次实际ROI
                lastRoi = roiMs;
            }

            //调节因子范围控制
            factor = StrategyBid.getNormalValue(factor, defaultFactor, lowerLimit, upperLimit);

            ret.setAdxRoiFactor(factor);
            ret.setLastRealRoi(lastRoi);

        } catch(Exception e){
            logger.error("AdxRoiFactor.getAdxRoiFactor error:" + e);
        }

        return ret;
    }





    //单元测试
    public static void main(String[] args) {

        try {

            Double[] v1 = {0.2, 0.5, 0.8, 1.0};
            //System.out.println("ret1:" + JSON.toJSONString(StrategyBid.bucket(3.0,v1)));

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();

            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString(ret2));


        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
