package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;



public class PriceExploration {



    /**
     * 策略2-价格试探（根据缓存数据，调用频率：5min调用1次）
     *
     * @param adxRoiControlDoInfo 人工设置，统计数据，上一次缓存数据
     * @return  价格试探表
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {

        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、计算adx消耗、roi、竞价成功率
         * 步骤4、获取上一次最优level作为基准值
         * 步骤5、判断基准价格是否重置
         * 步骤6、判断基准价格是否回归
         * 步骤7、调整基准流量比例
         * 步骤8、更新基准价格和基准流量比例
         *
         */



        try {


            // 1、设置默认值
            Double defaultPrice = 100.0;                              // 默认出价
            Double defaultMinRoi = 1.0;                               // 默认最低ROI

            Double backStep = 2.0;                                    // 回归步长
            Double stepFlow1 = 0.07;                                  // 流量调节步长1
            Double stepFlow2 = 0.03;                                  // 流量调节步长2
            Double[] stepList = {-10.0, -5.0, 0.00, 5.0, 10.0};       // 基准值调节步长
            Double[] bucketDiffList = {0.2, 0.5, 0.8, 1.0};           // ROI偏差分桶值
            Double adxConsumeMsLimit = 2.0 * 100;                     // 策略实时adx消耗阈值（分）


            Double baseValue = defaultPrice;                          // 基准值
            Double[] baseFlowRate = {0.05, 0.15, 0.60, 0.15, 0.05};   // 默认流量比例
            Double[] lastRealRoi = {0.0, 0.0, 0.0, 0.0, 0.0};         // 默认上一次实际roi

            Map<String, Long> priceMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> flowRateMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> lastRoiMap  = new HashMap<>((AdxLevel.values().length - 1));



            //2、当前对象是否合法
            if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {


                //3、计算adx消耗、roi、竞价成功率
                Long defaultConsume = 0L;
                //策略2-历史30min-ROI,竞价成功率,adx消耗
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());

                //策略2-分level-历史30min-ROI,竞价成功率,adx消耗(分*10000/cpm)
                Map<String, Double> roiLevelMs = StrategyBid.getLevelRoi(strategySecMs);
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);

                //策略2-历史30min-ROI,竞价成功率,adx消耗
                Double roiMs = StrategyBid.getRoi(strategySecMs);
                Double sucRateMs = StrategyBid.getSucRate(strategySecMs);
                Double adxConsumeMs = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume))/10000/1000;

                //资源位维度-历史30min-ROI,竞价成功率
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }


                //4、获取上一次最优level作为基准值
                //默认出价(分/cpm)(100分)
                defaultPrice = DataUtil.toDouble(StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(),100L));
                //出价下限(分/cpm)(50分)
                Double minPrice = DataUtil.toDouble(StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 50L));
                //出价上限(分/cpm)(默认出价+1分)
                Double maxPrice = DataUtil.toDouble(StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), ((DataUtil.double2Long(defaultPrice))+1L)));

                baseValue = defaultPrice;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                if (AssertUtil.isNotEmpty(lastPriceDoInfo)) {
                    String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                    Map<String, Long> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                    if (AssertUtil.isNotEmpty(lastPriceMap) && AssertUtil.isNotEmpty(lastPriceMap.get(bestLevel))) {
                        baseValue = DataUtil.toDouble(lastPriceMap.get(bestLevel));
                    }
                }



                //5、判断调节因子是否重置
                //重置--人工设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:05:00
                Double diff = StrategyBid.bucket(Math.abs(roiMs / minRoi - 1.00), bucketDiffList);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));

                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || (currentTime >= 0L && currentTime < 5L)) {
                    baseValue = defaultPrice;

                }else {


                    //6、判断基准值是否回归
                    if (adxConsumeMs < adxConsumeMsLimit || sucRateMs < resoSucRateMs * 0.5) {

                        if (baseValue > defaultPrice) {
                            baseValue += -backStep * diff;
                        } else if (baseValue < defaultPrice) {
                            baseValue += backStep * diff;
                        }
                    }
                }

                //7、调整基准流量比例
                if (roiMs > 0.0) {

                    if( roiMs > minRoi){
                        baseFlowRate[0] += -stepFlow2 * diff;
                        baseFlowRate[1] += -stepFlow1 * diff;
                        baseFlowRate[3] += stepFlow1 * diff;
                        baseFlowRate[4] += stepFlow2 * diff;

                    } else if (roiMs < minRoi){
                        baseFlowRate[0] += stepFlow2 * diff;
                        baseFlowRate[1] += stepFlow1 * diff;
                        baseFlowRate[3] += -stepFlow1 * diff;
                        baseFlowRate[4] += -stepFlow2 * diff;

                    }
                    baseFlowRate[2] = 1-baseFlowRate[0]-baseFlowRate[1]-baseFlowRate[3]-baseFlowRate[4];
                }



                //更新上一次实际ROI
                for (int i = 1; i < AdxLevel.values().length; i++) {
                    lastRealRoi[i-1] = roiLevelMs.get(DataUtil.Integer2String(i));
                }

                //基准价格范围控制
                baseValue = DataUtil.formatDouble(StrategyBid.getNormalValue(baseValue, defaultPrice, minPrice, maxPrice),6);

            }


            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (!key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) {
                    int i = DataUtil.toInt(DataUtil.string2Long(key));
                    Double price = baseValue + stepList[i - 1];
                    Double flowRate = baseFlowRate[i - 1];
                    Double lastRoi = lastRealRoi[i - 1];

                    priceMap.put(key, DataUtil.double2Long(price));
                    flowRateMap.put(key, flowRate);
                    lastRoiMap.put(key, lastRoi);
                }
            }

            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);



        } catch(Exception e){
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }

        return ret;
    }






    //单元测试
    public static void main(String[] args) {

        try {

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.20);
            adxRoiControlDoInfo1.setMinRoi(1.20);


            Map<String, Long> ideaIndexMap1 = new HashMap<>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800*10000*100L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);

            Map<String, Long> resourceIndexMap1 = new HashMap<>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800*10000*100L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);

            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);


            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString(ret2));


        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
