/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxAlgoBidding {
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo, AdxRoiControlDo adxRoiControlDoInfo) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            Double defaultMinRoi = 1.0;
            Double defaultRoiFactor = 1.0;
            Double defaultPreCtr = 0.07;
            Double defaultStatClickValue = 10.0;
            Long advertConsumeDayLimit = 1000L;
            String isCompareGroup = "0";
            String level = AdxLevel.ADX_LEVEL_ZER.getCode();
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000.0 / (defaultMinRoi * defaultRoiFactor)));
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxDoInfo, adxRoiControlDoInfo})) {
                Long defaultPrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 100L);
                Double basePrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getBasePrice(), DataUtil.toDouble((Long)defaultPrice) - 1.0);
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                List<AdxLevelDo> strategyThiDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                Long defaultConsume = 0L;
                Long ideaAdvertConsumeMs = 0L;
                Long resoAdvertConsumeMs = 0L;
                HashMap<String, Long> advertConsumeInfo = new HashMap<String, Long>();
                Map<String, Long> ideaMapInfo = adxRoiControlDoInfo.getIdeaIndexMap();
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                Long ideaAdvertConsumeDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume) + StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume) + StrategyBid.getSumLevelIndex(strategyThiDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                if (AssertUtil.isNotEmpty(ideaMapInfo)) {
                    ideaAdvertConsumeMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultConsume);
                    resoAdvertConsumeMs = StrategyBid.nullToDefault(resoMapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultConsume);
                }
                advertConsumeInfo.put("ideaDay", ideaAdvertConsumeDay);
                advertConsumeInfo.put("ideaMs", ideaAdvertConsumeMs);
                advertConsumeInfo.put("resourceMs", resoAdvertConsumeMs);
                if (ideaAdvertConsumeDay < advertConsumeDayLimit) {
                    isCompareGroup = "1";
                    level = AdxLevel.ADX_LEVEL_ZER.getCode();
                    adxAlgoPrice = defaultPrice;
                } else {
                    String strategy = adxRoiControlDoInfo.getStrategy();
                    AdxRoiFactorDo adxRoiFactor = adxRoiControlDoInfo.getAdxRoiFactorDo();
                    AdxPriceExplorationDo priceExploration = adxRoiControlDoInfo.getPriceExplorationDo();
                    AdxFactorExplorationDo factorExploration = adxRoiControlDoInfo.getFactorExplorationDo();
                    Map<String, String> result = StrategyBid.getStrategyFirBid(adxDoInfo, adxRoiFactor, advertConsumeInfo);
                    if (AdxStrategy.ADX_STRATEGY_SEC.equals(strategy)) {
                        result = StrategyBid.getStrategySecBid(priceExploration, defaultPrice);
                    } else if (AdxStrategy.ADX_STRATEGY_THI.equals(strategy)) {
                        result = StrategyBid.getStrategyThiBid(adxDoInfo, factorExploration, advertConsumeInfo);
                    }
                    isCompareGroup = "0";
                    level = result.get("level");
                    adxAlgoPrice = DataUtil.string2Long((String)result.get("price"));
                }
            }
            retMap.put("level", level);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String((Long)adxAlgoPrice));
        }
        catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }
        return retMap;
    }

    public static void main(String[] args) {
        try {
            AdxDo adxDoInfo1 = new AdxDo();
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            Map<String, String> ret1 = AdxAlgoBidding.getAdxAlgoPrice(adxDoInfo1, adxRoiControlDoInfo1);
            System.out.println("ret:" + JSON.toJSONString(ret1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

