/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxAlgoBidding;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxRoiFactorDo ret = new AdxRoiFactorDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.7;
            Double upperLimit = 1.4;
            Double w1 = 0.8;
            Double w2 = 0.2;
            Double step1 = 0.03;
            Double step2 = 0.03;
            Double backStep = 0.003;
            Double[] bucketDiffList = new Double[]{0.2, 0.5, 0.8, 1.0};
            Double adxConsumeMsLimit = 200.0;
            Double lastRoi = 0.0;
            Double factor = defaultFactor;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                AdxRoiFactorDo lastRoiFactor = adxRoiControlDoInfo.getLastAdxRoiFactorDo();
                if (AssertUtil.isNotEmpty((Object)lastRoiFactor)) {
                    Double lastFactor = lastRoiFactor.getAdxRoiFactor();
                    factor = StrategyBid.getNormalValue(lastFactor, defaultFactor, lowerLimit, upperLimit);
                }
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                Double roiMs = StrategyBid.getRoi(strategyFirMs);
                Double sucRateMs = StrategyBid.getSucRate(strategyFirMs);
                Double adxConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume)) / 10000.0 / 1000.0;
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi != lastMinRoi || currentTime == null || currentTime >= 0L && currentTime < 1L) {
                    factor = defaultFactor;
                } else {
                    Double diff = StrategyBid.bucket(Math.abs(roiMs / minRoi - 1.0), bucketDiffList);
                    if (adxConsumeMs < adxConsumeMsLimit || sucRateMs < resoSucRateMs * 0.5) {
                        if (factor > defaultFactor) {
                            factor = factor + -backStep.doubleValue() * diff;
                        } else if (factor < defaultFactor) {
                            factor = factor + backStep * diff;
                        }
                    } else if (roiMs < minRoi && sucRateMs >= resoSucRateMs * 0.9) {
                        factor = factor + step1 * diff;
                    } else if (roiMs > minRoi && sucRateMs < resoSucRateMs * 0.9) {
                        factor = factor + -step1.doubleValue() * diff;
                    }
                }
                lastRoi = roiMs;
            }
            factor = StrategyBid.getNormalValue(factor, defaultFactor, lowerLimit, upperLimit);
            ret.setAdxRoiFactor(factor);
            ret.setLastRealRoi(lastRoi);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.getAdxRoiFactor error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Double[] v1 = new Double[]{0.2, 0.5, 0.8, 1.0};
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

