/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class AdxBidding {
    public static Long getAdxParPrice(AdxDo adxDoInfo, Double roiFactor, Map<String, Long> advertConsume) {
        Double defaultMinRoi = 1.0;
        Double defaultRoiFactor = 1.0;
        Double lowerLimit = 0.7;
        Double upperLimit = 1.4;
        Double defaultPreCtr = 0.07;
        Double defaultClickValue = 10.0;
        Long advertConsumeDayLimit = 1000L;
        Long advertConsumeMsLimit = 500L;
        Long ret = Math.round(Math.floor(defaultPreCtr * defaultClickValue * 1000.0 / (defaultMinRoi * defaultRoiFactor)));
        if (AssertUtil.isNotEmpty((Object)adxDoInfo)) {
            Double statCtr = adxDoInfo.getStatCtr();
            Double statCtrResource = adxDoInfo.getStatCtrResource();
            Double currentPreValue = adxDoInfo.getCurrentPreValue();
            Double statClickValue = adxDoInfo.getStatClickValue();
            Double statClickValueResource = adxDoInfo.getStatClickValueResource();
            Double preCtr = statCtr;
            Double preClickValue = statClickValue;
            if (AssertUtil.isNotEmpty(advertConsume)) {
                Long ideaAdvertConsumeDay = StrategyBid.nullToDefault(advertConsume.get("ideaDay"), 0L);
                Long ideaAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("ideaMs"), 0L);
                Long resoAdvertConsumeMs = StrategyBid.nullToDefault(advertConsume.get("resourceMs"), 0L);
                if (ideaAdvertConsumeDay < advertConsumeDayLimit || ideaAdvertConsumeMs < advertConsumeMsLimit || ideaAdvertConsumeMs * 20L <= resoAdvertConsumeMs) {
                    preCtr = statCtrResource;
                    preClickValue = statClickValueResource;
                }
            }
            Double conCtr = AdxBidding.getConCtr(preCtr, currentPreValue);
            if (preClickValue == null || preClickValue <= 0.0) {
                preClickValue = defaultClickValue;
            }
            roiFactor = StrategyBid.getNormalValue(roiFactor, defaultRoiFactor, lowerLimit, upperLimit);
            Double minRoi = StrategyBid.nullToDefault(adxDoInfo.getMinRoi(), defaultMinRoi);
            ret = Math.round(Math.floor(conCtr * preClickValue * 1000.0 / (minRoi * roiFactor)));
        }
        return ret;
    }

    public static Double getConCtr(Double statValue, Double modelPreValue) {
        Double defaultCtr = 0.07;
        Double preCtrFactor = 0.3;
        Double fUpperLimit = 3.0;
        Double fLowerLimit = 0.2;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        if (statValue == null || statValue < vLowerLimit || statValue > vUpperLimit) {
            statValue = defaultCtr;
        }
        Double ret = statValue;
        if (modelPreValue != null && modelPreValue >= vLowerLimit && modelPreValue <= vUpperLimit && modelPreValue > fLowerLimit * statValue && modelPreValue < fUpperLimit * statValue) {
            ret = preCtrFactor * modelPreValue + (1.0 - preCtrFactor) * statValue;
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Long> advertConsumeInfo = new HashMap<String, Long>();
            advertConsumeInfo.put("ideaDay", 2000L);
            advertConsumeInfo.put("ideaMs", 1000L);
            advertConsumeInfo.put("resourceMs", 1000L);
            AdxDo adxDoInfo1 = new AdxDo();
            adxDoInfo1.setMinRoi(null);
            adxDoInfo1.setCurrentPreValue(null);
            adxDoInfo1.setStatCtr(0.08);
            adxDoInfo1.setStatClickValue(10.0);
            adxDoInfo1.setStatCtrResource(null);
            adxDoInfo1.setStatClickValueResource(null);
            Double roiFactor = 2.0;
            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo1, roiFactor, advertConsumeInfo);
            System.out.println("testGetAdxParPrice:" + JSON.toJSONString((Object)testParPrice));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

