/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxAlgoBidding;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactorExploration {
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxFactorExplorationDo getExploreFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFactorExplorationDo ret = new AdxFactorExplorationDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.7;
            Double upperLimit = 1.4;
            Double backStep = 0.003;
            Double stepFlow1 = 0.07;
            Double stepFlow2 = 0.03;
            Double[] stepList = new Double[]{-0.03, -0.01, 0.0, 0.01, 0.03};
            Double[] bucketDiffList = new Double[]{0.2, 0.5, 0.8, 1.0};
            Double adxConsumeMsLimit = 200.0;
            Double baseValue = defaultFactor;
            Double[] baseFlowRate = new Double[]{0.05, 0.15, 0.6, 0.15, 0.05};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            HashMap<String, Double> factorMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyThiMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_THI.getCode());
                Map<String, Double> roiLevelMs = StrategyBid.getLevelRoi(strategyThiMs);
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategyThiMs);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Double roiMs = StrategyBid.getRoi(strategyThiMs);
                Double sucRateMs = StrategyBid.getSucRate(strategyThiMs);
                Double adxConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyThiMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume)) / 10000.0 / 1000.0;
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                AdxFactorExplorationDo lastFactorDoInfo = adxRoiControlDoInfo.getLastFactorExplorationDo();
                if (AssertUtil.isNotEmpty((Object)lastFactorDoInfo)) {
                    String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                    Map<String, Double> lastFactorMap = lastFactorDoInfo.getFactorExploreMap();
                    if (AssertUtil.isNotEmpty(lastFactorMap) && AssertUtil.isNotEmpty((Object)lastFactorMap.get(bestLevel))) {
                        baseValue = lastFactorMap.get(bestLevel);
                    }
                }
                Double diff = StrategyBid.bucket(Math.abs(roiMs / minRoi - 1.0), bucketDiffList);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi != lastMinRoi || currentTime == null || currentTime >= 0L && currentTime < 1L) {
                    baseValue = defaultFactor;
                } else if (adxConsumeMs < adxConsumeMsLimit || sucRateMs < resoSucRateMs * 0.5) {
                    if (baseValue > defaultFactor) {
                        baseValue = baseValue + -backStep.doubleValue() * diff;
                    } else if (baseValue < defaultFactor) {
                        baseValue = baseValue + backStep * diff;
                    }
                }
                if (roiMs > 0.0) {
                    Double[] doubleArray;
                    if (roiMs > minRoi) {
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[0] + stepFlow2 * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[1] + stepFlow1 * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[3] + -stepFlow1.doubleValue() * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[4] + -stepFlow2.doubleValue() * diff);
                    } else if (roiMs < minRoi) {
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[0] + -stepFlow2.doubleValue() * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[1] + -stepFlow1.doubleValue() * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[3] + stepFlow1 * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[4] + stepFlow2 * diff);
                    }
                    baseFlowRate[2] = 1.0 - baseFlowRate[0] - baseFlowRate[1] - baseFlowRate[3] - baseFlowRate[4];
                }
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
            }
            baseValue = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue, defaultFactor, lowerLimit, upperLimit), (int)6);
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double factor = baseValue + stepList[i - 1];
                Double flowRate = baseFlowRate[i - 1];
                Double lastRoi = lastRealRoi[i - 1];
                factorMap.put(key, factor);
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
            }
            ret.setFactorExploreMap(factorMap);
            ret.setFactorFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
        }
        catch (Exception e) {
            logger.error("FactorExploration.getExploreFactor error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);
            AdxFactorExplorationDo ret2 = FactorExploration.getExploreFactor(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

