/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxAlgoBidding;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceExploration {
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();
        try {
            Double defaultPrice = 100.0;
            Double defaultMinRoi = 1.0;
            Double backStep = 2.0;
            Double stepFlow1 = 0.07;
            Double stepFlow2 = 0.03;
            Double[] stepList = new Double[]{-10.0, -5.0, 0.0, 5.0, 10.0};
            Double[] bucketDiffList = new Double[]{0.2, 0.5, 0.8, 1.0};
            Double adxConsumeMsLimit = 200.0;
            Double baseValue = defaultPrice;
            Double[] baseFlowRate = new Double[]{0.05, 0.15, 0.6, 0.15, 0.05};
            Double[] lastRealRoi = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            HashMap<String, Long> priceMap = new HashMap<String, Long>(AdxLevel.values().length - 1);
            HashMap<String, Double> flowRateMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            HashMap<String, Double> lastRoiMap = new HashMap<String, Double>(AdxLevel.values().length - 1);
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                Map<String, Double> roiLevelMs = StrategyBid.getLevelRoi(strategySecMs);
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Double roiMs = StrategyBid.getRoi(strategySecMs);
                Double sucRateMs = StrategyBid.getSucRate(strategySecMs);
                Double adxConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume)) / 10000.0 / 1000.0;
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();
                if (AssertUtil.isNotEmpty((Object)lastPriceDoInfo)) {
                    String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                    Map<String, Long> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                    if (AssertUtil.isNotEmpty(lastPriceMap) && AssertUtil.isNotEmpty((Object)lastPriceMap.get(bestLevel))) {
                        baseValue = DataUtil.toDouble((Long)lastPriceMap.get(bestLevel));
                    }
                }
                defaultPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 100L));
                Double basePrice = StrategyBid.nullToDefault(adxRoiControlDoInfo.getBasePrice(), defaultPrice - 1.0);
                Double minPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 100L));
                Double maxPrice = DataUtil.toDouble((Long)StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), 100L));
                Double diff = StrategyBid.bucket(Math.abs(roiMs / minRoi - 1.0), bucketDiffList);
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi != lastMinRoi || currentTime == null || currentTime >= 0L && currentTime < 5L) {
                    baseValue = defaultPrice;
                } else if (adxConsumeMs < adxConsumeMsLimit || sucRateMs < resoSucRateMs * 0.5) {
                    if (baseValue > defaultPrice) {
                        baseValue = baseValue + -backStep.doubleValue() * diff;
                    } else if (baseValue < defaultPrice) {
                        baseValue = baseValue + backStep * diff;
                    }
                }
                if (roiMs > 0.0) {
                    Double[] doubleArray;
                    if (roiMs > minRoi) {
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[0] + -stepFlow2.doubleValue() * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[1] + -stepFlow1.doubleValue() * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[3] + stepFlow1 * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[4] + stepFlow2 * diff);
                    } else if (roiMs < minRoi) {
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[0] + stepFlow2 * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[1] + stepFlow1 * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[3] + -stepFlow1.doubleValue() * diff);
                        doubleArray = baseFlowRate;
                        Double.valueOf(doubleArray[4] + -stepFlow2.doubleValue() * diff);
                    }
                    baseFlowRate[2] = 1.0 - baseFlowRate[0] - baseFlowRate[1] - baseFlowRate[3] - baseFlowRate[4];
                }
                for (int i = 1; i < AdxLevel.values().length; ++i) {
                    lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String((Integer)i));
                }
                baseValue = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(baseValue, defaultPrice, basePrice, maxPrice), (int)6);
            }
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                Double price = baseValue + stepList[i - 1];
                Double flowRate = baseFlowRate[i - 1];
                Double lastRoi = lastRealRoi[i - 1];
                priceMap.put(key, DataUtil.double2Long((Double)price));
                flowRateMap.put(key, flowRate);
                lastRoiMap.put(key, lastRoi);
            }
            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
        }
        catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setBasePrice(900.0);
            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo1);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

