/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxBidding;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxFactorExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxPriceExplorationDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StrategyBid {
    public static Map<String, String> getStrategyFirBid(AdxDo adxDoInfo, AdxRoiFactorDo adxRoiFactorDoInfo, Map<String, Long> advertConsumeInfo) {
        Double defaultRoiFactor = 1.0;
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_ZER.getCode();
        Long price = AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor, advertConsumeInfo);
        if (AssertUtil.isNotEmpty((Object)adxRoiFactorDoInfo)) {
            Double roiFactor = adxRoiFactorDoInfo.getAdxRoiFactor();
            price = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor, advertConsumeInfo);
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> getStrategySecBid(AdxPriceExplorationDo priceExplorationDoInfo, Long defaultPrice) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_THR.getCode();
        Long price = defaultPrice;
        if (AssertUtil.isNotEmpty((Object)priceExplorationDoInfo)) {
            Map<String, Long> priceMap = priceExplorationDoInfo.getPriceExploreMap();
            Map<String, Double> FlowRateMap = priceExplorationDoInfo.getPriceFlowRateMap();
            Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, priceMap, defaultPrice);
            level = result.get("level");
            price = DataUtil.string2Long((String)result.get("price"));
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> getStrategyThiBid(AdxDo adxDoInfo, AdxFactorExplorationDo factorExplorationDoInfo, Map<String, Long> advertConsumeInfo) {
        Double defaultRoiFactor = 1.0;
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_THR.getCode();
        Long price = AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor, advertConsumeInfo);
        if (AssertUtil.isNotEmpty((Object)factorExplorationDoInfo)) {
            Map<String, Double> factorMap = factorExplorationDoInfo.getFactorExploreMap();
            Map<String, Double> FlowRateMap = factorExplorationDoInfo.getFactorFlowRateMap();
            Map<String, String> result = StrategyBid.flowSplit(FlowRateMap, factorMap, defaultRoiFactor);
            level = result.get("level");
            Double roiFactor = DataUtil.string2Double((String)result.get("factor"));
            price = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor, advertConsumeInfo);
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> flowSplit(Map<String, Double> flowRateMap, Map<String, Long> priceMap, Long defaultValue) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_THR.getCode();
        Long price = defaultValue;
        Double sumRate = 0.0;
        List<Double> list = Arrays.asList(new Double[AdxLevel.values().length - 1]);
        ArrayList<Double> sumRateList = new ArrayList<Double>(list);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{flowRateMap, priceMap})) {
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                sumRate = sumRate + StrategyBid.nullToDefault(flowRateMap.get(key), 0.0);
                sumRateList.set(i - 1, sumRate);
            }
            double random = Math.random();
            for (int i = 0; i < sumRateList.size(); ++i) {
                double bound = (Double)sumRateList.get(i);
                if (!(random <= bound)) continue;
                level = DataUtil.Integer2String((Integer)(i + 1));
                price = priceMap.get(level);
                if (price != null) break;
                price = defaultValue;
                break;
            }
        }
        retMap.put("level", level);
        retMap.put("price", DataUtil.Long2String((Long)price));
        return retMap;
    }

    public static Map<String, String> flowSplit(Map<String, Double> flowRateMap, Map<String, Double> factorMap, Double defaultValue) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String level = AdxLevel.ADX_LEVEL_THR.getCode();
        Double factor = defaultValue;
        Double sumRate = 0.0;
        List<Double> list = Arrays.asList(new Double[AdxLevel.values().length - 1]);
        ArrayList<Double> sumRateList = new ArrayList<Double>(list);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{flowRateMap, factorMap})) {
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                int i = DataUtil.toInt((Long)DataUtil.string2Long((String)key));
                sumRate = sumRate + StrategyBid.nullToDefault(flowRateMap.get(key), 0.0);
                sumRateList.set(i - 1, sumRate);
            }
            double random = Math.random();
            for (int i = 0; i < sumRateList.size(); ++i) {
                double bound = (Double)sumRateList.get(i);
                if (!(random <= bound)) continue;
                level = DataUtil.Integer2String((Integer)(i + 1));
                factor = factorMap.get(level);
                if (factor != null) break;
                factor = defaultValue;
                break;
            }
        }
        retMap.put("level", level);
        retMap.put("factor", DataUtil.double2String((Double)factor));
        return retMap;
    }

    public static List<AdxLevelDo> getStrategyInfo(ArrayList<AdxStrategyDo> arrayListInfo, String strategyLabel) {
        List<AdxLevelDo> ret = new ArrayList<AdxLevelDo>();
        if (AssertUtil.isNotEmpty(arrayListInfo)) {
            for (int i = 0; i < AdxStrategy.values().length; ++i) {
                AdxStrategyDo ind = arrayListInfo.get(i);
                if (!strategyLabel.equals(ind.getStrategy())) continue;
                ret = ind.getLevelDoList();
            }
        }
        return ret;
    }

    public static Long getSumLevelIndex(List<AdxLevelDo> levelListInfo, String indexLabel, Long defaultValue) {
        Long ret = 0L;
        if (AssertUtil.isNotEmpty(levelListInfo)) {
            for (AdxLevelDo levelDo : levelListInfo) {
                if (AssertUtil.isNotEmpty((Object)levelDo)) {
                    Map<String, Long> valueMap = levelDo.getValueMap();
                    if (!AssertUtil.isNotEmpty(valueMap) || valueMap.get(indexLabel) == null || valueMap.get(indexLabel) < 0L) continue;
                    ret = ret + valueMap.get(indexLabel);
                    continue;
                }
                ret = ret + defaultValue;
            }
        }
        return ret;
    }

    public static Map<String, Long> getLevelIndex(List<AdxLevelDo> levelListInfo, String indexLabel, Long defaultValue) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        Long val = defaultValue;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            Map<String, Long> indMap;
            int i;
            AdxLevelDo ind;
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isNotEmpty(levelListInfo) && AssertUtil.isNotEmpty((Object)(ind = levelListInfo.get((i = DataUtil.toInt((Long)DataUtil.string2Long((String)key))) - 1))) && AssertUtil.isNotEmpty(indMap = ind.getValueMap()) && indMap.get(indexLabel) != null && indMap.get(indexLabel) >= 0L) {
                val = indMap.get(indexLabel);
            }
            retMap.put(key, val);
        }
        return retMap;
    }

    public static Double getSucRate(List<AdxLevelDo> levelListInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(levelListInfo)) {
            Long bidCnt = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.BID.getCode(), defaultValue);
            Long sucCnt = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.BID_SUC.getCode(), defaultValue);
            ret = DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
        }
        return ret;
    }

    public static Double getSucRate(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long bidCnt = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.BID.getCode()), defaultValue);
            Long sucCnt = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.BID_SUC.getCode()), defaultValue);
            ret = DataUtil.division((Long)sucCnt, (Long)bidCnt, (int)6);
        }
        return ret;
    }

    public static Map<String, Double> getLevelSucRate(List<AdxLevelDo> levelListInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long defaultValue = 0L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isNotEmpty(levelListInfo)) {
                Map<String, Long> bidCnt = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.BID.getCode(), defaultValue);
                Map<String, Long> sucCnt = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.BID_SUC.getCode(), defaultValue);
                Double ret = DataUtil.division((Long)sucCnt.get(key), (Long)bidCnt.get(key), (int)6);
                retMap.put(key, ret);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Double getRoi(List<AdxLevelDo> levelListInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(levelListInfo)) {
            Long adxConsume = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.ADX_CONSUME.getCode(), defaultValue);
            Long advertConsume = StrategyBid.getSumLevelIndex(levelListInfo, AdxIndex.ADVERT_CONSUME.getCode(), defaultValue);
            ret = DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)6) * 10000.0 * 1000.0;
        }
        return ret;
    }

    public static Double getRoi(Map<String, Long> mapInfo) {
        Double ret = 0.0;
        Long defaultValue = 0L;
        if (AssertUtil.isNotEmpty(mapInfo)) {
            Long adxConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADX_CONSUME.getCode()), defaultValue);
            Long advertConsume = StrategyBid.nullToDefault(mapInfo.get(AdxIndex.ADVERT_CONSUME.getCode()), defaultValue);
            ret = DataUtil.division((Long)advertConsume, (Long)adxConsume, (int)6) * 10000.0 * 1000.0;
        }
        return ret;
    }

    public static Map<String, Double> getLevelRoi(List<AdxLevelDo> levelListInfo) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        Long defaultValue = 0L;
        for (AdxLevel adxLevel : AdxLevel.values()) {
            String key = adxLevel.getCode();
            if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
            if (AssertUtil.isNotEmpty(levelListInfo)) {
                Map<String, Long> adxConsume = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.ADX_CONSUME.getCode(), defaultValue);
                Map<String, Long> advertConsume = StrategyBid.getLevelIndex(levelListInfo, AdxIndex.ADVERT_CONSUME.getCode(), defaultValue);
                Double ret = DataUtil.division((Long)advertConsume.get(key), (Long)adxConsume.get(key), (int)6) * 10000.0 * 1000.0;
                retMap.put(key, ret);
                continue;
            }
            retMap.put(key, 0.0);
        }
        return retMap;
    }

    public static Long nullToDefault(Long value, Long defaultValue) {
        Long ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double nullToDefault(Double value, Double defaultValue) {
        Double ret = defaultValue;
        if (value != null && value > defaultValue) {
            ret = value;
        }
        return ret;
    }

    public static Double getNormalValue(Double value, Double defaultValue, Double lower, Double upper) {
        Double ret = defaultValue;
        if (value != null) {
            ret = value < lower ? lower : (value > upper ? upper : value);
        }
        return ret;
    }

    public static Double bucket(Double value, Double[] bucketList) {
        Double ret = 0.0;
        if (value != null && bucketList != null && bucketList.length > 0) {
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i];
                if (!(value <= bound)) continue;
                ret = bound;
                break;
            }
            if (value > bucketList[bucketList.length - 1]) {
                ret = bucketList[bucketList.length - 1];
            }
        }
        return ret;
    }

    public static String selectBestLevel(Double minRoi, Map<String, Double> roiLevel, Map<String, Double> sucRateLevel) {
        String ret = AdxLevel.ADX_LEVEL_THR.getCode();
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{roiLevel, sucRateLevel})) {
            Double tmpRoi = roiLevel.get(ret);
            Double tmpSucRate = sucRateLevel.get(ret);
            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) continue;
                Double roi = roiLevel.get(key);
                Double sucRate = sucRateLevel.get(key);
                if (tmpRoi > minRoi * 0.9) {
                    if (roi > minRoi * 0.9 && sucRate > tmpSucRate) {
                        ret = key;
                    }
                } else if (roi > tmpRoi) {
                    ret = key;
                }
                if (!(roi > tmpRoi)) continue;
                tmpRoi = roi;
                tmpSucRate = sucRate;
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Double> roiLevel1 = new HashMap<String, Double>();
            roiLevel1.put("1", 0.95);
            roiLevel1.put("2", 1.05);
            roiLevel1.put("3", 1.1);
            roiLevel1.put("4", 1.02);
            roiLevel1.put("5", 1.11);
            HashMap<String, Double> sucRateLevel1 = new HashMap<String, Double>();
            sucRateLevel1.put("1", 0.75);
            sucRateLevel1.put("2", 0.5);
            sucRateLevel1.put("3", 0.86);
            sucRateLevel1.put("4", 0.8);
            sucRateLevel1.put("5", 0.61);
            System.out.println("selectBestLevel:" + JSON.toJSONString((Object)StrategyBid.selectBestLevel(1.1, null, null)));
            System.out.println("flowSplit:" + JSON.toJSONString(StrategyBid.flowSplit(null, null, 1.0)));
            System.out.println("getSumLevelIndex:" + JSON.toJSONString((Object)StrategyBid.getSumLevelIndex(null, null, 1L)));
            System.out.println("getLevelIndex:" + JSON.toJSONString(StrategyBid.getLevelIndex(null, null, 0L)));
            System.out.println("getLevelSucRate:" + JSON.toJSONString(StrategyBid.getLevelSucRate(null)));
            System.out.println("getLevelRoi:" + JSON.toJSONString(StrategyBid.getLevelRoi(null)));
            Double roiFactor = StrategyBid.getNormalValue(0.6, 1.0, 0.7, 1.4);
            System.out.println("getNormalValue:" + JSON.toJSONString((Object)roiFactor));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

