/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFlowRateDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowRate {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowRate.class);

    public static AdxFlowRateDo getAdxFlowRate(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFlowRateDo ret = new AdxFlowRateDo();
        try {
            Double defaultFlowRate = 0.33;
            Double FlowRateStep = 0.15;
            Double defaultMinRoi = 1.0;
            Double secFlowRate = defaultFlowRate;
            Double thiFlowRate = defaultFlowRate;
            Double firFlowRate = 1.0 - secFlowRate - thiFlowRate;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Long defaultConsume = 0L;
                Long defaultCnt = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                for (AdxStrategy strategy : AdxStrategy.values()) {
                    Map<String, Long> strategyStatMs = AdxStatData.getStrategyStatData(strategy.getCode(), strategyMsDoList);
                    Double roiMs = StrategyBid.getRoi(strategyStatMs, minRoi);
                    Double sucRateMs = StrategyBid.getSucRate(strategyStatMs);
                    Double d = (roiMs - minRoi) * sucRateMs;
                }
            }
            ret.setFirFlowRate(firFlowRate);
            ret.setFirFlowRate(secFlowRate);
            ret.setFirFlowRate(thiFlowRate);
        }
        catch (Exception e) {
            logger.error("AdxFlowRate.getAdxFlowRate error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            String str = "{\"adxRoiFactorDo\":{\"advertConsumeDay\":35375.0,\"advertConsumeMs\":291.0,\"adxConsumeDay\":24241.26,\"adxConsumeMs\":173.2,\"adxRoiFactor\":1.021343,\"bidCntDay\":347690,\"bidCntMs\":22924,\"lastRealRoi\":1.680149,\"roiDay\":1.45929,\"roiMs\":1.680149,\"sucBidCntDay\":116674,\"sucBidCntMs\":1946,\"sucDay\":0.33557,\"sucMs\":0.08489},\"basePrice\":0.0,\"defaultPrice\":301,\"factorExplorationDo\":{\"advertConsumeDay\":38936.0,\"advertConsumeMs\":1036.0,\"adxConsumeDay\":23014.53,\"adxConsumeMs\":968.22,\"bidCntDay\":328831,\"bidCntMs\":22526,\"factorExploreMap\":{\"1\":0.664772,\"2\":0.684772,\"3\":0.764771},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.980946,\"2\":1.012339,\"3\":1.059431},\"lastSucRateMap\":{\"1\":0.239082,\"2\":0.220061,\"3\":0.19964},\"roiDay\":1.691801,\"roiMs\":1.070011,\"sucBidCntDay\":113725,\"sucBidCntMs\":4957,\"sucDay\":0.345847,\"sucMs\":0.220057,\"tryLabel\":0},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":14649,\"advertConsume\":2684,\"adxConsume\":27430290000,\"bid\":67660,\"exp\":9975,\"click\":2428},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":35375.0,\"advertConsumeMs\":291.0,\"adxConsumeDay\":24241.26,\"adxConsumeMs\":173.2,\"adxRoiFactor\":1.021343,\"bidCntDay\":347690,\"bidCntMs\":22924,\"lastRealRoi\":1.680149,\"roiDay\":1.45929,\"roiMs\":1.680149,\"sucBidCntDay\":116674,\"sucBidCntMs\":1946,\"sucDay\":0.33557,\"sucMs\":0.08489},\"lastFactorExplorationDo\":{\"advertConsumeDay\":38936.0,\"advertConsumeMs\":1036.0,\"adxConsumeDay\":23014.53,\"adxConsumeMs\":968.22,\"bidCntDay\":328831,\"bidCntMs\":22526,\"factorExploreMap\":{\"1\":0.664772,\"2\":0.684772,\"3\":0.764771},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.980946,\"2\":1.012339,\"3\":1.059431},\"lastSucRateMap\":{\"1\":0.239082,\"2\":0.220061,\"3\":0.19964},\"roiDay\":1.691801,\"roiMs\":1.070011,\"sucBidCntDay\":113725,\"sucBidCntMs\":4957,\"sucDay\":0.345847,\"sucMs\":0.220057,\"tryLabel\":0},\"lastMinRoi\":1.45,\"lastPriceExplorationDo\":{\"advertConsumeDay\":30836.0,\"advertConsumeMs\":2219.0,\"adxConsumeDay\":19579.03,\"adxConsumeMs\":2417.11,\"bidCntDay\":328254,\"bidCntMs\":22637,\"lastRealRoiMap\":{\"1\":0.833645,\"2\":0.816718,\"3\":0.706509},\"lastSucRateMap\":{\"1\":0.280105,\"2\":0.500953,\"3\":0.517535},\"priceExploreMap\":{\"1\":335,\"2\":372,\"3\":380},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":1.574951,\"roiMs\":0.918043,\"sucBidCntDay\":101355,\"sucBidCntMs\":10945,\"sucDay\":0.308771,\"sucMs\":0.483501,\"tryLabel\":0},\"maxPrice\":503,\"minPrice\":182,\"minRoi\":1.45,\"priceExplorationDo\":{\"advertConsumeDay\":30836.0,\"advertConsumeMs\":2219.0,\"adxConsumeDay\":19579.03,\"adxConsumeMs\":2417.11,\"bidCntDay\":328254,\"bidCntMs\":22637,\"lastRealRoiMap\":{\"1\":0.833645,\"2\":0.816718,\"3\":0.706509},\"lastSucRateMap\":{\"1\":0.280105,\"2\":0.500953,\"3\":0.517535},\"priceExploreMap\":{\"1\":335,\"2\":372,\"3\":380},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":1.574951,\"roiMs\":0.918043,\"sucBidCntDay\":101355,\"sucBidCntMs\":10945,\"sucDay\":0.308771,\"sucMs\":0.483501,\"tryLabel\":0},\"resourceIndexMap\":{\"bidSuc\":85431,\"advertConsume\":14741,\"adxConsume\":153359440000,\"bid\":288309,\"exp\":54824,\"click\":11890},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":116748,\"advertConsume\":35375,\"adxConsume\":242492000000,\"bid\":348875,\"exp\":80382,\"click\":18721}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":10910,\"advertConsume\":4035,\"adxConsume\":18105880000,\"bid\":45091,\"exp\":7164,\"click\":1828}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":64290,\"advertConsume\":19418,\"adxConsume\":119875860000,\"bid\":223747,\"exp\":43640,\"click\":10549}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":29112,\"advertConsume\":7972,\"adxConsume\":64132560000,\"bid\":70513,\"exp\":20515,\"click\":4218}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":32701,\"advertConsume\":11464,\"adxConsume\":69312920000,\"bid\":82906,\"exp\":22382,\"click\":5488}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":70758,\"advertConsume\":24029,\"adxConsume\":140227500000,\"bid\":218093,\"exp\":47908,\"click\":12534}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":11567,\"advertConsume\":3762,\"adxConsume\":22332990000,\"bid\":38831,\"exp\":7811,\"click\":1940}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1920,\"advertConsume\":271,\"adxConsume\":1730810000,\"bid\":22921,\"exp\":1200,\"click\":279}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1052,\"advertConsume\":144,\"adxConsume\":1677950000,\"bid\":4482,\"exp\":639,\"click\":174}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5673,\"advertConsume\":1106,\"adxConsume\":12591690000,\"bid\":13475,\"exp\":3959,\"click\":891}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2250,\"advertConsume\":401,\"adxConsume\":5384380000,\"bid\":4511,\"exp\":1631,\"click\":323}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":522,\"advertConsume\":108,\"adxConsume\":907210000,\"bid\":2781,\"exp\":381,\"click\":107}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":2350,\"advertConsume\":535,\"adxConsume\":3848930000,\"bid\":14554,\"exp\":1634,\"click\":510}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":628,\"advertConsume\":119,\"adxConsume\":775300000,\"bid\":4903,\"exp\":394,\"click\":110}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));
            AdxFlowRateDo ret2 = AdxFlowRate.getAdxFlowRate(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

