/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxLevelDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiFactorDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxRoiFactor {
    private static final Logger logger = LoggerFactory.getLogger(AdxRoiFactor.class);

    public static AdxRoiFactorDo getAdxRoiFactor(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxRoiFactorDo ret = new AdxRoiFactorDo();
        try {
            Double defaultFactor = 1.0;
            Double defaultMinRoi = 1.0;
            Double lowerLimit = 0.3;
            Double upperLimit = 1.7;
            Double tryStep = 0.02;
            Double sucAbsLowLimit = 0.1;
            Double sucAbsUppLimit = 0.95;
            Double sucOppLowLimit = 0.2;
            Double lastRoi = 0.0;
            Double factor = defaultFactor;
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;
            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                Integer feeType = adxRoiControlDoInfo.getFeeType();
                AdxRoiFactorDo lastRoiFactor = adxRoiControlDoInfo.getLastAdxRoiFactorDo();
                if (AssertUtil.isNotEmpty((Object)lastRoiFactor)) {
                    Double lastFactor = lastRoiFactor.getAdxRoiFactor();
                    factor = StrategyBid.getNormalValue(lastFactor, defaultFactor, lowerLimit, upperLimit);
                }
                Long defaultConsume = 0L;
                Long defaultCnt = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategyFirMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategyFirDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_FIR.getCode());
                roiMs = StrategyBid.getRoi(strategyFirMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategyFirMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeMs = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                roiDay = StrategyBid.getRoi(strategyFirDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategyFirDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division((Long)StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), (Long)10000000L, (int)2);
                advertConsumeDay = DataUtil.toDouble((Long)StrategyBid.getSumLevelIndex(strategyFirDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 1L || bidCntMs == 0L) {
                    factor = defaultFactor;
                } else if (sucRateMs < sucAbsLowLimit || sucRateMs <= resoSucRateMs * sucOppLowLimit) {
                    factor = factor + -tryStep.doubleValue();
                } else if (sucRateMs > sucAbsUppLimit) {
                    factor = factor + tryStep;
                } else if (feeType != null && feeType == 1) {
                    Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.97);
                    factor = AdxRoiFactor.getFactorUpdate(factor, roiStable, minRoi, sucRateMs, resoSucRateMs);
                } else {
                    factor = AdxRoiFactor.getFactorUpdate(factor, roiMs, minRoi, sucRateMs, resoSucRateMs);
                }
                lastRoi = roiMs;
            }
            factor = DataUtil.formatDouble((Double)StrategyBid.getNormalValue(factor, defaultFactor, lowerLimit, upperLimit), (int)6);
            ret.setAdxRoiFactor(factor);
            ret.setLastRealRoi(lastRoi);
            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);
            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);
        }
        catch (Exception e) {
            logger.error("AdxRoiFactor.getAdxRoiFactor error:" + e);
        }
        return ret;
    }

    public static Double getFactorUpdate(Double lastValue, Double realRoi, Double targetRoi, Double realSucRate, Double targetSucRate) {
        Double ret = lastValue;
        Double roiLimit = 0.98;
        Double[] roiInterval = new Double[]{0.0, 0.9, 1.1};
        Double[] sucInterval = new Double[]{0.0, 0.8, 0.95};
        Double[] diffList = new Double[]{0.02, 0.05, 0.08, 0.1};
        Double[][] updateMatrix = new Double[][]{{0.03, 0.04, 0.05}, {-0.03, 0.01, 0.01}, {-0.03, -0.02, -0.01}};
        int i = DataUtil.toInt((Long)StrategyBid.bucket(realRoi, targetRoi, roiInterval));
        int j = DataUtil.toInt((Long)StrategyBid.bucket(realSucRate, targetSucRate, sucInterval));
        if (i == 1 && j == 1 || i == 1 && j == 2) {
            Double diff = Math.abs(DataUtil.division((Double)realRoi, (Double)targetRoi, (int)3) - 1.0);
            Double coeff = DataUtil.division((Double)diff, (Double)0.1, (int)3);
            if (realRoi > targetRoi * roiLimit) {
                ret = ret + -updateMatrix[i][j].doubleValue() * coeff;
            } else if (realRoi < targetRoi * roiLimit) {
                ret = ret + updateMatrix[i][j] * coeff;
            }
        } else {
            ret = ret + updateMatrix[i][j];
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            Double[] v1 = new Double[]{0.2, 0.5, 0.8, 1.0};
            System.out.println("ret1:" + JSON.toJSONString((Object)StrategyBid.bucket(0.0, v1)));
            Double v2 = 0.0;
            Double v3 = 1.0;
            Double[] v4 = new Double[]{0.0, 0.9, 1.1};
            System.out.println("bucket2:" + JSON.toJSONString((Object)StrategyBid.bucket(v2, v3, v4)));
            Double f1 = 1.0;
            Double roi1 = 1.177;
            Double roi2 = 1.2;
            Double suc1 = 0.8;
            Double suc2 = 0.8;
            System.out.println("getFactorUpdate:" + JSON.toJSONString((Object)AdxRoiFactor.getFactorUpdate(f1, roi1, roi2, suc1, suc2)));
            String str = "{\"adxRoiFactorDo\":{\"advertConsumeDay\":35375.0,\"advertConsumeMs\":291.0,\"adxConsumeDay\":24241.26,\"adxConsumeMs\":173.2,\"adxRoiFactor\":1.021343,\"bidCntDay\":347690,\"bidCntMs\":22924,\"lastRealRoi\":1.680149,\"roiDay\":1.45929,\"roiMs\":1.680149,\"sucBidCntDay\":116674,\"sucBidCntMs\":1946,\"sucDay\":0.33557,\"sucMs\":0.08489},\"basePrice\":0.0,\"defaultPrice\":301,\"factorExplorationDo\":{\"advertConsumeDay\":38936.0,\"advertConsumeMs\":1036.0,\"adxConsumeDay\":23014.53,\"adxConsumeMs\":968.22,\"bidCntDay\":328831,\"bidCntMs\":22526,\"factorExploreMap\":{\"1\":0.664772,\"2\":0.684772,\"3\":0.764771},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.980946,\"2\":1.012339,\"3\":1.059431},\"lastSucRateMap\":{\"1\":0.239082,\"2\":0.220061,\"3\":0.19964},\"roiDay\":1.691801,\"roiMs\":1.070011,\"sucBidCntDay\":113725,\"sucBidCntMs\":4957,\"sucDay\":0.345847,\"sucMs\":0.220057,\"tryLabel\":0},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":14649,\"advertConsume\":2684,\"adxConsume\":27430290000,\"bid\":67660,\"exp\":9975,\"click\":2428},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":35375.0,\"advertConsumeMs\":291.0,\"adxConsumeDay\":24241.26,\"adxConsumeMs\":173.2,\"adxRoiFactor\":1.021343,\"bidCntDay\":347690,\"bidCntMs\":22924,\"lastRealRoi\":1.680149,\"roiDay\":1.45929,\"roiMs\":1.680149,\"sucBidCntDay\":116674,\"sucBidCntMs\":1946,\"sucDay\":0.33557,\"sucMs\":0.08489},\"lastFactorExplorationDo\":{\"advertConsumeDay\":38936.0,\"advertConsumeMs\":1036.0,\"adxConsumeDay\":23014.53,\"adxConsumeMs\":968.22,\"bidCntDay\":328831,\"bidCntMs\":22526,\"factorExploreMap\":{\"1\":0.664772,\"2\":0.684772,\"3\":0.764771},\"factorFlowRateMap\":{\"1\":0.1,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.980946,\"2\":1.012339,\"3\":1.059431},\"lastSucRateMap\":{\"1\":0.239082,\"2\":0.220061,\"3\":0.19964},\"roiDay\":1.691801,\"roiMs\":1.070011,\"sucBidCntDay\":113725,\"sucBidCntMs\":4957,\"sucDay\":0.345847,\"sucMs\":0.220057,\"tryLabel\":0},\"lastMinRoi\":1.45,\"lastPriceExplorationDo\":{\"advertConsumeDay\":30836.0,\"advertConsumeMs\":2219.0,\"adxConsumeDay\":19579.03,\"adxConsumeMs\":2417.11,\"bidCntDay\":328254,\"bidCntMs\":22637,\"lastRealRoiMap\":{\"1\":0.833645,\"2\":0.816718,\"3\":0.706509},\"lastSucRateMap\":{\"1\":0.280105,\"2\":0.500953,\"3\":0.517535},\"priceExploreMap\":{\"1\":335,\"2\":372,\"3\":380},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":1.574951,\"roiMs\":0.918043,\"sucBidCntDay\":101355,\"sucBidCntMs\":10945,\"sucDay\":0.308771,\"sucMs\":0.483501,\"tryLabel\":0},\"maxPrice\":503,\"minPrice\":182,\"minRoi\":1.45,\"priceExplorationDo\":{\"advertConsumeDay\":30836.0,\"advertConsumeMs\":2219.0,\"adxConsumeDay\":19579.03,\"adxConsumeMs\":2417.11,\"bidCntDay\":328254,\"bidCntMs\":22637,\"lastRealRoiMap\":{\"1\":0.833645,\"2\":0.816718,\"3\":0.706509},\"lastSucRateMap\":{\"1\":0.280105,\"2\":0.500953,\"3\":0.517535},\"priceExploreMap\":{\"1\":335,\"2\":372,\"3\":380},\"priceFlowRateMap\":{\"1\":0.3,\"2\":0.6,\"3\":0.1},\"roiDay\":1.574951,\"roiMs\":0.918043,\"sucBidCntDay\":101355,\"sucBidCntMs\":10945,\"sucDay\":0.308771,\"sucMs\":0.483501,\"tryLabel\":0},\"resourceIndexMap\":{\"bidSuc\":85431,\"advertConsume\":14741,\"adxConsume\":153359440000,\"bid\":288309,\"exp\":54824,\"click\":11890},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":116748,\"advertConsume\":35375,\"adxConsume\":242492000000,\"bid\":348875,\"exp\":80382,\"click\":18721}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":10910,\"advertConsume\":4035,\"adxConsume\":18105880000,\"bid\":45091,\"exp\":7164,\"click\":1828}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":64290,\"advertConsume\":19418,\"adxConsume\":119875860000,\"bid\":223747,\"exp\":43640,\"click\":10549}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":29112,\"advertConsume\":7972,\"adxConsume\":64132560000,\"bid\":70513,\"exp\":20515,\"click\":4218}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":32701,\"advertConsume\":11464,\"adxConsume\":69312920000,\"bid\":82906,\"exp\":22382,\"click\":5488}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":70758,\"advertConsume\":24029,\"adxConsume\":140227500000,\"bid\":218093,\"exp\":47908,\"click\":12534}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":11567,\"advertConsume\":3762,\"adxConsume\":22332990000,\"bid\":38831,\"exp\":7811,\"click\":1940}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":1920,\"advertConsume\":271,\"adxConsume\":1730810000,\"bid\":22921,\"exp\":1200,\"click\":279}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1052,\"advertConsume\":144,\"adxConsume\":1677950000,\"bid\":4482,\"exp\":639,\"click\":174}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5673,\"advertConsume\":1106,\"adxConsume\":12591690000,\"bid\":13475,\"exp\":3959,\"click\":891}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2250,\"advertConsume\":401,\"adxConsume\":5384380000,\"bid\":4511,\"exp\":1631,\"click\":323}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":522,\"advertConsume\":108,\"adxConsume\":907210000,\"bid\":2781,\"exp\":381,\"click\":107}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":2350,\"advertConsume\":535,\"adxConsume\":3848930000,\"bid\":14554,\"exp\":1634,\"click\":510}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":628,\"advertConsume\":119,\"adxConsume\":775300000,\"bid\":4903,\"exp\":394,\"click\":110}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));
            AdxRoiFactorDo ret2 = AdxRoiFactor.getAdxRoiFactor(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

